package name.remal;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;

import static java.util.Collections.emptyList;
import static java.util.Collections.singletonList;
import static name.remal.UncheckedCast.uncheckedCast;

public class ThrowableUtils {

    @NotNull
    private static <T extends Throwable> List<@NotNull T> findImpl(@NotNull Throwable rootThrowable, @NotNull Class<T> type, boolean doReturnOnlyFirst) {
        List<T> result = null;

        Set<Throwable> processedThrowables = new HashSet<>();
        processedThrowables.add(rootThrowable);
        Queue<Throwable> throwablesQueue = new LinkedList<>();
        throwablesQueue.add(rootThrowable);
        while (true) {
            Throwable throwable = throwablesQueue.poll();
            if (null == throwable) break;

            if (type.isInstance(throwable)) {
                if (doReturnOnlyFirst) return singletonList(uncheckedCast(throwable));
                if (null == result) result = new ArrayList<>();
                result.add(uncheckedCast(throwable));
            }

            {
                Throwable cause = throwable.getCause();
                if (null != cause && processedThrowables.add(cause)) throwablesQueue.add(cause);
            }

            for (Throwable supressed : throwable.getSuppressed()) {
                if (processedThrowables.add(supressed)) throwablesQueue.add(supressed);
            }
        }

        return null != result ? result : emptyList();
    }

    @NotNull
    public static <T extends Throwable> List<@NotNull T> findAll(@NotNull Throwable throwable, @NotNull Class<T> type) {
        return findImpl(throwable, type, false);
    }

    @Nullable
    public static <T extends Throwable> T findFirst(@NotNull Throwable throwable, @NotNull Class<T> type) {
        List<T> list = findImpl(throwable, type, true);
        return !list.isEmpty() ? list.get(0) : null;
    }

    public static boolean contains(@NotNull Throwable throwable, @NotNull Class<? extends Throwable> type) {
        return null != findFirst(throwable, type);
    }

}
