package name.remal;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Contract;
@name.remal.gradle_plugins.api.ExcludeFromCodeCoverage
public class StringEscapeUtils {

    @Nullable
    @Contract(value = "null->null; !null->!null", pure = true)
    public static String escapeCsv(@Nullable String string) {
        if (null == string) return null;
        return org.apache.commons.text.StringEscapeUtils.escapeCsv(string);
    }

    @Nullable
    @Contract(value = "null->null; !null->!null", pure = true)
    public static String escapeEcmaScript(@Nullable String string) {
        if (null == string) return null;
        return org.apache.commons.text.StringEscapeUtils.escapeEcmaScript(string);
    }

    @Nullable
    @Contract(value = "null->null; !null->!null", pure = true)
    public static String escapeHtml3(@Nullable String string) {
        if (null == string) return null;
        return org.apache.commons.text.StringEscapeUtils.escapeHtml3(string);
    }

    @Nullable
    @Contract(value = "null->null; !null->!null", pure = true)
    public static String escapeHtml4(@Nullable String string) {
        if (null == string) return null;
        return org.apache.commons.text.StringEscapeUtils.escapeHtml4(string);
    }

    @Nullable
    @Contract(value = "null->null; !null->!null", pure = true)
    public static String escapeJava(@Nullable String string) {
        if (null == string) return null;
        return org.apache.commons.text.StringEscapeUtils.escapeJava(string);
    }

    @Nullable
    @Contract(value = "null->null; !null->!null", pure = true)
    public static String escapeJson(@Nullable String string) {
        if (null == string) return null;
        return org.apache.commons.text.StringEscapeUtils.escapeJson(string);
    }

    @Nullable
    @Contract(value = "null->null; !null->!null", pure = true)
    public static String escapeXSI(@Nullable String string) {
        if (null == string) return null;
        return org.apache.commons.text.StringEscapeUtils.escapeXSI(string);
    }

    @Nullable
    @Contract(value = "null->null; !null->!null", pure = true)
    public static String unescapeCsv(@Nullable String string) {
        if (null == string) return null;
        return org.apache.commons.text.StringEscapeUtils.unescapeCsv(string);
    }

    @Nullable
    @Contract(value = "null->null; !null->!null", pure = true)
    public static String unescapeEcmaScript(@Nullable String string) {
        if (null == string) return null;
        return org.apache.commons.text.StringEscapeUtils.unescapeEcmaScript(string);
    }

    @Nullable
    @Contract(value = "null->null; !null->!null", pure = true)
    public static String unescapeHtml3(@Nullable String string) {
        if (null == string) return null;
        return org.apache.commons.text.StringEscapeUtils.unescapeHtml3(string);
    }

    @Nullable
    @Contract(value = "null->null; !null->!null", pure = true)
    public static String unescapeHtml4(@Nullable String string) {
        if (null == string) return null;
        return org.apache.commons.text.StringEscapeUtils.unescapeHtml4(string);
    }

    @Nullable
    @Contract(value = "null->null; !null->!null", pure = true)
    public static String unescapeJava(@Nullable String string) {
        if (null == string) return null;
        return org.apache.commons.text.StringEscapeUtils.unescapeJava(string);
    }

    @Nullable
    @Contract(value = "null->null; !null->!null", pure = true)
    public static String unescapeJson(@Nullable String string) {
        if (null == string) return null;
        return org.apache.commons.text.StringEscapeUtils.unescapeJson(string);
    }

    @Nullable
    @Contract(value = "null->null; !null->!null", pure = true)
    public static String unescapeXSI(@Nullable String string) {
        if (null == string) return null;
        return org.apache.commons.text.StringEscapeUtils.unescapeXSI(string);
    }

    @Nullable
    @Contract(value = "null->null; !null->!null", pure = true)
    public static String unescapeXml(@Nullable String string) {
        if (null == string) return null;
        return org.apache.commons.text.StringEscapeUtils.unescapeXml(string);
    }

    @Nullable
    @Contract(value = "null->null; !null->!null", pure = true)
    public static String escapeXml10(@Nullable String string) {
        if (null == string) return null;
        return org.apache.commons.text.StringEscapeUtils.escapeXml10(string);
    }

    @Nullable
    @Contract(value = "null->null; !null->!null", pure = true)
    public static String escapeXml11(@Nullable String string) {
        if (null == string) return null;
        return org.apache.commons.text.StringEscapeUtils.escapeXml11(string);
    }

}
