package name.remal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Contract;
import java.util.Arrays;
import java.lang.reflect.Array;
import java.util.Objects;
import static name.remal.UncheckedCast.uncheckedCast;
@SuppressWarnings("SimplifiableIfStatement")
public class ArrayUtils {

    @NotNull
    @Contract(pure = true)
    static boolean[] concatArray(@NotNull boolean[] array1, @NotNull boolean[] array2) {
        if (0 == array1.length) return array2;
        if (0 == array2.length) return array1;
        boolean[] result = new boolean[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    @NotNull
    @Contract(pure = true)
    public static boolean[] concat(@NotNull boolean[] array1, @NotNull boolean... array2) {
        return concatArray(array1, array2);
    }

    @NotNull
    @Contract(pure = true)
    static byte[] concatArray(@NotNull byte[] array1, @NotNull byte[] array2) {
        if (0 == array1.length) return array2;
        if (0 == array2.length) return array1;
        byte[] result = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    @NotNull
    @Contract(pure = true)
    public static byte[] concat(@NotNull byte[] array1, @NotNull byte... array2) {
        return concatArray(array1, array2);
    }

    @NotNull
    @Contract(pure = true)
    static char[] concatArray(@NotNull char[] array1, @NotNull char[] array2) {
        if (0 == array1.length) return array2;
        if (0 == array2.length) return array1;
        char[] result = new char[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    @NotNull
    @Contract(pure = true)
    public static char[] concat(@NotNull char[] array1, @NotNull char... array2) {
        return concatArray(array1, array2);
    }

    @NotNull
    @Contract(pure = true)
    static double[] concatArray(@NotNull double[] array1, @NotNull double[] array2) {
        if (0 == array1.length) return array2;
        if (0 == array2.length) return array1;
        double[] result = new double[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    @NotNull
    @Contract(pure = true)
    public static double[] concat(@NotNull double[] array1, @NotNull double... array2) {
        return concatArray(array1, array2);
    }

    @NotNull
    @Contract(pure = true)
    static float[] concatArray(@NotNull float[] array1, @NotNull float[] array2) {
        if (0 == array1.length) return array2;
        if (0 == array2.length) return array1;
        float[] result = new float[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    @NotNull
    @Contract(pure = true)
    public static float[] concat(@NotNull float[] array1, @NotNull float... array2) {
        return concatArray(array1, array2);
    }

    @NotNull
    @Contract(pure = true)
    static int[] concatArray(@NotNull int[] array1, @NotNull int[] array2) {
        if (0 == array1.length) return array2;
        if (0 == array2.length) return array1;
        int[] result = new int[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    @NotNull
    @Contract(pure = true)
    public static int[] concat(@NotNull int[] array1, @NotNull int... array2) {
        return concatArray(array1, array2);
    }

    @NotNull
    @Contract(pure = true)
    static long[] concatArray(@NotNull long[] array1, @NotNull long[] array2) {
        if (0 == array1.length) return array2;
        if (0 == array2.length) return array1;
        long[] result = new long[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    @NotNull
    @Contract(pure = true)
    public static long[] concat(@NotNull long[] array1, @NotNull long... array2) {
        return concatArray(array1, array2);
    }

    @NotNull
    @Contract(pure = true)
    static short[] concatArray(@NotNull short[] array1, @NotNull short[] array2) {
        if (0 == array1.length) return array2;
        if (0 == array2.length) return array1;
        short[] result = new short[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    @NotNull
    @Contract(pure = true)
    public static short[] concat(@NotNull short[] array1, @NotNull short... array2) {
        return concatArray(array1, array2);
    }

    @NotNull
    @Contract(pure = true)
    static <T, O extends T> T[] concatArray(@NotNull T[] array1, @NotNull O[] array2) {
        Class<?> type = array1.getClass().getComponentType();
        Class<?> otherType = array2.getClass().getComponentType();
        if (!type.isAssignableFrom(otherType)) throw new IllegalArgumentException("Array of " + type + " can't be concatenated with array of " + otherType);
        if (0 == array1.length) return array2;
        if (0 == array2.length) return array1;
        T[] result = uncheckedCast(Array.newInstance(type, array1.length + array2.length));
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    @NotNull
    @SafeVarargs
    @Contract(pure = true)
    public static <T, O extends T> T[] concat(@NotNull T[] array1, @NotNull O... array2) {
        return concatArray(array1, array2);
    }

    @Contract(value = "null,null->true; null,!null->false; !null,null->false", pure = true)
    public static boolean arrayEquals(@Nullable boolean[] array1, @Nullable boolean[] array2) {
        if (array1 == array2) return true;
        if (null == array1 || null == array2) return false;
        return Arrays.equals(array1, array2);
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable boolean[] array1, @Nullable byte[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable boolean[] array1, @Nullable char[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable boolean[] array1, @Nullable double[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable boolean[] array1, @Nullable float[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable boolean[] array1, @Nullable int[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable boolean[] array1, @Nullable long[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable boolean[] array1, @Nullable short[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable byte[] array1, @Nullable boolean[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; null,!null->false; !null,null->false", pure = true)
    public static boolean arrayEquals(@Nullable byte[] array1, @Nullable byte[] array2) {
        if (array1 == array2) return true;
        if (null == array1 || null == array2) return false;
        return Arrays.equals(array1, array2);
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable byte[] array1, @Nullable char[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable byte[] array1, @Nullable double[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable byte[] array1, @Nullable float[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable byte[] array1, @Nullable int[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable byte[] array1, @Nullable long[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable byte[] array1, @Nullable short[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable char[] array1, @Nullable boolean[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable char[] array1, @Nullable byte[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; null,!null->false; !null,null->false", pure = true)
    public static boolean arrayEquals(@Nullable char[] array1, @Nullable char[] array2) {
        if (array1 == array2) return true;
        if (null == array1 || null == array2) return false;
        return Arrays.equals(array1, array2);
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable char[] array1, @Nullable double[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable char[] array1, @Nullable float[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable char[] array1, @Nullable int[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable char[] array1, @Nullable long[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable char[] array1, @Nullable short[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable double[] array1, @Nullable boolean[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable double[] array1, @Nullable byte[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable double[] array1, @Nullable char[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; null,!null->false; !null,null->false", pure = true)
    public static boolean arrayEquals(@Nullable double[] array1, @Nullable double[] array2) {
        if (array1 == array2) return true;
        if (null == array1 || null == array2) return false;
        return Arrays.equals(array1, array2);
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable double[] array1, @Nullable float[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable double[] array1, @Nullable int[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable double[] array1, @Nullable long[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable double[] array1, @Nullable short[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable float[] array1, @Nullable boolean[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable float[] array1, @Nullable byte[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable float[] array1, @Nullable char[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable float[] array1, @Nullable double[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; null,!null->false; !null,null->false", pure = true)
    public static boolean arrayEquals(@Nullable float[] array1, @Nullable float[] array2) {
        if (array1 == array2) return true;
        if (null == array1 || null == array2) return false;
        return Arrays.equals(array1, array2);
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable float[] array1, @Nullable int[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable float[] array1, @Nullable long[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable float[] array1, @Nullable short[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable int[] array1, @Nullable boolean[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable int[] array1, @Nullable byte[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable int[] array1, @Nullable char[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable int[] array1, @Nullable double[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable int[] array1, @Nullable float[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; null,!null->false; !null,null->false", pure = true)
    public static boolean arrayEquals(@Nullable int[] array1, @Nullable int[] array2) {
        if (array1 == array2) return true;
        if (null == array1 || null == array2) return false;
        return Arrays.equals(array1, array2);
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable int[] array1, @Nullable long[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable int[] array1, @Nullable short[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable long[] array1, @Nullable boolean[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable long[] array1, @Nullable byte[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable long[] array1, @Nullable char[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable long[] array1, @Nullable double[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable long[] array1, @Nullable float[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable long[] array1, @Nullable int[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; null,!null->false; !null,null->false", pure = true)
    public static boolean arrayEquals(@Nullable long[] array1, @Nullable long[] array2) {
        if (array1 == array2) return true;
        if (null == array1 || null == array2) return false;
        return Arrays.equals(array1, array2);
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable long[] array1, @Nullable short[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable short[] array1, @Nullable boolean[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable short[] array1, @Nullable byte[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable short[] array1, @Nullable char[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable short[] array1, @Nullable double[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable short[] array1, @Nullable float[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable short[] array1, @Nullable int[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; _,!null->false; !null,_->false", pure = true)
    public static boolean arrayEquals(@Nullable short[] array1, @Nullable long[] array2) {
        return null == array1 && null == array2;
    }

    @Contract(value = "null,null->true; null,!null->false; !null,null->false", pure = true)
    public static boolean arrayEquals(@Nullable short[] array1, @Nullable short[] array2) {
        if (array1 == array2) return true;
        if (null == array1 || null == array2) return false;
        return Arrays.equals(array1, array2);
    }

    @Contract(value = "null,null->true; null,!null->false; !null,null->false", pure = true)
    public static boolean arrayEquals(@Nullable Object[] array1, @Nullable Object[] array2) {
        if (array1 == array2) return true;
        if (null == array1 || null == array2) return false;
        return Arrays.deepEquals(array1, array2);
    }

    @Contract(value = "null,null->true; null,!null->false; !null,null->false", pure = true)
    public static boolean arrayEquals(@Nullable Object array1, @Nullable Object array2) {
        if (array1 == array2) return true;
        if (null == array1 || null == array2) return false;
        if (array1 instanceof boolean[] && array2 instanceof boolean[]) return Arrays.equals((boolean[]) array1, (boolean[]) array2);
        if (array1 instanceof byte[] && array2 instanceof byte[]) return Arrays.equals((byte[]) array1, (byte[]) array2);
        if (array1 instanceof char[] && array2 instanceof char[]) return Arrays.equals((char[]) array1, (char[]) array2);
        if (array1 instanceof double[] && array2 instanceof double[]) return Arrays.equals((double[]) array1, (double[]) array2);
        if (array1 instanceof float[] && array2 instanceof float[]) return Arrays.equals((float[]) array1, (float[]) array2);
        if (array1 instanceof int[] && array2 instanceof int[]) return Arrays.equals((int[]) array1, (int[]) array2);
        if (array1 instanceof long[] && array2 instanceof long[]) return Arrays.equals((long[]) array1, (long[]) array2);
        if (array1 instanceof short[] && array2 instanceof short[]) return Arrays.equals((short[]) array1, (short[]) array2);
        if (array1 instanceof Object[] && array2 instanceof Object[]) return Arrays.deepEquals((Object[]) array1, (Object[]) array2);
        return array1.equals(array2);
    }

    @Contract(pure = true)
    static int arrayHashCodeArray(@Nullable boolean[] array) {
        if (null == array) return 0;
        return Arrays.hashCode(array);
    }

    @Contract(pure = true)
    public static int arrayHashCode(@Nullable boolean... array) {
        return arrayHashCodeArray(array);
    }

    @Contract(pure = true)
    static int arrayHashCodeArray(@Nullable byte[] array) {
        if (null == array) return 0;
        return Arrays.hashCode(array);
    }

    @Contract(pure = true)
    public static int arrayHashCode(@Nullable byte... array) {
        return arrayHashCodeArray(array);
    }

    @Contract(pure = true)
    static int arrayHashCodeArray(@Nullable char[] array) {
        if (null == array) return 0;
        return Arrays.hashCode(array);
    }

    @Contract(pure = true)
    public static int arrayHashCode(@Nullable char... array) {
        return arrayHashCodeArray(array);
    }

    @Contract(pure = true)
    static int arrayHashCodeArray(@Nullable double[] array) {
        if (null == array) return 0;
        return Arrays.hashCode(array);
    }

    @Contract(pure = true)
    public static int arrayHashCode(@Nullable double... array) {
        return arrayHashCodeArray(array);
    }

    @Contract(pure = true)
    static int arrayHashCodeArray(@Nullable float[] array) {
        if (null == array) return 0;
        return Arrays.hashCode(array);
    }

    @Contract(pure = true)
    public static int arrayHashCode(@Nullable float... array) {
        return arrayHashCodeArray(array);
    }

    @Contract(pure = true)
    static int arrayHashCodeArray(@Nullable int[] array) {
        if (null == array) return 0;
        return Arrays.hashCode(array);
    }

    @Contract(pure = true)
    public static int arrayHashCode(@Nullable int... array) {
        return arrayHashCodeArray(array);
    }

    @Contract(pure = true)
    static int arrayHashCodeArray(@Nullable long[] array) {
        if (null == array) return 0;
        return Arrays.hashCode(array);
    }

    @Contract(pure = true)
    public static int arrayHashCode(@Nullable long... array) {
        return arrayHashCodeArray(array);
    }

    @Contract(pure = true)
    static int arrayHashCodeArray(@Nullable short[] array) {
        if (null == array) return 0;
        return Arrays.hashCode(array);
    }

    @Contract(pure = true)
    public static int arrayHashCode(@Nullable short... array) {
        return arrayHashCodeArray(array);
    }

    @Contract(pure = true)
    static int arrayHashCodeArray(@Nullable Object[] array) {
        if (null == array) return 0;
        return Arrays.deepHashCode(array);
    }

    @Contract(pure = true)
    public static int arrayHashCode(@Nullable Object... array) {
        return arrayHashCodeArray(array);
    }

    @Contract(pure = true)
    public static int arrayHashCode(@Nullable Object array) {
        if (null == array) return 0;
        if (array instanceof boolean[]) return Arrays.hashCode((boolean[]) array);
        if (array instanceof byte[]) return Arrays.hashCode((byte[]) array);
        if (array instanceof char[]) return Arrays.hashCode((char[]) array);
        if (array instanceof double[]) return Arrays.hashCode((double[]) array);
        if (array instanceof float[]) return Arrays.hashCode((float[]) array);
        if (array instanceof int[]) return Arrays.hashCode((int[]) array);
        if (array instanceof long[]) return Arrays.hashCode((long[]) array);
        if (array instanceof short[]) return Arrays.hashCode((short[]) array);
        if (array instanceof Object[]) return Arrays.deepHashCode((Object[]) array);
        return array.hashCode();
    }


    @NotNull
    @Contract(pure = true)
    static String arrayToStringArray(@Nullable boolean[] array) {
        if (null == array) return "null";
        return Arrays.toString(array);
    }

    @NotNull
    @Contract(pure = true)
    public static String arrayToString(@Nullable boolean... array) {
        return arrayToStringArray(array);
    }

    @NotNull
    @Contract(pure = true)
    static String arrayToStringArray(@Nullable byte[] array) {
        if (null == array) return "null";
        return Arrays.toString(array);
    }

    @NotNull
    @Contract(pure = true)
    public static String arrayToString(@Nullable byte... array) {
        return arrayToStringArray(array);
    }

    @NotNull
    @Contract(pure = true)
    static String arrayToStringArray(@Nullable char[] array) {
        if (null == array) return "null";
        return Arrays.toString(array);
    }

    @NotNull
    @Contract(pure = true)
    public static String arrayToString(@Nullable char... array) {
        return arrayToStringArray(array);
    }

    @NotNull
    @Contract(pure = true)
    static String arrayToStringArray(@Nullable double[] array) {
        if (null == array) return "null";
        return Arrays.toString(array);
    }

    @NotNull
    @Contract(pure = true)
    public static String arrayToString(@Nullable double... array) {
        return arrayToStringArray(array);
    }

    @NotNull
    @Contract(pure = true)
    static String arrayToStringArray(@Nullable float[] array) {
        if (null == array) return "null";
        return Arrays.toString(array);
    }

    @NotNull
    @Contract(pure = true)
    public static String arrayToString(@Nullable float... array) {
        return arrayToStringArray(array);
    }

    @NotNull
    @Contract(pure = true)
    static String arrayToStringArray(@Nullable int[] array) {
        if (null == array) return "null";
        return Arrays.toString(array);
    }

    @NotNull
    @Contract(pure = true)
    public static String arrayToString(@Nullable int... array) {
        return arrayToStringArray(array);
    }

    @NotNull
    @Contract(pure = true)
    static String arrayToStringArray(@Nullable long[] array) {
        if (null == array) return "null";
        return Arrays.toString(array);
    }

    @NotNull
    @Contract(pure = true)
    public static String arrayToString(@Nullable long... array) {
        return arrayToStringArray(array);
    }

    @NotNull
    @Contract(pure = true)
    static String arrayToStringArray(@Nullable short[] array) {
        if (null == array) return "null";
        return Arrays.toString(array);
    }

    @NotNull
    @Contract(pure = true)
    public static String arrayToString(@Nullable short... array) {
        return arrayToStringArray(array);
    }

    @NotNull
    @Contract(pure = true)
    static String arrayToStringArray(@Nullable Object[] array) {
        if (null == array) return "null";
        return Arrays.deepToString(array);
    }

    @NotNull
    @Contract(pure = true)
    public static String arrayToString(@Nullable Object... array) {
        return arrayToStringArray(array);
    }

    @NotNull
    @Contract(pure = true)
    public static String arrayToString(@Nullable Object array) {
        if (null == array) return "null";
        if (array instanceof boolean[]) return Arrays.toString((boolean[]) array);
        if (array instanceof byte[]) return Arrays.toString((byte[]) array);
        if (array instanceof char[]) return Arrays.toString((char[]) array);
        if (array instanceof double[]) return Arrays.toString((double[]) array);
        if (array instanceof float[]) return Arrays.toString((float[]) array);
        if (array instanceof int[]) return Arrays.toString((int[]) array);
        if (array instanceof long[]) return Arrays.toString((long[]) array);
        if (array instanceof short[]) return Arrays.toString((short[]) array);
        if (array instanceof Object[]) return Arrays.deepToString((Object[]) array);
        return array.toString();
    }

    @Contract(pure = true)
    static boolean startsWithArray(@NotNull boolean[] array, @NotNull boolean[] other) {
        if (0 == other.length) return true;
        if (array.length < other.length) return false;
        for (int i = 0; i < other.length; ++i) { if (array[i] != other[i]) return false; }
        return true;
    }

    @Contract(pure = true)
    public static boolean startsWith(@NotNull boolean[] array, @NotNull boolean... other) {
        return startsWithArray(array, other);
    }

    @Contract(pure = true)
    static boolean startsWithArray(@NotNull byte[] array, @NotNull byte[] other) {
        if (0 == other.length) return true;
        if (array.length < other.length) return false;
        for (int i = 0; i < other.length; ++i) { if (array[i] != other[i]) return false; }
        return true;
    }

    @Contract(pure = true)
    public static boolean startsWith(@NotNull byte[] array, @NotNull byte... other) {
        return startsWithArray(array, other);
    }

    @Contract(pure = true)
    static boolean startsWithArray(@NotNull char[] array, @NotNull char[] other) {
        if (0 == other.length) return true;
        if (array.length < other.length) return false;
        for (int i = 0; i < other.length; ++i) { if (array[i] != other[i]) return false; }
        return true;
    }

    @Contract(pure = true)
    public static boolean startsWith(@NotNull char[] array, @NotNull char... other) {
        return startsWithArray(array, other);
    }

    @Contract(pure = true)
    static boolean startsWithArray(@NotNull double[] array, @NotNull double[] other) {
        if (0 == other.length) return true;
        if (array.length < other.length) return false;
        for (int i = 0; i < other.length; ++i) { if (array[i] != other[i]) return false; }
        return true;
    }

    @Contract(pure = true)
    public static boolean startsWith(@NotNull double[] array, @NotNull double... other) {
        return startsWithArray(array, other);
    }

    @Contract(pure = true)
    static boolean startsWithArray(@NotNull float[] array, @NotNull float[] other) {
        if (0 == other.length) return true;
        if (array.length < other.length) return false;
        for (int i = 0; i < other.length; ++i) { if (array[i] != other[i]) return false; }
        return true;
    }

    @Contract(pure = true)
    public static boolean startsWith(@NotNull float[] array, @NotNull float... other) {
        return startsWithArray(array, other);
    }

    @Contract(pure = true)
    static boolean startsWithArray(@NotNull int[] array, @NotNull int[] other) {
        if (0 == other.length) return true;
        if (array.length < other.length) return false;
        for (int i = 0; i < other.length; ++i) { if (array[i] != other[i]) return false; }
        return true;
    }

    @Contract(pure = true)
    public static boolean startsWith(@NotNull int[] array, @NotNull int... other) {
        return startsWithArray(array, other);
    }

    @Contract(pure = true)
    static boolean startsWithArray(@NotNull long[] array, @NotNull long[] other) {
        if (0 == other.length) return true;
        if (array.length < other.length) return false;
        for (int i = 0; i < other.length; ++i) { if (array[i] != other[i]) return false; }
        return true;
    }

    @Contract(pure = true)
    public static boolean startsWith(@NotNull long[] array, @NotNull long... other) {
        return startsWithArray(array, other);
    }

    @Contract(pure = true)
    static boolean startsWithArray(@NotNull short[] array, @NotNull short[] other) {
        if (0 == other.length) return true;
        if (array.length < other.length) return false;
        for (int i = 0; i < other.length; ++i) { if (array[i] != other[i]) return false; }
        return true;
    }

    @Contract(pure = true)
    public static boolean startsWith(@NotNull short[] array, @NotNull short... other) {
        return startsWithArray(array, other);
    }

    @Contract(pure = true)
    static <T, O extends T> boolean startsWithArray(@NotNull T[] array, @NotNull O[] other) {
        if (0 == other.length) return true;
        if (array.length < other.length) return false;
        for (int i = 0; i < other.length; ++i) { if (!arrayEquals(array[i], other[i])) return false; }
        return true;
    }

    @SafeVarargs
    @Contract(pure = true)
    public static <T, O extends T> boolean startsWith(@NotNull T[] array, @NotNull O... other) {
        return startsWithArray(array, other);
    }

    @Contract(pure = true)
    static boolean endsWithArray(@NotNull boolean[] array, @NotNull boolean[] other) {
        if (0 == other.length) return true;
        if (array.length < other.length) return false;
        for (int n = 1; n <= other.length; ++n) { if (array[array.length - n] != other[other.length - n]) return false; }
        return true;
    }

    @Contract(pure = true)
    public static boolean endsWith(@NotNull boolean[] array, @NotNull boolean... other) {
        return endsWithArray(array, other);
    }

    @Contract(pure = true)
    static boolean endsWithArray(@NotNull byte[] array, @NotNull byte[] other) {
        if (0 == other.length) return true;
        if (array.length < other.length) return false;
        for (int n = 1; n <= other.length; ++n) { if (array[array.length - n] != other[other.length - n]) return false; }
        return true;
    }

    @Contract(pure = true)
    public static boolean endsWith(@NotNull byte[] array, @NotNull byte... other) {
        return endsWithArray(array, other);
    }

    @Contract(pure = true)
    static boolean endsWithArray(@NotNull char[] array, @NotNull char[] other) {
        if (0 == other.length) return true;
        if (array.length < other.length) return false;
        for (int n = 1; n <= other.length; ++n) { if (array[array.length - n] != other[other.length - n]) return false; }
        return true;
    }

    @Contract(pure = true)
    public static boolean endsWith(@NotNull char[] array, @NotNull char... other) {
        return endsWithArray(array, other);
    }

    @Contract(pure = true)
    static boolean endsWithArray(@NotNull double[] array, @NotNull double[] other) {
        if (0 == other.length) return true;
        if (array.length < other.length) return false;
        for (int n = 1; n <= other.length; ++n) { if (array[array.length - n] != other[other.length - n]) return false; }
        return true;
    }

    @Contract(pure = true)
    public static boolean endsWith(@NotNull double[] array, @NotNull double... other) {
        return endsWithArray(array, other);
    }

    @Contract(pure = true)
    static boolean endsWithArray(@NotNull float[] array, @NotNull float[] other) {
        if (0 == other.length) return true;
        if (array.length < other.length) return false;
        for (int n = 1; n <= other.length; ++n) { if (array[array.length - n] != other[other.length - n]) return false; }
        return true;
    }

    @Contract(pure = true)
    public static boolean endsWith(@NotNull float[] array, @NotNull float... other) {
        return endsWithArray(array, other);
    }

    @Contract(pure = true)
    static boolean endsWithArray(@NotNull int[] array, @NotNull int[] other) {
        if (0 == other.length) return true;
        if (array.length < other.length) return false;
        for (int n = 1; n <= other.length; ++n) { if (array[array.length - n] != other[other.length - n]) return false; }
        return true;
    }

    @Contract(pure = true)
    public static boolean endsWith(@NotNull int[] array, @NotNull int... other) {
        return endsWithArray(array, other);
    }

    @Contract(pure = true)
    static boolean endsWithArray(@NotNull long[] array, @NotNull long[] other) {
        if (0 == other.length) return true;
        if (array.length < other.length) return false;
        for (int n = 1; n <= other.length; ++n) { if (array[array.length - n] != other[other.length - n]) return false; }
        return true;
    }

    @Contract(pure = true)
    public static boolean endsWith(@NotNull long[] array, @NotNull long... other) {
        return endsWithArray(array, other);
    }

    @Contract(pure = true)
    static boolean endsWithArray(@NotNull short[] array, @NotNull short[] other) {
        if (0 == other.length) return true;
        if (array.length < other.length) return false;
        for (int n = 1; n <= other.length; ++n) { if (array[array.length - n] != other[other.length - n]) return false; }
        return true;
    }

    @Contract(pure = true)
    public static boolean endsWith(@NotNull short[] array, @NotNull short... other) {
        return endsWithArray(array, other);
    }

    @Contract(pure = true)
    static <T, O extends T> boolean endsWithArray(@NotNull T[] array, @NotNull O[] other) {
        if (0 == other.length) return true;
        if (array.length < other.length) return false;
        for (int n = 1; n <= other.length; ++n) { if (!arrayEquals(array[array.length - n], other[other.length - n])) return false; }
        return true;
    }

    @SafeVarargs
    @Contract(pure = true)
    public static <T, O extends T> boolean endsWith(@NotNull T[] array, @NotNull O... other) {
        return endsWithArray(array, other);
    }

    @Contract(pure = true)
    static int indexOfArray(@NotNull boolean[] array, @NotNull boolean[] other) {
        if (0 == other.length) return 0;
        if (array.length < other.length) return -1;
        for (int i = 0; i < array.length - other.length + 1; ++i) {
            for (int g = 0; g < other.length; ++g) {
                if (array[i] == other[g]) {
                    if (g == other.length - 1) return i;
                } else {
                    break;
                }
            }
        }
        return -1;
    }

    @Contract(pure = true)
    public static int indexOf(@NotNull boolean[] array, @NotNull boolean... other) {
        return indexOfArray(array, other);
    }

    @Contract(pure = true)
    static int indexOfArray(@NotNull byte[] array, @NotNull byte[] other) {
        if (0 == other.length) return 0;
        if (array.length < other.length) return -1;
        for (int i = 0; i < array.length - other.length + 1; ++i) {
            for (int g = 0; g < other.length; ++g) {
                if (array[i] == other[g]) {
                    if (g == other.length - 1) return i;
                } else {
                    break;
                }
            }
        }
        return -1;
    }

    @Contract(pure = true)
    public static int indexOf(@NotNull byte[] array, @NotNull byte... other) {
        return indexOfArray(array, other);
    }

    @Contract(pure = true)
    static int indexOfArray(@NotNull char[] array, @NotNull char[] other) {
        if (0 == other.length) return 0;
        if (array.length < other.length) return -1;
        for (int i = 0; i < array.length - other.length + 1; ++i) {
            for (int g = 0; g < other.length; ++g) {
                if (array[i] == other[g]) {
                    if (g == other.length - 1) return i;
                } else {
                    break;
                }
            }
        }
        return -1;
    }

    @Contract(pure = true)
    public static int indexOf(@NotNull char[] array, @NotNull char... other) {
        return indexOfArray(array, other);
    }

    @Contract(pure = true)
    static int indexOfArray(@NotNull double[] array, @NotNull double[] other) {
        if (0 == other.length) return 0;
        if (array.length < other.length) return -1;
        for (int i = 0; i < array.length - other.length + 1; ++i) {
            for (int g = 0; g < other.length; ++g) {
                if (array[i] == other[g]) {
                    if (g == other.length - 1) return i;
                } else {
                    break;
                }
            }
        }
        return -1;
    }

    @Contract(pure = true)
    public static int indexOf(@NotNull double[] array, @NotNull double... other) {
        return indexOfArray(array, other);
    }

    @Contract(pure = true)
    static int indexOfArray(@NotNull float[] array, @NotNull float[] other) {
        if (0 == other.length) return 0;
        if (array.length < other.length) return -1;
        for (int i = 0; i < array.length - other.length + 1; ++i) {
            for (int g = 0; g < other.length; ++g) {
                if (array[i] == other[g]) {
                    if (g == other.length - 1) return i;
                } else {
                    break;
                }
            }
        }
        return -1;
    }

    @Contract(pure = true)
    public static int indexOf(@NotNull float[] array, @NotNull float... other) {
        return indexOfArray(array, other);
    }

    @Contract(pure = true)
    static int indexOfArray(@NotNull int[] array, @NotNull int[] other) {
        if (0 == other.length) return 0;
        if (array.length < other.length) return -1;
        for (int i = 0; i < array.length - other.length + 1; ++i) {
            for (int g = 0; g < other.length; ++g) {
                if (array[i] == other[g]) {
                    if (g == other.length - 1) return i;
                } else {
                    break;
                }
            }
        }
        return -1;
    }

    @Contract(pure = true)
    public static int indexOf(@NotNull int[] array, @NotNull int... other) {
        return indexOfArray(array, other);
    }

    @Contract(pure = true)
    static int indexOfArray(@NotNull long[] array, @NotNull long[] other) {
        if (0 == other.length) return 0;
        if (array.length < other.length) return -1;
        for (int i = 0; i < array.length - other.length + 1; ++i) {
            for (int g = 0; g < other.length; ++g) {
                if (array[i] == other[g]) {
                    if (g == other.length - 1) return i;
                } else {
                    break;
                }
            }
        }
        return -1;
    }

    @Contract(pure = true)
    public static int indexOf(@NotNull long[] array, @NotNull long... other) {
        return indexOfArray(array, other);
    }

    @Contract(pure = true)
    static int indexOfArray(@NotNull short[] array, @NotNull short[] other) {
        if (0 == other.length) return 0;
        if (array.length < other.length) return -1;
        for (int i = 0; i < array.length - other.length + 1; ++i) {
            for (int g = 0; g < other.length; ++g) {
                if (array[i] == other[g]) {
                    if (g == other.length - 1) return i;
                } else {
                    break;
                }
            }
        }
        return -1;
    }

    @Contract(pure = true)
    public static int indexOf(@NotNull short[] array, @NotNull short... other) {
        return indexOfArray(array, other);
    }

    @Contract(pure = true)
    static <T, O extends T> int indexOfArray(@NotNull T[] array, @NotNull O[] other) {
        if (0 == other.length) return 0;
        if (array.length < other.length) return -1;
        for (int i = 0; i < array.length - other.length + 1; ++i) {
            for (int g = 0; g < other.length; ++g) {
                if (arrayEquals(array[i], other[g])) {
                    if (g == other.length - 1) return i;
                } else {
                    break;
                }
            }
        }
        return -1;
    }

    @SafeVarargs
    @Contract(pure = true)
    public static <T, O extends T> int indexOf(@NotNull T[] array, @NotNull O... other) {
        return indexOfArray(array, other);
    }

    @Contract(pure = true)
    static boolean containsArray(@NotNull boolean[] array, @NotNull boolean[] other) {
        return 0 <= indexOfArray(array, other);
    }

    @Contract(pure = true)
    public static boolean contains(@NotNull boolean[] array, @NotNull boolean... other) {
        return containsArray(array, other);
    }

    @Contract(pure = true)
    static boolean containsArray(@NotNull byte[] array, @NotNull byte[] other) {
        return 0 <= indexOfArray(array, other);
    }

    @Contract(pure = true)
    public static boolean contains(@NotNull byte[] array, @NotNull byte... other) {
        return containsArray(array, other);
    }

    @Contract(pure = true)
    static boolean containsArray(@NotNull char[] array, @NotNull char[] other) {
        return 0 <= indexOfArray(array, other);
    }

    @Contract(pure = true)
    public static boolean contains(@NotNull char[] array, @NotNull char... other) {
        return containsArray(array, other);
    }

    @Contract(pure = true)
    static boolean containsArray(@NotNull double[] array, @NotNull double[] other) {
        return 0 <= indexOfArray(array, other);
    }

    @Contract(pure = true)
    public static boolean contains(@NotNull double[] array, @NotNull double... other) {
        return containsArray(array, other);
    }

    @Contract(pure = true)
    static boolean containsArray(@NotNull float[] array, @NotNull float[] other) {
        return 0 <= indexOfArray(array, other);
    }

    @Contract(pure = true)
    public static boolean contains(@NotNull float[] array, @NotNull float... other) {
        return containsArray(array, other);
    }

    @Contract(pure = true)
    static boolean containsArray(@NotNull int[] array, @NotNull int[] other) {
        return 0 <= indexOfArray(array, other);
    }

    @Contract(pure = true)
    public static boolean contains(@NotNull int[] array, @NotNull int... other) {
        return containsArray(array, other);
    }

    @Contract(pure = true)
    static boolean containsArray(@NotNull long[] array, @NotNull long[] other) {
        return 0 <= indexOfArray(array, other);
    }

    @Contract(pure = true)
    public static boolean contains(@NotNull long[] array, @NotNull long... other) {
        return containsArray(array, other);
    }

    @Contract(pure = true)
    static boolean containsArray(@NotNull short[] array, @NotNull short[] other) {
        return 0 <= indexOfArray(array, other);
    }

    @Contract(pure = true)
    public static boolean contains(@NotNull short[] array, @NotNull short... other) {
        return containsArray(array, other);
    }

    @Contract(pure = true)
    static <T, O extends T> boolean containsArray(@NotNull T[] array, @NotNull O[] other) {
        return 0 <= indexOfArray(array, other);
    }

    @SafeVarargs
    @Contract(pure = true)
    public static <T, O extends T> boolean contains(@NotNull T[] array, @NotNull O... other) {
        return containsArray(array, other);
    }

    @Contract(pure = true)
    public static boolean startsWith(@NotNull boolean[] array, boolean value) {
        return 1 <= array.length && array[0] == value;
    }

    @Contract(pure = true)
    public static boolean endsWith(@NotNull boolean[] array, boolean value) {
        return 1 <= array.length && array[array.length - 1] == value;
    }

    @Contract(pure = true)
    public static int indexOf(@NotNull boolean[] array, boolean value) {
        for (int i = 0; i < array.length; ++i) {
            if (value == array[i]) return i;
        }
        return -1;
    }

    @Contract(pure = true)
    public static boolean contains(@NotNull boolean[] array, boolean value) {
        return 0 <= indexOf(array, value);
    }

    @Contract(pure = true)
    public static boolean startsWith(@NotNull byte[] array, byte value) {
        return 1 <= array.length && array[0] == value;
    }

    @Contract(pure = true)
    public static boolean endsWith(@NotNull byte[] array, byte value) {
        return 1 <= array.length && array[array.length - 1] == value;
    }

    @Contract(pure = true)
    public static int indexOf(@NotNull byte[] array, byte value) {
        for (int i = 0; i < array.length; ++i) {
            if (value == array[i]) return i;
        }
        return -1;
    }

    @Contract(pure = true)
    public static boolean contains(@NotNull byte[] array, byte value) {
        return 0 <= indexOf(array, value);
    }

    @Contract(pure = true)
    public static boolean startsWith(@NotNull char[] array, char value) {
        return 1 <= array.length && array[0] == value;
    }

    @Contract(pure = true)
    public static boolean endsWith(@NotNull char[] array, char value) {
        return 1 <= array.length && array[array.length - 1] == value;
    }

    @Contract(pure = true)
    public static int indexOf(@NotNull char[] array, char value) {
        for (int i = 0; i < array.length; ++i) {
            if (value == array[i]) return i;
        }
        return -1;
    }

    @Contract(pure = true)
    public static boolean contains(@NotNull char[] array, char value) {
        return 0 <= indexOf(array, value);
    }

    @Contract(pure = true)
    public static boolean startsWith(@NotNull double[] array, double value) {
        return 1 <= array.length && array[0] == value;
    }

    @Contract(pure = true)
    public static boolean endsWith(@NotNull double[] array, double value) {
        return 1 <= array.length && array[array.length - 1] == value;
    }

    @Contract(pure = true)
    public static int indexOf(@NotNull double[] array, double value) {
        for (int i = 0; i < array.length; ++i) {
            if (value == array[i]) return i;
        }
        return -1;
    }

    @Contract(pure = true)
    public static boolean contains(@NotNull double[] array, double value) {
        return 0 <= indexOf(array, value);
    }

    @Contract(pure = true)
    public static boolean startsWith(@NotNull float[] array, float value) {
        return 1 <= array.length && array[0] == value;
    }

    @Contract(pure = true)
    public static boolean endsWith(@NotNull float[] array, float value) {
        return 1 <= array.length && array[array.length - 1] == value;
    }

    @Contract(pure = true)
    public static int indexOf(@NotNull float[] array, float value) {
        for (int i = 0; i < array.length; ++i) {
            if (value == array[i]) return i;
        }
        return -1;
    }

    @Contract(pure = true)
    public static boolean contains(@NotNull float[] array, float value) {
        return 0 <= indexOf(array, value);
    }

    @Contract(pure = true)
    public static boolean startsWith(@NotNull int[] array, int value) {
        return 1 <= array.length && array[0] == value;
    }

    @Contract(pure = true)
    public static boolean endsWith(@NotNull int[] array, int value) {
        return 1 <= array.length && array[array.length - 1] == value;
    }

    @Contract(pure = true)
    public static int indexOf(@NotNull int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (value == array[i]) return i;
        }
        return -1;
    }

    @Contract(pure = true)
    public static boolean contains(@NotNull int[] array, int value) {
        return 0 <= indexOf(array, value);
    }

    @Contract(pure = true)
    public static boolean startsWith(@NotNull long[] array, long value) {
        return 1 <= array.length && array[0] == value;
    }

    @Contract(pure = true)
    public static boolean endsWith(@NotNull long[] array, long value) {
        return 1 <= array.length && array[array.length - 1] == value;
    }

    @Contract(pure = true)
    public static int indexOf(@NotNull long[] array, long value) {
        for (int i = 0; i < array.length; ++i) {
            if (value == array[i]) return i;
        }
        return -1;
    }

    @Contract(pure = true)
    public static boolean contains(@NotNull long[] array, long value) {
        return 0 <= indexOf(array, value);
    }

    @Contract(pure = true)
    public static boolean startsWith(@NotNull short[] array, short value) {
        return 1 <= array.length && array[0] == value;
    }

    @Contract(pure = true)
    public static boolean endsWith(@NotNull short[] array, short value) {
        return 1 <= array.length && array[array.length - 1] == value;
    }

    @Contract(pure = true)
    public static int indexOf(@NotNull short[] array, short value) {
        for (int i = 0; i < array.length; ++i) {
            if (value == array[i]) return i;
        }
        return -1;
    }

    @Contract(pure = true)
    public static boolean contains(@NotNull short[] array, short value) {
        return 0 <= indexOf(array, value);
    }

    @Contract(pure = true)
    public static boolean startsWith(@NotNull Object[] array, @Nullable Object value) {
        return 1 <= array.length && arrayEquals(array[0], value);
    }

    @Contract(pure = true)
    public static boolean endsWith(@NotNull Object[] array, @Nullable Object value) {
        return 1 <= array.length && arrayEquals(array[array.length - 1], value);
    }

    @Contract(pure = true)
    public static int indexOf(@NotNull Object[] array, @Nullable Object value) {
        for (int i = 0; i < array.length; ++i) {
            if (arrayEquals(value, array[i])) return i;
        }
        return -1;
    }

    @Contract(pure = true)
    public static boolean contains(@NotNull Object[] array, @Nullable Object value) {
        return 0 <= indexOf(array, value);
    }

}
