/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.io.github.classgraph;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.AnnotationInfo;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.AnnotationInfoList;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.MethodInfo;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ScanResult;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.TypeSignature;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public class MethodParameterInfo {
    private final MethodInfo methodInfo;
    final AnnotationInfo[] annotationInfo;
    private final int modifiers;
    private final TypeSignature typeDescriptor;
    private final TypeSignature typeSignature;
    private final String name;
    private ScanResult scanResult;

    MethodParameterInfo(MethodInfo methodInfo, AnnotationInfo[] annotationInfo, int modifiers, TypeSignature typeDescriptor, TypeSignature typeSignature, String name) {
        this.methodInfo = methodInfo;
        this.name = name;
        this.modifiers = modifiers;
        this.typeDescriptor = typeDescriptor;
        this.typeSignature = typeSignature;
        this.annotationInfo = annotationInfo;
    }

    public MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    public String getName() {
        return this.name;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getModifiersStr() {
        StringBuilder buf = new StringBuilder();
        MethodParameterInfo.modifiersToString(this.modifiers, buf);
        return buf.toString();
    }

    public TypeSignature getTypeSignature() {
        return this.typeSignature;
    }

    public TypeSignature getTypeDescriptor() {
        return this.typeDescriptor;
    }

    public TypeSignature getTypeSignatureOrTypeDescriptor() {
        return this.typeSignature != null ? this.typeSignature : this.typeDescriptor;
    }

    public AnnotationInfoList getAnnotationInfo() {
        if (!this.scanResult.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableAnnotationInfo() before #scan()");
        }
        if (this.annotationInfo == null || this.annotationInfo.length == 0) {
            return AnnotationInfoList.EMPTY_LIST;
        }
        AnnotationInfoList annotationInfoList = new AnnotationInfoList(this.annotationInfo.length);
        Collections.addAll(annotationInfoList, this.annotationInfo);
        return AnnotationInfoList.getIndirectAnnotations(annotationInfoList, null);
    }

    public AnnotationInfo getAnnotationInfo(String annotationName) {
        return (AnnotationInfo)this.getAnnotationInfo().get(annotationName);
    }

    public AnnotationInfoList getAnnotationInfoRepeatable(String annotationName) {
        return this.getAnnotationInfo().getRepeatable(annotationName);
    }

    public boolean hasAnnotation(String annotationName) {
        return this.getAnnotationInfo().containsName(annotationName);
    }

    protected void setScanResult(ScanResult scanResult) {
        this.scanResult = scanResult;
        if (this.annotationInfo != null) {
            for (AnnotationInfo ai : this.annotationInfo) {
                ai.setScanResult(scanResult);
            }
        }
        if (this.typeDescriptor != null) {
            this.typeDescriptor.setScanResult(scanResult);
        }
        if (this.typeSignature != null) {
            this.typeSignature.setScanResult(scanResult);
        }
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public boolean isSynthetic() {
        return (this.modifiers & 0x1000) != 0;
    }

    public boolean isMandated() {
        return (this.modifiers & 0x8000) != 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MethodParameterInfo)) {
            return false;
        }
        MethodParameterInfo other = (MethodParameterInfo)obj;
        return Objects.equals(this.methodInfo, other.methodInfo) && Objects.deepEquals(this.annotationInfo, other.annotationInfo) && this.modifiers == other.modifiers && Objects.equals(this.typeDescriptor, other.typeDescriptor) && Objects.equals(this.typeSignature, other.typeSignature) && Objects.equals(this.name, other.name);
    }

    public int hashCode() {
        return Objects.hash(this.methodInfo, Arrays.hashCode(this.annotationInfo), this.typeDescriptor, this.typeSignature, this.name) + this.modifiers;
    }

    static void modifiersToString(int modifiers, StringBuilder buf) {
        if ((modifiers & 0x10) != 0) {
            buf.append("final ");
        }
        if ((modifiers & 0x1000) != 0) {
            buf.append("synthetic ");
        }
        if ((modifiers & 0x8000) != 0) {
            buf.append("mandated ");
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.annotationInfo != null) {
            for (AnnotationInfo anAnnotationInfo : this.annotationInfo) {
                anAnnotationInfo.toString(buf);
                buf.append(' ');
            }
        }
        MethodParameterInfo.modifiersToString(this.modifiers, buf);
        buf.append(this.getTypeSignatureOrTypeDescriptor().toString());
        buf.append(' ');
        buf.append(this.name == null ? "_unnamed_param" : this.name);
        return buf.toString();
    }
}

