/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.datatype.jsr310.ser;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.annotation.JsonFormat;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.core.JsonGenerator;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.core.JsonParser;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.core.JsonToken;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.JavaType;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.JsonMappingException;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.SerializerProvider;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public abstract class InstantSerializerBase<T extends Temporal>
extends JSR310FormattedSerializerBase<T> {
    private final DateTimeFormatter defaultFormat;
    private final ToLongFunction<T> getEpochMillis;
    private final ToLongFunction<T> getEpochSeconds;
    private final ToIntFunction<T> getNanoseconds;

    protected InstantSerializerBase(Class<T> supportedType, ToLongFunction<T> getEpochMillis, ToLongFunction<T> getEpochSeconds, ToIntFunction<T> getNanoseconds, DateTimeFormatter formatter) {
        super(supportedType, null);
        this.defaultFormat = formatter;
        this.getEpochMillis = getEpochMillis;
        this.getEpochSeconds = getEpochSeconds;
        this.getNanoseconds = getNanoseconds;
    }

    protected InstantSerializerBase(InstantSerializerBase<T> base, Boolean useTimestamp, DateTimeFormatter dtf) {
        this(base, useTimestamp, null, dtf);
    }

    protected InstantSerializerBase(InstantSerializerBase<T> base, Boolean useTimestamp, Boolean useNanoseconds, DateTimeFormatter dtf) {
        super(base, useTimestamp, useNanoseconds, dtf, null);
        this.defaultFormat = base.defaultFormat;
        this.getEpochMillis = base.getEpochMillis;
        this.getEpochSeconds = base.getEpochSeconds;
        this.getNanoseconds = base.getNanoseconds;
    }

    @Override
    protected abstract JSR310FormattedSerializerBase<?> withFormat(Boolean var1, DateTimeFormatter var2, JsonFormat.Shape var3);

    @Override
    public void serialize(T value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        if (this.useTimestamp(provider)) {
            if (this.useNanoseconds(provider)) {
                generator.writeNumber(DecimalUtils.toBigDecimal(this.getEpochSeconds.applyAsLong(value), this.getNanoseconds.applyAsInt(value)));
                return;
            }
            generator.writeNumber(this.getEpochMillis.applyAsLong(value));
            return;
        }
        String str = this._formatter != null ? this._formatter.format((TemporalAccessor)value) : (this.defaultFormat != null ? this.defaultFormat.format((TemporalAccessor)value) : value.toString());
        generator.writeString(str);
    }

    @Override
    protected void _acceptTimestampVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
        if (this.useNanoseconds(visitor2.getProvider())) {
            JsonNumberFormatVisitor v2 = visitor2.expectNumberFormat(typeHint);
            if (v2 != null) {
                v2.numberType(JsonParser.NumberType.BIG_DECIMAL);
            }
        } else {
            JsonIntegerFormatVisitor v2 = visitor2.expectIntegerFormat(typeHint);
            if (v2 != null) {
                v2.numberType(JsonParser.NumberType.LONG);
            }
        }
    }

    @Override
    protected JsonToken serializationShape(SerializerProvider provider) {
        if (this.useTimestamp(provider)) {
            if (this.useNanoseconds(provider)) {
                return JsonToken.VALUE_NUMBER_FLOAT;
            }
            return JsonToken.VALUE_NUMBER_INT;
        }
        return JsonToken.VALUE_STRING;
    }
}

