/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.api.classes_processing;

import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ProcessContext {
    @NotNull
    public File getClassesDir();

    @NotNull
    public List<File> getClasspath();

    default public boolean isResourceExists(@NotNull String relativePath) {
        return null != this.readBinaryResource(relativePath);
    }

    @Nullable
    public byte[] readBinaryResource(@NotNull String var1);

    @Nullable
    public String readTextResource(@NotNull String var1);

    public void writeBinaryResource(@NotNull String var1, @NotNull byte[] var2);

    public void writeTextResource(@NotNull String var1, @NotNull String var2);

    public void appendTextResource(@NotNull String var1, @NotNull String var2);

    default public void writeService(@NotNull String serviceName, @NotNull String implementationName) {
        this.appendTextResource("META-INF/services/" + serviceName, "\n" + implementationName);
    }

    default public void writeService(@NotNull Class<?> serviceClass, @NotNull String implementationName) {
        this.writeService(serviceClass.getName(), implementationName);
    }

    default public void writeService(@NotNull String serviceName, @NotNull Class<?> implementationClass) {
        this.writeService(serviceName, implementationClass.getName());
    }

    default public void writeService(@NotNull Class<?> serviceClass, @NotNull Class<?> implementationClass) {
        this.writeService(serviceClass.getName(), implementationClass.getName());
    }

    default public boolean isClasspathResourceExists(@NotNull String relativePath) {
        return null != this.readClasspathBinaryResource(relativePath);
    }

    @Nullable
    public byte[] readClasspathBinaryResource(@NotNull String var1);

    @Nullable
    public String readClasspathTextResource(@NotNull String var1);
}

