/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.x.io;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.MessageLite;
import com.mysql.cj.api.Session;
import com.mysql.cj.api.TransactionEventHandler;
import com.mysql.cj.api.authentication.AuthenticationProvider;
import com.mysql.cj.api.conf.PropertySet;
import com.mysql.cj.api.exceptions.ExceptionInterceptor;
import com.mysql.cj.api.io.PacketReceivedTimeHolder;
import com.mysql.cj.api.io.PacketSentTimeHolder;
import com.mysql.cj.api.io.Protocol;
import com.mysql.cj.api.io.ServerCapabilities;
import com.mysql.cj.api.io.ServerSession;
import com.mysql.cj.api.io.SocketConnection;
import com.mysql.cj.api.x.io.MessageReader;
import com.mysql.cj.api.x.io.MessageWriter;
import com.mysql.cj.api.x.io.ResultListener;
import com.mysql.cj.api.x.io.XpluginStatementCommand;
import com.mysql.cj.api.xdevapi.SqlResult;
import com.mysql.cj.core.CharsetMapping;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.MysqlType;
import com.mysql.cj.core.exceptions.AssertionFailedException;
import com.mysql.cj.core.exceptions.ConnectionIsClosedException;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.core.util.LazyString;
import com.mysql.cj.x.core.StatementExecuteOk;
import com.mysql.cj.x.core.XDevAPIError;
import com.mysql.cj.x.io.AsyncMessageReader;
import com.mysql.cj.x.io.AsyncMessageWriter;
import com.mysql.cj.x.io.ErrorToFutureCompletionHandler;
import com.mysql.cj.x.io.MessageBuilder;
import com.mysql.cj.x.io.ResultMessageListener;
import com.mysql.cj.x.io.SqlResultMessageListener;
import com.mysql.cj.x.io.StatementExecuteOkBuilder;
import com.mysql.cj.x.io.StatementExecuteOkMessageListener;
import com.mysql.cj.x.io.XProtocolRow;
import com.mysql.cj.x.io.XProtocolRowInputStream;
import com.mysql.cj.x.protobuf.Mysqlx;
import com.mysql.cj.x.protobuf.MysqlxConnection;
import com.mysql.cj.x.protobuf.MysqlxDatatypes;
import com.mysql.cj.x.protobuf.MysqlxNotice;
import com.mysql.cj.x.protobuf.MysqlxResultset;
import com.mysql.cj.x.protobuf.MysqlxSession;
import com.mysql.cj.x.protobuf.MysqlxSql;
import com.mysql.cj.xdevapi.CreateIndexParams;
import com.mysql.cj.xdevapi.ExprUtil;
import com.mysql.cj.xdevapi.FilterParams;
import com.mysql.cj.xdevapi.FindParams;
import com.mysql.cj.xdevapi.InsertParams;
import com.mysql.cj.xdevapi.UpdateParams;
import com.mysql.cj.xdevapi.UpdateSpec;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class XProtocol
implements Protocol {
    private static final int XPROTOCOL_COLUMN_BYTES_CONTENT_TYPE_GEOMETRY = 1;
    public static final int XPROTOCOL_COLUMN_BYTES_CONTENT_TYPE_JSON = 2;
    private static final int XPROTOCOL_COLUMN_FLAGS_UINT_ZEROFILL = 1;
    private static final int XPROTOCOL_COLUMN_FLAGS_DOUBLE_UNSIGNED = 1;
    private static final int XPROTOCOL_COLUMN_FLAGS_FLOAT_UNSIGNED = 1;
    private static final int XPROTOCOL_COLUMN_FLAGS_DECIMAL_UNSIGNED = 1;
    private static final int XPROTOCOL_COLUMN_FLAGS_BYTES_RIGHTPAD = 1;
    private static final int XPROTOCOL_COLUMN_FLAGS_DATETIME_TIMESTAMP = 1;
    private static final int XPROTOCOL_COLUMN_FLAGS_NOT_NULL = 16;
    private static final int XPROTOCOL_COLUMN_FLAGS_PRIMARY_KEY = 32;
    private static final int XPROTOCOL_COLUMN_FLAGS_UNIQUE_KEY = 64;
    private static final int XPROTOCOL_COLUMN_FLAGS_MULTIPLE_KEY = 128;
    private static final int XPROTOCOL_COLUMN_FLAGS_AUTO_INCREMENT = 256;
    public static final int XProtocolNoticeFrameType_WARNING = 1;
    public static final int XProtocolNoticeFrameType_SESS_VAR_CHANGED = 2;
    public static final int XProtocolNoticeFrameType_SESS_STATE_CHANGED = 3;
    private MessageReader reader;
    private MessageWriter writer;
    private Closeable managedResource;
    private PropertySet propertySet;
    private Map<String, MysqlxDatatypes.Any> capabilities;
    private long clientId = -1L;
    private MessageBuilder msgBuilder = new MessageBuilder();
    public static Map<String, Integer> COLLATION_NAME_TO_COLLATION_INDEX = new HashMap<String, Integer>();

    public XProtocol(MessageReader reader, MessageWriter writer, Closeable network, PropertySet propSet) {
        this.reader = reader;
        this.writer = writer;
        this.managedResource = network;
        this.propertySet = propSet;
        this.capabilities = this.getCapabilities();
    }

    @Override
    public void init(Session session, SocketConnection socketConnection, PropertySet propSet, TransactionEventHandler transactionManager) {
        throw new NullPointerException("TODO: this implementation uses a constructor");
    }

    @Override
    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    @Override
    public void setPropertySet(PropertySet propertySet) {
        this.propertySet = propertySet;
    }

    @Override
    public ServerCapabilities readServerCapabilities() {
        throw new NullPointerException("TODO");
    }

    @Override
    public ServerSession getServerSession() {
        throw new NullPointerException("TODO");
    }

    @Override
    public SocketConnection getSocketConnection() {
        throw new NullPointerException("TODO");
    }

    @Override
    public AuthenticationProvider getAuthenticationProvider() {
        throw new NullPointerException("TODO");
    }

    @Override
    public ExceptionInterceptor getExceptionInterceptor() {
        throw new NullPointerException("TODO");
    }

    @Override
    public PacketSentTimeHolder getPacketSentTimeHolder() {
        throw new NullPointerException("TODO");
    }

    @Override
    public void setPacketSentTimeHolder(PacketSentTimeHolder packetSentTimeHolder) {
        throw new NullPointerException("TODO");
    }

    @Override
    public PacketReceivedTimeHolder getPacketReceivedTimeHolder() {
        throw new NullPointerException("TODO");
    }

    @Override
    public void setPacketReceivedTimeHolder(PacketReceivedTimeHolder packetReceivedTimeHolder) {
        throw new NullPointerException("TODO");
    }

    private Map<String, MysqlxDatatypes.Any> getCapabilities() {
        this.writer.write((MessageLite)MysqlxConnection.CapabilitiesGet.getDefaultInstance());
        return this.reader.read(MysqlxConnection.Capabilities.class).getCapabilitiesList().stream().collect(Collectors.toMap(MysqlxConnection.Capability::getName, MysqlxConnection.Capability::getValue));
    }

    public void setCapability(String name, Object value) {
        this.capabilities.put("tls", ExprUtil.argObjectToScalarAny(value));
        this.writer.write((MessageLite)this.msgBuilder.buildCapabilitiesSet(name, value));
        this.readOk();
    }

    public void sendSaslMysql41AuthStart() {
        MysqlxSession.AuthenticateStart.Builder builder = MysqlxSession.AuthenticateStart.newBuilder().setMechName("MYSQL41");
        this.writer.write((MessageLite)builder.build());
    }

    public void sendSaslMysql41AuthContinue(String user, String password, byte[] salt, String database) {
        this.writer.write((MessageLite)this.msgBuilder.buildMysql41AuthContinue(user, password, salt, database));
    }

    public void sendSaslPlainAuthStart(String user, String password, String database) {
        this.writer.write((MessageLite)this.msgBuilder.buildPlainAuthStart(user, password, database));
    }

    public void sendSaslExternalAuthStart(String database) {
        this.writer.write((MessageLite)this.msgBuilder.buildExternalAuthStart(database));
    }

    @Override
    public void negotiateSSLConnection(int packLength) {
        throw new NullPointerException("TODO: SSL is not yet supported in this X Protocol client");
    }

    @Override
    public void beforeHandshake() {
        throw new NullPointerException("TODO");
    }

    @Override
    public void afterHandshake() {
        throw new NullPointerException("TODO");
    }

    @Override
    public void changeDatabase(String database) {
        throw new NullPointerException("TODO: Figure out how this is relevant for X Protocol client Session");
    }

    @Override
    public void changeUser(String user, String password, String database) {
        throw new NullPointerException("TODO");
    }

    @Override
    public String getPasswordCharacterEncoding() {
        throw new NullPointerException("TODO");
    }

    @Override
    public boolean versionMeetsMinimum(int major, int minor, int subminor) {
        throw new NullPointerException("TODO: expose this via ServerVersion so calls look like x.getServerVersion().meetsMinimum(major, minor, subminor)");
    }

    public void readOk() {
        while (this.reader.getNextMessageClass() == MysqlxNotice.Frame.class) {
            this.reader.read(MysqlxNotice.Frame.class);
        }
        this.reader.read(Mysqlx.Ok.class);
    }

    public void readAuthenticateOk() {
        while (this.reader.getNextMessageClass() == MysqlxNotice.Frame.class) {
            MysqlxNotice.Frame notice = this.reader.read(MysqlxNotice.Frame.class);
            if (notice.getType() == 3) {
                MysqlxNotice.SessionStateChanged msg = MessageReader.parseNotice(notice.getPayload(), MysqlxNotice.SessionStateChanged.class);
                switch (msg.getParam()) {
                    case CLIENT_ID_ASSIGNED: {
                        this.clientId = msg.getValue().getVUnsignedInt();
                        break;
                    }
                    default: {
                        throw new WrongArgumentException("Unknown SessionStateChanged notice received during authentication: " + msg);
                    }
                }
                continue;
            }
            throw new WrongArgumentException("Unknown notice received during authentication: " + notice);
        }
        this.reader.read(MysqlxSession.AuthenticateOk.class);
    }

    public byte[] readAuthenticateContinue() {
        MysqlxSession.AuthenticateContinue msg = this.reader.read(MysqlxSession.AuthenticateContinue.class);
        byte[] data = msg.getAuthData().toByteArray();
        if (data.length != 20) {
            throw AssertionFailedException.shouldNotHappen("Salt length should be 20, but is " + data.length);
        }
        return data;
    }

    public void sendCreateCollection(String schemaName, String collectionName) {
        if (schemaName == null) {
            throw new XDevAPIError(Messages.getString("CreateTableStatement.0", new String[]{"schemaName"}));
        }
        if (collectionName == null) {
            throw new XDevAPIError(Messages.getString("CreateTableStatement.0", new String[]{"collectionName"}));
        }
        this.writer.write((MessageLite)this.msgBuilder.buildXpluginCommand(XpluginStatementCommand.XPLUGIN_STMT_CREATE_COLLECTION, MysqlxDatatypes.Any.newBuilder().setType(MysqlxDatatypes.Any.Type.OBJECT).setObj(MysqlxDatatypes.Object.newBuilder().addFld(MysqlxDatatypes.Object.ObjectField.newBuilder().setKey("name").setValue(ExprUtil.buildAny(collectionName))).addFld(MysqlxDatatypes.Object.ObjectField.newBuilder().setKey("schema").setValue(ExprUtil.buildAny(schemaName)))).build()));
    }

    public void sendDropCollection(String schemaName, String collectionName) {
        if (schemaName == null) {
            throw new XDevAPIError(Messages.getString("CreateTableStatement.0", new String[]{"schemaName"}));
        }
        if (collectionName == null) {
            throw new XDevAPIError(Messages.getString("CreateTableStatement.0", new String[]{"collectionName"}));
        }
        this.writer.write((MessageLite)this.msgBuilder.buildXpluginCommand(XpluginStatementCommand.XPLUGIN_STMT_DROP_COLLECTION, MysqlxDatatypes.Any.newBuilder().setType(MysqlxDatatypes.Any.Type.OBJECT).setObj(MysqlxDatatypes.Object.newBuilder().addFld(MysqlxDatatypes.Object.ObjectField.newBuilder().setKey("name").setValue(ExprUtil.buildAny(collectionName))).addFld(MysqlxDatatypes.Object.ObjectField.newBuilder().setKey("schema").setValue(ExprUtil.buildAny(schemaName)))).build()));
    }

    public void sendListObjects(String schemaName, String pattern) {
        if (schemaName == null) {
            throw new XDevAPIError(Messages.getString("CreateTableStatement.0", new String[]{"schemaName"}));
        }
        if (pattern == null) {
            throw new XDevAPIError(Messages.getString("CreateTableStatement.0", new String[]{"pattern"}));
        }
        this.writer.write((MessageLite)this.msgBuilder.buildXpluginCommand(XpluginStatementCommand.XPLUGIN_STMT_LIST_OBJECTS, MysqlxDatatypes.Any.newBuilder().setType(MysqlxDatatypes.Any.Type.OBJECT).setObj(MysqlxDatatypes.Object.newBuilder().addFld(MysqlxDatatypes.Object.ObjectField.newBuilder().setKey("schema").setValue(ExprUtil.buildAny(schemaName))).addFld(MysqlxDatatypes.Object.ObjectField.newBuilder().setKey("pattern").setValue(ExprUtil.buildAny(pattern)))).build()));
    }

    public void sendListObjects(String schemaName) {
        if (schemaName == null) {
            throw new XDevAPIError(Messages.getString("CreateTableStatement.0", new String[]{"schemaName"}));
        }
        this.writer.write((MessageLite)this.msgBuilder.buildXpluginCommand(XpluginStatementCommand.XPLUGIN_STMT_LIST_OBJECTS, MysqlxDatatypes.Any.newBuilder().setType(MysqlxDatatypes.Any.Type.OBJECT).setObj(MysqlxDatatypes.Object.newBuilder().addFld(MysqlxDatatypes.Object.ObjectField.newBuilder().setKey("schema").setValue(ExprUtil.buildAny(schemaName)))).build()));
    }

    public void sendListNotices() {
        this.writer.write((MessageLite)this.msgBuilder.buildXpluginCommand(XpluginStatementCommand.XPLUGIN_STMT_LIST_NOTICES, new MysqlxDatatypes.Any[0]));
    }

    public void sendEnableNotices(String ... notices) {
        MysqlxDatatypes.Array.Builder abuilder = MysqlxDatatypes.Array.newBuilder();
        for (String notice : notices) {
            abuilder.addValue(ExprUtil.buildAny(notice));
        }
        this.writer.write((MessageLite)this.msgBuilder.buildXpluginCommand(XpluginStatementCommand.XPLUGIN_STMT_ENABLE_NOTICES, MysqlxDatatypes.Any.newBuilder().setType(MysqlxDatatypes.Any.Type.OBJECT).setObj(MysqlxDatatypes.Object.newBuilder().addFld(MysqlxDatatypes.Object.ObjectField.newBuilder().setKey("notice").setValue(MysqlxDatatypes.Any.newBuilder().setType(MysqlxDatatypes.Any.Type.ARRAY).setArray(abuilder)))).build()));
    }

    public void sendDisableNotices(String ... notices) {
        MysqlxDatatypes.Array.Builder abuilder = MysqlxDatatypes.Array.newBuilder();
        for (String notice : notices) {
            abuilder.addValue(ExprUtil.buildAny(notice));
        }
        this.writer.write((MessageLite)this.msgBuilder.buildXpluginCommand(XpluginStatementCommand.XPLUGIN_STMT_DISABLE_NOTICES, MysqlxDatatypes.Any.newBuilder().setType(MysqlxDatatypes.Any.Type.OBJECT).setObj(MysqlxDatatypes.Object.newBuilder().addFld(MysqlxDatatypes.Object.ObjectField.newBuilder().setKey("notice").setValue(MysqlxDatatypes.Any.newBuilder().setType(MysqlxDatatypes.Any.Type.ARRAY).setArray(abuilder)))).build()));
    }

    public boolean hasMoreResults() {
        if (this.reader.getNextMessageClass() == MysqlxResultset.FetchDoneMoreResultsets.class) {
            this.reader.read(MysqlxResultset.FetchDoneMoreResultsets.class);
            return this.reader.getNextMessageClass() != MysqlxResultset.FetchDone.class;
        }
        return false;
    }

    public StatementExecuteOk readStatementExecuteOk() {
        StatementExecuteOkBuilder builder = new StatementExecuteOkBuilder();
        if (this.reader.getNextMessageClass() == MysqlxResultset.FetchDone.class) {
            this.reader.read(MysqlxResultset.FetchDone.class);
        }
        while (this.reader.getNextMessageClass() == MysqlxNotice.Frame.class) {
            builder.addNotice(this.reader.read(MysqlxNotice.Frame.class));
        }
        this.reader.read(MysqlxSql.StmtExecuteOk.class);
        return builder.build();
    }

    public void sendSqlStatement(String statement) {
        this.sendSqlStatement(statement, null);
    }

    public void sendSqlStatement(String statement, Object args) {
        this.writer.write((MessageLite)this.msgBuilder.buildSqlStatement(statement, (List)args));
    }

    public boolean hasResults() {
        return this.reader.getNextMessageClass() == MysqlxResultset.ColumnMetaData.class;
    }

    public void drainRows() {
        while (this.reader.getNextMessageClass() == MysqlxResultset.Row.class) {
            this.reader.read(MysqlxResultset.Row.class);
        }
    }

    private static int xProtocolTypeToMysqlType(MysqlxResultset.ColumnMetaData.FieldType type, int contentType) {
        switch (type) {
            case SINT: {
                return 8;
            }
            case UINT: {
                return 8;
            }
            case FLOAT: {
                return 4;
            }
            case DOUBLE: {
                return 5;
            }
            case DECIMAL: {
                return 246;
            }
            case BYTES: {
                switch (contentType) {
                    case 1: {
                        return 255;
                    }
                    case 2: {
                        return 245;
                    }
                }
                return 15;
            }
            case TIME: {
                return 11;
            }
            case DATETIME: {
                return 12;
            }
            case SET: {
                return 248;
            }
            case ENUM: {
                return 247;
            }
            case BIT: {
                return 16;
            }
        }
        throw new WrongArgumentException("TODO: unknown field type: " + (Object)((Object)type));
    }

    public static MysqlType findMysqlType(MysqlxResultset.ColumnMetaData.FieldType type, int contentType, int flags, int collationIndex) {
        switch (type) {
            case SINT: {
                return MysqlType.BIGINT;
            }
            case UINT: {
                return MysqlType.BIGINT_UNSIGNED;
            }
            case FLOAT: {
                return 0 < (flags & 1) ? MysqlType.FLOAT_UNSIGNED : MysqlType.FLOAT;
            }
            case DOUBLE: {
                return 0 < (flags & 1) ? MysqlType.DOUBLE_UNSIGNED : MysqlType.DOUBLE;
            }
            case DECIMAL: {
                return 0 < (flags & 1) ? MysqlType.DECIMAL_UNSIGNED : MysqlType.DECIMAL;
            }
            case BYTES: {
                switch (contentType) {
                    case 1: {
                        return MysqlType.GEOMETRY;
                    }
                    case 2: {
                        return MysqlType.JSON;
                    }
                }
                if (collationIndex == 33) {
                    return MysqlType.VARBINARY;
                }
                return MysqlType.VARCHAR;
            }
            case TIME: {
                return MysqlType.TIME;
            }
            case DATETIME: {
                return MysqlType.DATETIME;
            }
            case SET: {
                return MysqlType.SET;
            }
            case ENUM: {
                return MysqlType.ENUM;
            }
            case BIT: {
                return MysqlType.BIT;
            }
        }
        throw new WrongArgumentException("TODO: unknown field type: " + (Object)((Object)type));
    }

    private static Field columnMetaDataToField(PropertySet propertySet, MysqlxResultset.ColumnMetaData col, String characterSet) {
        try {
            LazyString databaseName = new LazyString(col.getSchema().toString(characterSet));
            LazyString tableName = new LazyString(col.getTable().toString(characterSet));
            LazyString originalTableName = new LazyString(col.getOriginalTable().toString(characterSet));
            LazyString columnName = new LazyString(col.getName().toString(characterSet));
            LazyString originalColumnName = new LazyString(col.getOriginalName().toString(characterSet));
            long length = Integer.toUnsignedLong(col.getLength());
            int decimals = col.getFractionalDigits();
            int collationIndex = 0;
            if (col.hasCollation()) {
                collationIndex = (int)col.getCollation();
            }
            String encoding = CharsetMapping.COLLATION_INDEX_TO_COLLATION_NAME[collationIndex];
            MysqlType mysqlType = XProtocol.findMysqlType(col.getType(), col.getContentType(), col.getFlags(), collationIndex);
            int mysqlTypeId = XProtocol.xProtocolTypeToMysqlType(col.getType(), col.getContentType());
            short flags = 0;
            if (col.getType().equals((Object)MysqlxResultset.ColumnMetaData.FieldType.UINT) && 0 < (col.getFlags() & 1)) {
                flags = (short)(flags | 0x40);
            } else if (col.getType().equals((Object)MysqlxResultset.ColumnMetaData.FieldType.BYTES) && 0 < (col.getFlags() & 1)) {
                mysqlType = MysqlType.CHAR;
            } else if (col.getType().equals((Object)MysqlxResultset.ColumnMetaData.FieldType.DATETIME) && 0 < (col.getFlags() & 1)) {
                mysqlType = MysqlType.TIMESTAMP;
            }
            if ((col.getFlags() & 0x10) > 0) {
                flags = (short)(flags | 1);
            }
            if ((col.getFlags() & 0x20) > 0) {
                flags = (short)(flags | 2);
            }
            if ((col.getFlags() & 0x40) > 0) {
                flags = (short)(flags | 4);
            }
            if ((col.getFlags() & 0x80) > 0) {
                flags = (short)(flags | 8);
            }
            if ((col.getFlags() & 0x100) > 0) {
                flags = (short)(flags | 0x200);
            }
            Field f = new Field(databaseName, tableName, originalTableName, columnName, originalColumnName, length, mysqlTypeId, flags, decimals, collationIndex, encoding, mysqlType);
            return f;
        }
        catch (UnsupportedEncodingException ex) {
            throw new WrongArgumentException("Unable to decode metadata strings", ex);
        }
    }

    public ArrayList<Field> readMetadata(String characterSet) {
        while (this.reader.getNextMessageClass() == MysqlxNotice.Frame.class) {
            this.reader.read(MysqlxNotice.Frame.class);
        }
        LinkedList<MysqlxResultset.ColumnMetaData> fromServer = new LinkedList<MysqlxResultset.ColumnMetaData>();
        do {
            fromServer.add(this.reader.read(MysqlxResultset.ColumnMetaData.class));
        } while (this.reader.getNextMessageClass() == MysqlxResultset.ColumnMetaData.class);
        ArrayList<Field> metadata = new ArrayList<Field>(fromServer.size());
        fromServer.forEach(col -> metadata.add(XProtocol.columnMetaDataToField(this.propertySet, col, characterSet)));
        return metadata;
    }

    public XProtocolRow readRowOrNull(ArrayList<Field> metadata) {
        if (this.reader.getNextMessageClass() == MysqlxResultset.Row.class) {
            MysqlxResultset.Row r = this.reader.read(MysqlxResultset.Row.class);
            return new XProtocolRow(metadata, r);
        }
        return null;
    }

    public XProtocolRowInputStream getRowInputStream(ArrayList<Field> metadata) {
        return new XProtocolRowInputStream(metadata, this);
    }

    public CompletableFuture<SqlResult> asyncExecuteSql(String sql, Object args, String metadataCharacterSet, TimeZone defaultTimeZone) {
        CompletableFuture<SqlResult> f = new CompletableFuture<SqlResult>();
        SqlResultMessageListener l = new SqlResultMessageListener(f, col -> XProtocol.columnMetaDataToField(this.propertySet, col, metadataCharacterSet), defaultTimeZone);
        ErrorToFutureCompletionHandler<Long> resultHandler = new ErrorToFutureCompletionHandler<Long>(f, () -> ((AsyncMessageReader)this.reader).pushMessageListener(l));
        ((AsyncMessageWriter)this.writer).writeAsync((MessageLite)this.msgBuilder.buildSqlStatement(sql, (List)args), resultHandler);
        return f;
    }

    public void asyncFind(FindParams findParams, String metadataCharacterSet, ResultListener callbacks, CompletableFuture<?> errorFuture) {
        ResultMessageListener l = new ResultMessageListener(col -> XProtocol.columnMetaDataToField(this.propertySet, col, metadataCharacterSet), callbacks);
        ErrorToFutureCompletionHandler<Long> resultHandler = new ErrorToFutureCompletionHandler<Long>(errorFuture, () -> ((AsyncMessageReader)this.reader).pushMessageListener(l));
        ((AsyncMessageWriter)this.writer).writeAsync((MessageLite)this.msgBuilder.buildFind(findParams), resultHandler);
    }

    private CompletableFuture<StatementExecuteOk> asyncUpdate(MessageLite commandMessage) {
        CompletableFuture<StatementExecuteOk> f = new CompletableFuture<StatementExecuteOk>();
        StatementExecuteOkMessageListener l = new StatementExecuteOkMessageListener(f);
        ErrorToFutureCompletionHandler<Long> resultHandler = new ErrorToFutureCompletionHandler<Long>(f, () -> ((AsyncMessageReader)this.reader).pushMessageListener(l));
        ((AsyncMessageWriter)this.writer).writeAsync(commandMessage, resultHandler);
        return f;
    }

    public CompletableFuture<StatementExecuteOk> asyncAddDocs(String schemaName, String collectionName, List<String> jsonStrings, boolean upsert) {
        return this.asyncUpdate((MessageLite)this.msgBuilder.buildDocInsert(schemaName, collectionName, jsonStrings, upsert));
    }

    public CompletableFuture<StatementExecuteOk> asyncInsertRows(String schemaName, String tableName, InsertParams insertParams) {
        return this.asyncUpdate((MessageLite)this.msgBuilder.buildRowInsert(schemaName, tableName, insertParams));
    }

    public CompletableFuture<StatementExecuteOk> asyncUpdateDocs(FilterParams filterParams, List<UpdateSpec> updates) {
        return this.asyncUpdate((MessageLite)this.msgBuilder.buildDocUpdate(filterParams, updates));
    }

    public CompletableFuture<StatementExecuteOk> asyncUpdateRows(FilterParams filterParams, UpdateParams updateParams) {
        return this.asyncUpdate((MessageLite)this.msgBuilder.buildRowUpdate(filterParams, updateParams));
    }

    public CompletableFuture<StatementExecuteOk> asyncDeleteDocs(FilterParams filterParams) {
        return this.asyncUpdate((MessageLite)this.msgBuilder.buildDelete(filterParams));
    }

    public CompletableFuture<StatementExecuteOk> asyncCreateCollectionIndex(String schemaName, String collectionName, CreateIndexParams params) {
        return this.asyncUpdate((MessageLite)this.msgBuilder.buildCreateCollectionIndex(schemaName, collectionName, params));
    }

    public CompletableFuture<StatementExecuteOk> asyncDropCollectionIndex(String schemaName, String collectionName, String indexName) {
        return this.asyncUpdate((MessageLite)this.msgBuilder.buildDropCollectionIndex(schemaName, collectionName, indexName));
    }

    public void sendFind(FindParams findParams) {
        this.writer.write((MessageLite)this.msgBuilder.buildFind(findParams));
    }

    public void sendDocUpdates(FilterParams filterParams, List<UpdateSpec> updates) {
        this.writer.write((MessageLite)this.msgBuilder.buildDocUpdate(filterParams, updates));
    }

    public void sendRowUpdates(FilterParams filterParams, UpdateParams updateParams) {
        this.writer.write((MessageLite)this.msgBuilder.buildRowUpdate(filterParams, updateParams));
    }

    public void sendDocDelete(FilterParams filterParams) {
        this.writer.write((MessageLite)this.msgBuilder.buildDelete(filterParams));
    }

    public void sendDocInsert(String schemaName, String collectionName, List<String> jsonStrings, boolean upsert) {
        this.writer.write((MessageLite)this.msgBuilder.buildDocInsert(schemaName, collectionName, jsonStrings, upsert));
    }

    public void sendRowInsert(String schemaName, String tableName, InsertParams insertParams) {
        this.writer.write((MessageLite)this.msgBuilder.buildRowInsert(schemaName, tableName, insertParams));
    }

    public void sendSessionClose() {
        this.writer.write((MessageLite)MysqlxSession.Close.getDefaultInstance());
    }

    public boolean hasCapability(String name) {
        return this.capabilities.containsKey(name);
    }

    public String getNodeType() {
        return this.capabilities.get("node_type").getScalar().getVString().getValue().toStringUtf8();
    }

    public boolean getTls() {
        return this.capabilities.get("tls").getScalar().getVBool();
    }

    public boolean getClientPwdExpireOk() {
        return this.capabilities.get("client.pwd_expire_ok").getScalar().getVBool();
    }

    public List<String> getAuthenticationMechanisms() {
        return this.capabilities.get("authentication.mechanisms").getArray().getValueList().stream().map(v -> v.getScalar().getVString().getValue().toStringUtf8()).collect(Collectors.toList());
    }

    public String getDocFormats() {
        return this.capabilities.get("doc.formats").getScalar().getVString().getValue().toStringUtf8();
    }

    public void sendCreateCollectionIndex(String schemaName, String collectionName, CreateIndexParams params) {
        this.writer.write((MessageLite)this.msgBuilder.buildCreateCollectionIndex(schemaName, collectionName, params));
    }

    public void sendDropCollectionIndex(String schemaName, String collectionName, String indexName) {
        this.writer.write((MessageLite)this.msgBuilder.buildDropCollectionIndex(schemaName, collectionName, indexName));
    }

    public boolean isOpen() {
        return this.managedResource != null;
    }

    public void close() throws IOException {
        if (this.managedResource == null) {
            throw new ConnectionIsClosedException();
        }
        this.managedResource.close();
        this.managedResource = null;
    }

    public boolean isSqlResultPending() {
        Class<? extends GeneratedMessage> nextMessageClass = this.reader.getNextMessageClass();
        if (nextMessageClass == MysqlxResultset.ColumnMetaData.class) {
            return true;
        }
        if (nextMessageClass == MysqlxResultset.FetchDoneMoreResultsets.class) {
            this.reader.read(MysqlxResultset.FetchDoneMoreResultsets.class);
        }
        return false;
    }

    public long getClientId() {
        return this.clientId;
    }

    @Override
    public void connect(String user, String password, String database) {
    }

    public void setMaxAllowedPacket(int maxAllowedPacket) {
        this.writer.setMaxAllowedPacket(maxAllowedPacket);
    }

    static {
        for (int i = 0; i < CharsetMapping.COLLATION_INDEX_TO_COLLATION_NAME.length; ++i) {
            COLLATION_NAME_TO_COLLATION_INDEX.put(CharsetMapping.COLLATION_INDEX_TO_COLLATION_NAME[i], i);
        }
    }
}

