/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqla.authentication;

import com.mysql.cj.api.io.Protocol;
import com.mysql.cj.api.mysqla.io.NativeProtocol;
import com.mysql.cj.api.mysqla.io.PacketPayload;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.authentication.Security;
import com.mysql.cj.core.exceptions.CJException;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.UnableToConnectException;
import com.mysql.cj.core.io.ExportControlled;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.mysqla.authentication.Sha256PasswordPlugin;
import com.mysql.cj.mysqla.io.Buffer;
import java.security.DigestException;
import java.util.List;

public class CachingSha2PasswordPlugin
extends Sha256PasswordPlugin {
    public static String PLUGIN_NAME = "caching_sha2_password";
    private AuthStage stage = AuthStage.FAST_AUTH_SEND_SCRAMBLE;

    @Override
    public void init(Protocol prot) {
        super.init(prot);
        this.stage = AuthStage.FAST_AUTH_SEND_SCRAMBLE;
    }

    @Override
    public void reset() {
        this.stage = AuthStage.FAST_AUTH_SEND_SCRAMBLE;
    }

    @Override
    public void destroy() {
        this.stage = AuthStage.FAST_AUTH_SEND_SCRAMBLE;
        super.destroy();
    }

    @Override
    public String getProtocolPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public boolean nextAuthenticationStep(PacketPayload fromServer, List<PacketPayload> toServer) {
        toServer.clear();
        if (this.password == null || this.password.length() == 0 || fromServer == null) {
            Buffer bresp = new Buffer(new byte[]{0});
            toServer.add(bresp);
        } else {
            try {
                if (this.stage == AuthStage.FAST_AUTH_SEND_SCRAMBLE) {
                    this.seed = fromServer.readString(NativeProtocol.StringSelfDataType.STRING_TERM, null);
                    toServer.add(new Buffer(Security.scrambleCachingSha2(StringUtils.getBytes(this.password, this.protocol.getPasswordCharacterEncoding()), this.seed.getBytes())));
                    this.stage = AuthStage.FAST_AUTH_READ_RESULT;
                    return true;
                }
                if (this.stage == AuthStage.FAST_AUTH_READ_RESULT) {
                    byte fastAuthResult = fromServer.readBytes(NativeProtocol.StringLengthDataType.STRING_FIXED, 1)[0];
                    switch (fastAuthResult) {
                        case 3: {
                            this.stage = AuthStage.FAST_AUTH_COMPLETE;
                            return true;
                        }
                        case 4: {
                            this.stage = AuthStage.FULL_AUTH;
                            break;
                        }
                        default: {
                            throw ExceptionFactory.createException("Unknown server response after fast auth.", this.protocol.getExceptionInterceptor());
                        }
                    }
                }
                if (this.protocol.getSocketConnection().isSSLEstablished()) {
                    Buffer bresp = new Buffer(StringUtils.getBytes(this.password, this.protocol.getPasswordCharacterEncoding()));
                    bresp.setPosition(bresp.getPayloadLength());
                    bresp.writeInteger(NativeProtocol.IntegerDataType.INT1, 0L);
                    bresp.setPosition(0);
                    toServer.add(bresp);
                } else if (this.serverRSAPublicKeyFile.getValue() != null) {
                    Buffer bresp = new Buffer(CachingSha2PasswordPlugin.encryptPassword(this.password, this.seed, this.publicKeyString, this.protocol.getPasswordCharacterEncoding()));
                    toServer.add(bresp);
                } else {
                    if (!this.protocol.getPropertySet().getBooleanReadableProperty("allowPublicKeyRetrieval").getValue().booleanValue()) {
                        throw ExceptionFactory.createException(UnableToConnectException.class, Messages.getString("Sha256PasswordPlugin.2"), this.protocol.getExceptionInterceptor());
                    }
                    if (this.publicKeyRequested && fromServer.getPayloadLength() > 20) {
                        Buffer bresp = new Buffer(CachingSha2PasswordPlugin.encryptPassword(this.password, this.seed, fromServer.readString(NativeProtocol.StringSelfDataType.STRING_TERM, null), this.protocol.getPasswordCharacterEncoding()));
                        toServer.add(bresp);
                        this.publicKeyRequested = false;
                    } else {
                        Buffer bresp = new Buffer(new byte[]{2});
                        toServer.add(bresp);
                        this.publicKeyRequested = true;
                    }
                }
            }
            catch (CJException | DigestException e) {
                throw ExceptionFactory.createException(e.getMessage(), e, this.protocol.getExceptionInterceptor());
            }
        }
        return true;
    }

    private static byte[] encryptPassword(String password, String seed, String key, String passwordCharacterEncoding) {
        byte[] byArray;
        if (password != null) {
            byArray = StringUtils.getBytesNullTerminated(password, passwordCharacterEncoding);
        } else {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 0;
        }
        byte[] input = byArray;
        byte[] mysqlScrambleBuff = new byte[input.length];
        Security.xorString(input, mysqlScrambleBuff, seed.getBytes(), input.length);
        return ExportControlled.encryptWithRSAPublicKey(mysqlScrambleBuff, ExportControlled.decodeRSAPublicKey(key), "RSA/ECB/PKCS1Padding");
    }

    public static enum AuthStage {
        FAST_AUTH_SEND_SCRAMBLE,
        FAST_AUTH_READ_RESULT,
        FAST_AUTH_COMPLETE,
        FULL_AUTH;

    }
}

