/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.core.conf;

import com.mysql.cj.api.conf.RuntimeProperty;
import com.mysql.cj.api.exceptions.ExceptionInterceptor;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.conf.AbstractPropertyDefinition;
import com.mysql.cj.core.conf.ModifiableEnumProperty;
import com.mysql.cj.core.conf.ReadableEnumProperty;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.util.StringUtils;
import java.util.Arrays;

public class EnumPropertyDefinition<T extends Enum<T>>
extends AbstractPropertyDefinition<T> {
    private static final long serialVersionUID = -3297521968759540444L;
    private Class<T> enumType;

    public EnumPropertyDefinition(String name, T defaultValue, boolean isRuntimeModifiable, String description, String sinceVersion, String category, int orderInCategory) {
        super(name, defaultValue, isRuntimeModifiable, description, sinceVersion, category, orderInCategory);
        if (defaultValue == null) {
            throw ExceptionFactory.createException("Enum property '" + name + "' cannot be initialized with null.");
        }
        this.enumType = ((Enum)defaultValue).getDeclaringClass();
    }

    @Override
    public String[] getAllowableValues() {
        return (String[])Arrays.stream(this.enumType.getEnumConstants()).map(Enum::toString).sorted().toArray(String[]::new);
    }

    @Override
    public T parseObject(String value, ExceptionInterceptor exceptionInterceptor) {
        try {
            return Enum.valueOf(this.enumType, value.toUpperCase());
        }
        catch (Exception e) {
            throw ExceptionFactory.createException(Messages.getString("PropertyDefinition.1", new Object[]{this.getName(), StringUtils.stringArrayToString(this.getAllowableValues(), "'", "', '", "' or '", "'"), value}), e, exceptionInterceptor);
        }
    }

    @Override
    public RuntimeProperty<T> createRuntimeProperty() {
        return this.isRuntimeModifiable() ? new ModifiableEnumProperty(this) : new ReadableEnumProperty(this);
    }
}

