/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.xdevapi;

import com.mysql.cj.api.xdevapi.Collection;
import com.mysql.cj.api.xdevapi.CreateTableStatement;
import com.mysql.cj.api.xdevapi.DatabaseObject;
import com.mysql.cj.api.xdevapi.Schema;
import com.mysql.cj.api.xdevapi.Session;
import com.mysql.cj.api.xdevapi.Table;
import com.mysql.cj.api.xdevapi.ViewCreate;
import com.mysql.cj.api.xdevapi.ViewDrop;
import com.mysql.cj.api.xdevapi.ViewUpdate;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.x.core.DatabaseObjectDescription;
import com.mysql.cj.x.core.MysqlxSession;
import com.mysql.cj.x.core.XDevAPIError;
import com.mysql.cj.xdevapi.CollectionImpl;
import com.mysql.cj.xdevapi.CreateTableStatementImpl;
import com.mysql.cj.xdevapi.CreateViewStatement;
import com.mysql.cj.xdevapi.DropViewStatement;
import com.mysql.cj.xdevapi.ExprUnparser;
import com.mysql.cj.xdevapi.TableImpl;
import com.mysql.cj.xdevapi.UpdateViewStatement;
import java.util.List;
import java.util.stream.Collectors;

public class SchemaImpl
implements Schema {
    private MysqlxSession mysqlxSession;
    private Session session;
    private String name;

    SchemaImpl(MysqlxSession mysqlxSession, Session session, String name) {
        this.mysqlxSession = mysqlxSession;
        this.session = session;
        this.name = name;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public Schema getSchema() {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DatabaseObject.DbObjectStatus existsInDatabase() {
        return this.mysqlxSession.schemaExists(this.name) ? DatabaseObject.DbObjectStatus.EXISTS : DatabaseObject.DbObjectStatus.NOT_EXISTS;
    }

    @Override
    public List<Collection> getCollections() {
        return this.mysqlxSession.getObjectNamesOfType(this.name, DatabaseObject.DbObjectType.COLLECTION).stream().map(this::getCollection).collect(Collectors.toList());
    }

    @Override
    public List<Collection> getCollections(String pattern) {
        return this.mysqlxSession.getObjectNamesOfType(this.name, pattern, DatabaseObject.DbObjectType.COLLECTION).stream().map(this::getCollection).collect(Collectors.toList());
    }

    @Override
    public List<Table> getTables() {
        return this.mysqlxSession.getObjectNamesOfType(this.name, DatabaseObject.DbObjectType.TABLE, DatabaseObject.DbObjectType.VIEW, DatabaseObject.DbObjectType.COLLECTION_VIEW).stream().map(this::getTable).collect(Collectors.toList());
    }

    @Override
    public List<Table> getTables(String pattern) {
        return this.mysqlxSession.getObjectNamesOfType(this.name, pattern, DatabaseObject.DbObjectType.TABLE, DatabaseObject.DbObjectType.VIEW, DatabaseObject.DbObjectType.COLLECTION_VIEW).stream().map(this::getTable).collect(Collectors.toList());
    }

    @Override
    public Collection getCollection(String collectionName) {
        return new CollectionImpl(this.mysqlxSession, this, collectionName);
    }

    @Override
    public Collection getCollection(String collectionName, boolean requireExists) {
        CollectionImpl coll = new CollectionImpl(this.mysqlxSession, this, collectionName);
        if (requireExists && coll.existsInDatabase() != DatabaseObject.DbObjectStatus.EXISTS) {
            throw new WrongArgumentException(coll.toString() + " doesn't exist");
        }
        return coll;
    }

    @Override
    public Table getCollectionAsTable(String collectionName) {
        return this.getTable(collectionName);
    }

    @Override
    public Table getTable(String tableName) {
        return new TableImpl(this.mysqlxSession, this, tableName);
    }

    Table getTable(DatabaseObjectDescription descr) {
        return new TableImpl(this.mysqlxSession, this, descr);
    }

    @Override
    public Table getTable(String tableName, boolean requireExists) {
        TableImpl table = new TableImpl(this.mysqlxSession, this, tableName);
        if (requireExists && table.existsInDatabase() != DatabaseObject.DbObjectStatus.EXISTS) {
            throw new WrongArgumentException(table.toString() + " doesn't exist");
        }
        return table;
    }

    @Override
    public Collection createCollection(String collectionName) {
        this.mysqlxSession.createCollection(this.name, collectionName);
        return new CollectionImpl(this.mysqlxSession, this, collectionName);
    }

    @Override
    public Collection createCollection(String collectionName, boolean reuseExistingObject) {
        try {
            return this.createCollection(collectionName);
        }
        catch (XDevAPIError ex) {
            if (ex.getErrorCode() == 1050) {
                return this.getCollection(collectionName);
            }
            throw ex;
        }
    }

    @Override
    public CreateTableStatement.CreateTableSplitStatement createTable(String tableName) {
        return new CreateTableStatementImpl(this.mysqlxSession, this, tableName);
    }

    @Override
    public CreateTableStatement.CreateTableSplitStatement createTable(String tableName, boolean reuseExistingObject) {
        return new CreateTableStatementImpl(this.mysqlxSession, this, tableName, reuseExistingObject);
    }

    public boolean equals(Object other) {
        return other != null && other.getClass() == SchemaImpl.class && ((SchemaImpl)other).session == this.session && ((SchemaImpl)other).mysqlxSession == this.mysqlxSession && this.name.equals(((SchemaImpl)other).name);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Schema(");
        sb.append(ExprUnparser.quoteIdentifier(this.name));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public ViewCreate createView(String viewName, boolean replace) {
        return new CreateViewStatement(this.mysqlxSession, this, viewName, replace);
    }

    @Override
    public ViewUpdate alterView(String viewName) {
        return new UpdateViewStatement(this.mysqlxSession, this, viewName);
    }

    @Override
    public ViewDrop dropView(String viewName) {
        return new DropViewStatement(this.mysqlxSession, this, viewName);
    }
}

