/*
  Copyright (c) 2015, 2017, Oracle and/or its affiliates. All rights reserved.

  The MySQL Connector/J is licensed under the terms of the GPLv2
  <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>, like most MySQL Connectors.
  There are special exceptions to the terms and conditions of the GPLv2 as it is applied to
  this software, see the FOSS License Exception
  <http://www.mysql.com/about/legal/licensing/foss-exception.html>.

  This program is free software; you can redistribute it and/or modify it under the terms
  of the GNU General Public License as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with this
  program; if not, write to the Free Software Foundation, Inc., 51 Franklin St, Fifth
  Floor, Boston, MA 02110-1301  USA

 */

package com.mysql.cj.x.protobuf;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: mysqlx.proto

public final class Mysqlx {
  private Mysqlx() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
  }
  public interface ClientMessagesOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.ClientMessages)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * Protobuf type {@code Mysqlx.ClientMessages}
   *
   * <pre>
   * IDs of messages that can be sent from client to the server
   * .. note::
   *   this message is never sent on the wire. It is only used to let ``protoc``
   *   * generate constants
   *   * check for uniqueness
   * </pre>
   */
  public static final class ClientMessages extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.ClientMessages)
      ClientMessagesOrBuilder {
    // Use ClientMessages.newBuilder() to construct.
    private ClientMessages(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private ClientMessages(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final ClientMessages defaultInstance;
    public static ClientMessages getDefaultInstance() {
      return defaultInstance;
    }

    public ClientMessages getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private ClientMessages(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.Mysqlx.internal_static_Mysqlx_ClientMessages_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.Mysqlx.internal_static_Mysqlx_ClientMessages_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.Mysqlx.ClientMessages.class, com.mysql.cj.x.protobuf.Mysqlx.ClientMessages.Builder.class);
    }

    public static com.google.protobuf.Parser<ClientMessages> PARSER =
        new com.google.protobuf.AbstractParser<ClientMessages>() {
      public ClientMessages parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new ClientMessages(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<ClientMessages> getParserForType() {
      return PARSER;
    }

    /**
     * Protobuf enum {@code Mysqlx.ClientMessages.Type}
     */
    public enum Type
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>CON_CAPABILITIES_GET = 1;</code>
       */
      CON_CAPABILITIES_GET(0, 1),
      /**
       * <code>CON_CAPABILITIES_SET = 2;</code>
       */
      CON_CAPABILITIES_SET(1, 2),
      /**
       * <code>CON_CLOSE = 3;</code>
       */
      CON_CLOSE(2, 3),
      /**
       * <code>SESS_AUTHENTICATE_START = 4;</code>
       */
      SESS_AUTHENTICATE_START(3, 4),
      /**
       * <code>SESS_AUTHENTICATE_CONTINUE = 5;</code>
       */
      SESS_AUTHENTICATE_CONTINUE(4, 5),
      /**
       * <code>SESS_RESET = 6;</code>
       */
      SESS_RESET(5, 6),
      /**
       * <code>SESS_CLOSE = 7;</code>
       */
      SESS_CLOSE(6, 7),
      /**
       * <code>SQL_STMT_EXECUTE = 12;</code>
       */
      SQL_STMT_EXECUTE(7, 12),
      /**
       * <code>CRUD_FIND = 17;</code>
       */
      CRUD_FIND(8, 17),
      /**
       * <code>CRUD_INSERT = 18;</code>
       */
      CRUD_INSERT(9, 18),
      /**
       * <code>CRUD_UPDATE = 19;</code>
       */
      CRUD_UPDATE(10, 19),
      /**
       * <code>CRUD_DELETE = 20;</code>
       */
      CRUD_DELETE(11, 20),
      /**
       * <code>EXPECT_OPEN = 24;</code>
       */
      EXPECT_OPEN(12, 24),
      /**
       * <code>EXPECT_CLOSE = 25;</code>
       */
      EXPECT_CLOSE(13, 25),
      /**
       * <code>CRUD_CREATE_VIEW = 30;</code>
       */
      CRUD_CREATE_VIEW(14, 30),
      /**
       * <code>CRUD_MODIFY_VIEW = 31;</code>
       */
      CRUD_MODIFY_VIEW(15, 31),
      /**
       * <code>CRUD_DROP_VIEW = 32;</code>
       */
      CRUD_DROP_VIEW(16, 32),
      /**
       * <code>CRUD_FIND_V2 = 33;</code>
       */
      CRUD_FIND_V2(17, 33),
      ;

      /**
       * <code>CON_CAPABILITIES_GET = 1;</code>
       */
      public static final int CON_CAPABILITIES_GET_VALUE = 1;
      /**
       * <code>CON_CAPABILITIES_SET = 2;</code>
       */
      public static final int CON_CAPABILITIES_SET_VALUE = 2;
      /**
       * <code>CON_CLOSE = 3;</code>
       */
      public static final int CON_CLOSE_VALUE = 3;
      /**
       * <code>SESS_AUTHENTICATE_START = 4;</code>
       */
      public static final int SESS_AUTHENTICATE_START_VALUE = 4;
      /**
       * <code>SESS_AUTHENTICATE_CONTINUE = 5;</code>
       */
      public static final int SESS_AUTHENTICATE_CONTINUE_VALUE = 5;
      /**
       * <code>SESS_RESET = 6;</code>
       */
      public static final int SESS_RESET_VALUE = 6;
      /**
       * <code>SESS_CLOSE = 7;</code>
       */
      public static final int SESS_CLOSE_VALUE = 7;
      /**
       * <code>SQL_STMT_EXECUTE = 12;</code>
       */
      public static final int SQL_STMT_EXECUTE_VALUE = 12;
      /**
       * <code>CRUD_FIND = 17;</code>
       */
      public static final int CRUD_FIND_VALUE = 17;
      /**
       * <code>CRUD_INSERT = 18;</code>
       */
      public static final int CRUD_INSERT_VALUE = 18;
      /**
       * <code>CRUD_UPDATE = 19;</code>
       */
      public static final int CRUD_UPDATE_VALUE = 19;
      /**
       * <code>CRUD_DELETE = 20;</code>
       */
      public static final int CRUD_DELETE_VALUE = 20;
      /**
       * <code>EXPECT_OPEN = 24;</code>
       */
      public static final int EXPECT_OPEN_VALUE = 24;
      /**
       * <code>EXPECT_CLOSE = 25;</code>
       */
      public static final int EXPECT_CLOSE_VALUE = 25;
      /**
       * <code>CRUD_CREATE_VIEW = 30;</code>
       */
      public static final int CRUD_CREATE_VIEW_VALUE = 30;
      /**
       * <code>CRUD_MODIFY_VIEW = 31;</code>
       */
      public static final int CRUD_MODIFY_VIEW_VALUE = 31;
      /**
       * <code>CRUD_DROP_VIEW = 32;</code>
       */
      public static final int CRUD_DROP_VIEW_VALUE = 32;
      /**
       * <code>CRUD_FIND_V2 = 33;</code>
       */
      public static final int CRUD_FIND_V2_VALUE = 33;


      public final int getNumber() { return value; }

      public static Type valueOf(int value) {
        switch (value) {
          case 1: return CON_CAPABILITIES_GET;
          case 2: return CON_CAPABILITIES_SET;
          case 3: return CON_CLOSE;
          case 4: return SESS_AUTHENTICATE_START;
          case 5: return SESS_AUTHENTICATE_CONTINUE;
          case 6: return SESS_RESET;
          case 7: return SESS_CLOSE;
          case 12: return SQL_STMT_EXECUTE;
          case 17: return CRUD_FIND;
          case 18: return CRUD_INSERT;
          case 19: return CRUD_UPDATE;
          case 20: return CRUD_DELETE;
          case 24: return EXPECT_OPEN;
          case 25: return EXPECT_CLOSE;
          case 30: return CRUD_CREATE_VIEW;
          case 31: return CRUD_MODIFY_VIEW;
          case 32: return CRUD_DROP_VIEW;
          case 33: return CRUD_FIND_V2;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static com.google.protobuf.Internal.EnumLiteMap<Type>
          internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Type>() {
              public Type findValueByNumber(int number) {
                return Type.valueOf(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(index);
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.Mysqlx.ClientMessages.getDescriptor().getEnumTypes().get(0);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int index;
      private final int value;

      private Type(int index, int value) {
        this.index = index;
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.ClientMessages.Type)
    }

    private void initFields() {
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.Mysqlx.ClientMessages parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.ClientMessages parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.ClientMessages parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.ClientMessages parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.ClientMessages parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.ClientMessages parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.ClientMessages parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.ClientMessages parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.ClientMessages parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.ClientMessages parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.Mysqlx.ClientMessages prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.ClientMessages}
     *
     * <pre>
     * IDs of messages that can be sent from client to the server
     * .. note::
     *   this message is never sent on the wire. It is only used to let ``protoc``
     *   * generate constants
     *   * check for uniqueness
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.ClientMessages)
        com.mysql.cj.x.protobuf.Mysqlx.ClientMessagesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.Mysqlx.internal_static_Mysqlx_ClientMessages_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.Mysqlx.internal_static_Mysqlx_ClientMessages_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.Mysqlx.ClientMessages.class, com.mysql.cj.x.protobuf.Mysqlx.ClientMessages.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.Mysqlx.ClientMessages.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.Mysqlx.internal_static_Mysqlx_ClientMessages_descriptor;
      }

      public com.mysql.cj.x.protobuf.Mysqlx.ClientMessages getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.Mysqlx.ClientMessages.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.Mysqlx.ClientMessages build() {
        com.mysql.cj.x.protobuf.Mysqlx.ClientMessages result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.Mysqlx.ClientMessages buildPartial() {
        com.mysql.cj.x.protobuf.Mysqlx.ClientMessages result = new com.mysql.cj.x.protobuf.Mysqlx.ClientMessages(this);
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.Mysqlx.ClientMessages) {
          return mergeFrom((com.mysql.cj.x.protobuf.Mysqlx.ClientMessages)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.Mysqlx.ClientMessages other) {
        if (other == com.mysql.cj.x.protobuf.Mysqlx.ClientMessages.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.Mysqlx.ClientMessages parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.Mysqlx.ClientMessages) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.ClientMessages)
    }

    static {
      defaultInstance = new ClientMessages(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.ClientMessages)
  }

  public interface ServerMessagesOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.ServerMessages)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * Protobuf type {@code Mysqlx.ServerMessages}
   *
   * <pre>
   * IDs of messages that can be sent from server to client
   * .. note::
   *   this message is never sent on the wire. It is only used to let ``protoc``
   *   * generate constants
   *   * check for uniqueness
   * </pre>
   */
  public static final class ServerMessages extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.ServerMessages)
      ServerMessagesOrBuilder {
    // Use ServerMessages.newBuilder() to construct.
    private ServerMessages(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private ServerMessages(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final ServerMessages defaultInstance;
    public static ServerMessages getDefaultInstance() {
      return defaultInstance;
    }

    public ServerMessages getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private ServerMessages(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.Mysqlx.internal_static_Mysqlx_ServerMessages_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.Mysqlx.internal_static_Mysqlx_ServerMessages_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.Mysqlx.ServerMessages.class, com.mysql.cj.x.protobuf.Mysqlx.ServerMessages.Builder.class);
    }

    public static com.google.protobuf.Parser<ServerMessages> PARSER =
        new com.google.protobuf.AbstractParser<ServerMessages>() {
      public ServerMessages parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new ServerMessages(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<ServerMessages> getParserForType() {
      return PARSER;
    }

    /**
     * Protobuf enum {@code Mysqlx.ServerMessages.Type}
     */
    public enum Type
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>OK = 0;</code>
       */
      OK(0, 0),
      /**
       * <code>ERROR = 1;</code>
       */
      ERROR(1, 1),
      /**
       * <code>CONN_CAPABILITIES = 2;</code>
       */
      CONN_CAPABILITIES(2, 2),
      /**
       * <code>SESS_AUTHENTICATE_CONTINUE = 3;</code>
       */
      SESS_AUTHENTICATE_CONTINUE(3, 3),
      /**
       * <code>SESS_AUTHENTICATE_OK = 4;</code>
       */
      SESS_AUTHENTICATE_OK(4, 4),
      /**
       * <code>NOTICE = 11;</code>
       *
       * <pre>
       * NOTICE has to stay at 11 forever
       * </pre>
       */
      NOTICE(5, 11),
      /**
       * <code>RESULTSET_COLUMN_META_DATA = 12;</code>
       */
      RESULTSET_COLUMN_META_DATA(6, 12),
      /**
       * <code>RESULTSET_ROW = 13;</code>
       */
      RESULTSET_ROW(7, 13),
      /**
       * <code>RESULTSET_FETCH_DONE = 14;</code>
       */
      RESULTSET_FETCH_DONE(8, 14),
      /**
       * <code>RESULTSET_FETCH_SUSPENDED = 15;</code>
       */
      RESULTSET_FETCH_SUSPENDED(9, 15),
      /**
       * <code>RESULTSET_FETCH_DONE_MORE_RESULTSETS = 16;</code>
       */
      RESULTSET_FETCH_DONE_MORE_RESULTSETS(10, 16),
      /**
       * <code>SQL_STMT_EXECUTE_OK = 17;</code>
       */
      SQL_STMT_EXECUTE_OK(11, 17),
      /**
       * <code>RESULTSET_FETCH_DONE_MORE_OUT_PARAMS = 18;</code>
       */
      RESULTSET_FETCH_DONE_MORE_OUT_PARAMS(12, 18),
      ;

      /**
       * <code>OK = 0;</code>
       */
      public static final int OK_VALUE = 0;
      /**
       * <code>ERROR = 1;</code>
       */
      public static final int ERROR_VALUE = 1;
      /**
       * <code>CONN_CAPABILITIES = 2;</code>
       */
      public static final int CONN_CAPABILITIES_VALUE = 2;
      /**
       * <code>SESS_AUTHENTICATE_CONTINUE = 3;</code>
       */
      public static final int SESS_AUTHENTICATE_CONTINUE_VALUE = 3;
      /**
       * <code>SESS_AUTHENTICATE_OK = 4;</code>
       */
      public static final int SESS_AUTHENTICATE_OK_VALUE = 4;
      /**
       * <code>NOTICE = 11;</code>
       *
       * <pre>
       * NOTICE has to stay at 11 forever
       * </pre>
       */
      public static final int NOTICE_VALUE = 11;
      /**
       * <code>RESULTSET_COLUMN_META_DATA = 12;</code>
       */
      public static final int RESULTSET_COLUMN_META_DATA_VALUE = 12;
      /**
       * <code>RESULTSET_ROW = 13;</code>
       */
      public static final int RESULTSET_ROW_VALUE = 13;
      /**
       * <code>RESULTSET_FETCH_DONE = 14;</code>
       */
      public static final int RESULTSET_FETCH_DONE_VALUE = 14;
      /**
       * <code>RESULTSET_FETCH_SUSPENDED = 15;</code>
       */
      public static final int RESULTSET_FETCH_SUSPENDED_VALUE = 15;
      /**
       * <code>RESULTSET_FETCH_DONE_MORE_RESULTSETS = 16;</code>
       */
      public static final int RESULTSET_FETCH_DONE_MORE_RESULTSETS_VALUE = 16;
      /**
       * <code>SQL_STMT_EXECUTE_OK = 17;</code>
       */
      public static final int SQL_STMT_EXECUTE_OK_VALUE = 17;
      /**
       * <code>RESULTSET_FETCH_DONE_MORE_OUT_PARAMS = 18;</code>
       */
      public static final int RESULTSET_FETCH_DONE_MORE_OUT_PARAMS_VALUE = 18;


      public final int getNumber() { return value; }

      public static Type valueOf(int value) {
        switch (value) {
          case 0: return OK;
          case 1: return ERROR;
          case 2: return CONN_CAPABILITIES;
          case 3: return SESS_AUTHENTICATE_CONTINUE;
          case 4: return SESS_AUTHENTICATE_OK;
          case 11: return NOTICE;
          case 12: return RESULTSET_COLUMN_META_DATA;
          case 13: return RESULTSET_ROW;
          case 14: return RESULTSET_FETCH_DONE;
          case 15: return RESULTSET_FETCH_SUSPENDED;
          case 16: return RESULTSET_FETCH_DONE_MORE_RESULTSETS;
          case 17: return SQL_STMT_EXECUTE_OK;
          case 18: return RESULTSET_FETCH_DONE_MORE_OUT_PARAMS;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static com.google.protobuf.Internal.EnumLiteMap<Type>
          internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Type>() {
              public Type findValueByNumber(int number) {
                return Type.valueOf(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(index);
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.Mysqlx.ServerMessages.getDescriptor().getEnumTypes().get(0);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int index;
      private final int value;

      private Type(int index, int value) {
        this.index = index;
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.ServerMessages.Type)
    }

    private void initFields() {
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.Mysqlx.ServerMessages parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.ServerMessages parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.ServerMessages parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.ServerMessages parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.ServerMessages parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.ServerMessages parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.ServerMessages parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.ServerMessages parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.ServerMessages parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.ServerMessages parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.Mysqlx.ServerMessages prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.ServerMessages}
     *
     * <pre>
     * IDs of messages that can be sent from server to client
     * .. note::
     *   this message is never sent on the wire. It is only used to let ``protoc``
     *   * generate constants
     *   * check for uniqueness
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.ServerMessages)
        com.mysql.cj.x.protobuf.Mysqlx.ServerMessagesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.Mysqlx.internal_static_Mysqlx_ServerMessages_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.Mysqlx.internal_static_Mysqlx_ServerMessages_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.Mysqlx.ServerMessages.class, com.mysql.cj.x.protobuf.Mysqlx.ServerMessages.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.Mysqlx.ServerMessages.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.Mysqlx.internal_static_Mysqlx_ServerMessages_descriptor;
      }

      public com.mysql.cj.x.protobuf.Mysqlx.ServerMessages getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.Mysqlx.ServerMessages.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.Mysqlx.ServerMessages build() {
        com.mysql.cj.x.protobuf.Mysqlx.ServerMessages result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.Mysqlx.ServerMessages buildPartial() {
        com.mysql.cj.x.protobuf.Mysqlx.ServerMessages result = new com.mysql.cj.x.protobuf.Mysqlx.ServerMessages(this);
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.Mysqlx.ServerMessages) {
          return mergeFrom((com.mysql.cj.x.protobuf.Mysqlx.ServerMessages)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.Mysqlx.ServerMessages other) {
        if (other == com.mysql.cj.x.protobuf.Mysqlx.ServerMessages.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.Mysqlx.ServerMessages parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.Mysqlx.ServerMessages) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.ServerMessages)
    }

    static {
      defaultInstance = new ServerMessages(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.ServerMessages)
  }

  public interface OkOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Ok)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional string msg = 1;</code>
     */
    boolean hasMsg();
    /**
     * <code>optional string msg = 1;</code>
     */
    java.lang.String getMsg();
    /**
     * <code>optional string msg = 1;</code>
     */
    com.google.protobuf.ByteString
        getMsgBytes();
  }
  /**
   * Protobuf type {@code Mysqlx.Ok}
   *
   * <pre>
   * generic Ok message
   * </pre>
   */
  public static final class Ok extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Ok)
      OkOrBuilder {
    // Use Ok.newBuilder() to construct.
    private Ok(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Ok(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Ok defaultInstance;
    public static Ok getDefaultInstance() {
      return defaultInstance;
    }

    public Ok getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Ok(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              msg_ = bs;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.Mysqlx.internal_static_Mysqlx_Ok_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.Mysqlx.internal_static_Mysqlx_Ok_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.Mysqlx.Ok.class, com.mysql.cj.x.protobuf.Mysqlx.Ok.Builder.class);
    }

    public static com.google.protobuf.Parser<Ok> PARSER =
        new com.google.protobuf.AbstractParser<Ok>() {
      public Ok parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Ok(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Ok> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int MSG_FIELD_NUMBER = 1;
    private java.lang.Object msg_;
    /**
     * <code>optional string msg = 1;</code>
     */
    public boolean hasMsg() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional string msg = 1;</code>
     */
    public java.lang.String getMsg() {
      java.lang.Object ref = msg_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          msg_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string msg = 1;</code>
     */
    public com.google.protobuf.ByteString
        getMsgBytes() {
      java.lang.Object ref = msg_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        msg_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private void initFields() {
      msg_ = "";
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getMsgBytes());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getMsgBytes());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.Mysqlx.Ok parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.Ok parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.Ok parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.Ok parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.Ok parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.Ok parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.Ok parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.Ok parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.Ok parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.Ok parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.Mysqlx.Ok prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Ok}
     *
     * <pre>
     * generic Ok message
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Ok)
        com.mysql.cj.x.protobuf.Mysqlx.OkOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.Mysqlx.internal_static_Mysqlx_Ok_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.Mysqlx.internal_static_Mysqlx_Ok_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.Mysqlx.Ok.class, com.mysql.cj.x.protobuf.Mysqlx.Ok.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.Mysqlx.Ok.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        msg_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.Mysqlx.internal_static_Mysqlx_Ok_descriptor;
      }

      public com.mysql.cj.x.protobuf.Mysqlx.Ok getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.Mysqlx.Ok.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.Mysqlx.Ok build() {
        com.mysql.cj.x.protobuf.Mysqlx.Ok result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.Mysqlx.Ok buildPartial() {
        com.mysql.cj.x.protobuf.Mysqlx.Ok result = new com.mysql.cj.x.protobuf.Mysqlx.Ok(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.msg_ = msg_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.Mysqlx.Ok) {
          return mergeFrom((com.mysql.cj.x.protobuf.Mysqlx.Ok)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.Mysqlx.Ok other) {
        if (other == com.mysql.cj.x.protobuf.Mysqlx.Ok.getDefaultInstance()) return this;
        if (other.hasMsg()) {
          bitField0_ |= 0x00000001;
          msg_ = other.msg_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.Mysqlx.Ok parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.Mysqlx.Ok) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object msg_ = "";
      /**
       * <code>optional string msg = 1;</code>
       */
      public boolean hasMsg() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional string msg = 1;</code>
       */
      public java.lang.String getMsg() {
        java.lang.Object ref = msg_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            msg_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string msg = 1;</code>
       */
      public com.google.protobuf.ByteString
          getMsgBytes() {
        java.lang.Object ref = msg_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          msg_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string msg = 1;</code>
       */
      public Builder setMsg(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        msg_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string msg = 1;</code>
       */
      public Builder clearMsg() {
        bitField0_ = (bitField0_ & ~0x00000001);
        msg_ = getDefaultInstance().getMsg();
        onChanged();
        return this;
      }
      /**
       * <code>optional string msg = 1;</code>
       */
      public Builder setMsgBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        msg_ = value;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Ok)
    }

    static {
      defaultInstance = new Ok(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Ok)
  }

  public interface ErrorOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Error)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional .Mysqlx.Error.Severity severity = 1 [default = ERROR];</code>
     */
    boolean hasSeverity();
    /**
     * <code>optional .Mysqlx.Error.Severity severity = 1 [default = ERROR];</code>
     */
    com.mysql.cj.x.protobuf.Mysqlx.Error.Severity getSeverity();

    /**
     * <code>required uint32 code = 2;</code>
     */
    boolean hasCode();
    /**
     * <code>required uint32 code = 2;</code>
     */
    int getCode();

    /**
     * <code>required string sql_state = 4;</code>
     */
    boolean hasSqlState();
    /**
     * <code>required string sql_state = 4;</code>
     */
    java.lang.String getSqlState();
    /**
     * <code>required string sql_state = 4;</code>
     */
    com.google.protobuf.ByteString
        getSqlStateBytes();

    /**
     * <code>required string msg = 3;</code>
     */
    boolean hasMsg();
    /**
     * <code>required string msg = 3;</code>
     */
    java.lang.String getMsg();
    /**
     * <code>required string msg = 3;</code>
     */
    com.google.protobuf.ByteString
        getMsgBytes();
  }
  /**
   * Protobuf type {@code Mysqlx.Error}
   *
   * <pre>
   * generic Error message
   * A ``severity`` of ``ERROR`` indicates the current message sequence is
   * aborted for the given error and the session is ready for more.
   * In case of a ``FATAL`` error message the client should not expect
   * the server to continue handling any further messages and should
   * close the connection.
   * :param severity: severity of the error message
   * :param code: error-code
   * :param sql_state: SQL state
   * :param msg: human readable error message
   * </pre>
   */
  public static final class Error extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Error)
      ErrorOrBuilder {
    // Use Error.newBuilder() to construct.
    private Error(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Error(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Error defaultInstance;
    public static Error getDefaultInstance() {
      return defaultInstance;
    }

    public Error getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Error(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.Mysqlx.Error.Severity value = com.mysql.cj.x.protobuf.Mysqlx.Error.Severity.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(1, rawValue);
              } else {
                bitField0_ |= 0x00000001;
                severity_ = value;
              }
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              code_ = input.readUInt32();
              break;
            }
            case 26: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000008;
              msg_ = bs;
              break;
            }
            case 34: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000004;
              sqlState_ = bs;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.Mysqlx.internal_static_Mysqlx_Error_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.Mysqlx.internal_static_Mysqlx_Error_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.Mysqlx.Error.class, com.mysql.cj.x.protobuf.Mysqlx.Error.Builder.class);
    }

    public static com.google.protobuf.Parser<Error> PARSER =
        new com.google.protobuf.AbstractParser<Error>() {
      public Error parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Error(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Error> getParserForType() {
      return PARSER;
    }

    /**
     * Protobuf enum {@code Mysqlx.Error.Severity}
     */
    public enum Severity
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>ERROR = 0;</code>
       */
      ERROR(0, 0),
      /**
       * <code>FATAL = 1;</code>
       */
      FATAL(1, 1),
      ;

      /**
       * <code>ERROR = 0;</code>
       */
      public static final int ERROR_VALUE = 0;
      /**
       * <code>FATAL = 1;</code>
       */
      public static final int FATAL_VALUE = 1;


      public final int getNumber() { return value; }

      public static Severity valueOf(int value) {
        switch (value) {
          case 0: return ERROR;
          case 1: return FATAL;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Severity>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static com.google.protobuf.Internal.EnumLiteMap<Severity>
          internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Severity>() {
              public Severity findValueByNumber(int number) {
                return Severity.valueOf(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(index);
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.Mysqlx.Error.getDescriptor().getEnumTypes().get(0);
      }

      private static final Severity[] VALUES = values();

      public static Severity valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int index;
      private final int value;

      private Severity(int index, int value) {
        this.index = index;
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Error.Severity)
    }

    private int bitField0_;
    public static final int SEVERITY_FIELD_NUMBER = 1;
    private com.mysql.cj.x.protobuf.Mysqlx.Error.Severity severity_;
    /**
     * <code>optional .Mysqlx.Error.Severity severity = 1 [default = ERROR];</code>
     */
    public boolean hasSeverity() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .Mysqlx.Error.Severity severity = 1 [default = ERROR];</code>
     */
    public com.mysql.cj.x.protobuf.Mysqlx.Error.Severity getSeverity() {
      return severity_;
    }

    public static final int CODE_FIELD_NUMBER = 2;
    private int code_;
    /**
     * <code>required uint32 code = 2;</code>
     */
    public boolean hasCode() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>required uint32 code = 2;</code>
     */
    public int getCode() {
      return code_;
    }

    public static final int SQL_STATE_FIELD_NUMBER = 4;
    private java.lang.Object sqlState_;
    /**
     * <code>required string sql_state = 4;</code>
     */
    public boolean hasSqlState() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>required string sql_state = 4;</code>
     */
    public java.lang.String getSqlState() {
      java.lang.Object ref = sqlState_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          sqlState_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string sql_state = 4;</code>
     */
    public com.google.protobuf.ByteString
        getSqlStateBytes() {
      java.lang.Object ref = sqlState_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        sqlState_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MSG_FIELD_NUMBER = 3;
    private java.lang.Object msg_;
    /**
     * <code>required string msg = 3;</code>
     */
    public boolean hasMsg() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>required string msg = 3;</code>
     */
    public java.lang.String getMsg() {
      java.lang.Object ref = msg_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          msg_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string msg = 3;</code>
     */
    public com.google.protobuf.ByteString
        getMsgBytes() {
      java.lang.Object ref = msg_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        msg_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private void initFields() {
      severity_ = com.mysql.cj.x.protobuf.Mysqlx.Error.Severity.ERROR;
      code_ = 0;
      sqlState_ = "";
      msg_ = "";
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasCode()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasSqlState()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasMsg()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeEnum(1, severity_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt32(2, code_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeBytes(3, getMsgBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBytes(4, getSqlStateBytes());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, severity_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(2, code_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, getMsgBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(4, getSqlStateBytes());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.Mysqlx.Error parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.Error parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.Error parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.Error parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.Error parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.Error parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.Error parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.Error parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.Error parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.Mysqlx.Error parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.Mysqlx.Error prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Error}
     *
     * <pre>
     * generic Error message
     * A ``severity`` of ``ERROR`` indicates the current message sequence is
     * aborted for the given error and the session is ready for more.
     * In case of a ``FATAL`` error message the client should not expect
     * the server to continue handling any further messages and should
     * close the connection.
     * :param severity: severity of the error message
     * :param code: error-code
     * :param sql_state: SQL state
     * :param msg: human readable error message
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Error)
        com.mysql.cj.x.protobuf.Mysqlx.ErrorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.Mysqlx.internal_static_Mysqlx_Error_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.Mysqlx.internal_static_Mysqlx_Error_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.Mysqlx.Error.class, com.mysql.cj.x.protobuf.Mysqlx.Error.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.Mysqlx.Error.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        severity_ = com.mysql.cj.x.protobuf.Mysqlx.Error.Severity.ERROR;
        bitField0_ = (bitField0_ & ~0x00000001);
        code_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        sqlState_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        msg_ = "";
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.Mysqlx.internal_static_Mysqlx_Error_descriptor;
      }

      public com.mysql.cj.x.protobuf.Mysqlx.Error getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.Mysqlx.Error.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.Mysqlx.Error build() {
        com.mysql.cj.x.protobuf.Mysqlx.Error result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.Mysqlx.Error buildPartial() {
        com.mysql.cj.x.protobuf.Mysqlx.Error result = new com.mysql.cj.x.protobuf.Mysqlx.Error(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.severity_ = severity_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.code_ = code_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.sqlState_ = sqlState_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.msg_ = msg_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.Mysqlx.Error) {
          return mergeFrom((com.mysql.cj.x.protobuf.Mysqlx.Error)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.Mysqlx.Error other) {
        if (other == com.mysql.cj.x.protobuf.Mysqlx.Error.getDefaultInstance()) return this;
        if (other.hasSeverity()) {
          setSeverity(other.getSeverity());
        }
        if (other.hasCode()) {
          setCode(other.getCode());
        }
        if (other.hasSqlState()) {
          bitField0_ |= 0x00000004;
          sqlState_ = other.sqlState_;
          onChanged();
        }
        if (other.hasMsg()) {
          bitField0_ |= 0x00000008;
          msg_ = other.msg_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasCode()) {
          
          return false;
        }
        if (!hasSqlState()) {
          
          return false;
        }
        if (!hasMsg()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.Mysqlx.Error parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.Mysqlx.Error) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.mysql.cj.x.protobuf.Mysqlx.Error.Severity severity_ = com.mysql.cj.x.protobuf.Mysqlx.Error.Severity.ERROR;
      /**
       * <code>optional .Mysqlx.Error.Severity severity = 1 [default = ERROR];</code>
       */
      public boolean hasSeverity() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .Mysqlx.Error.Severity severity = 1 [default = ERROR];</code>
       */
      public com.mysql.cj.x.protobuf.Mysqlx.Error.Severity getSeverity() {
        return severity_;
      }
      /**
       * <code>optional .Mysqlx.Error.Severity severity = 1 [default = ERROR];</code>
       */
      public Builder setSeverity(com.mysql.cj.x.protobuf.Mysqlx.Error.Severity value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        severity_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Error.Severity severity = 1 [default = ERROR];</code>
       */
      public Builder clearSeverity() {
        bitField0_ = (bitField0_ & ~0x00000001);
        severity_ = com.mysql.cj.x.protobuf.Mysqlx.Error.Severity.ERROR;
        onChanged();
        return this;
      }

      private int code_ ;
      /**
       * <code>required uint32 code = 2;</code>
       */
      public boolean hasCode() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>required uint32 code = 2;</code>
       */
      public int getCode() {
        return code_;
      }
      /**
       * <code>required uint32 code = 2;</code>
       */
      public Builder setCode(int value) {
        bitField0_ |= 0x00000002;
        code_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint32 code = 2;</code>
       */
      public Builder clearCode() {
        bitField0_ = (bitField0_ & ~0x00000002);
        code_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object sqlState_ = "";
      /**
       * <code>required string sql_state = 4;</code>
       */
      public boolean hasSqlState() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>required string sql_state = 4;</code>
       */
      public java.lang.String getSqlState() {
        java.lang.Object ref = sqlState_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            sqlState_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string sql_state = 4;</code>
       */
      public com.google.protobuf.ByteString
          getSqlStateBytes() {
        java.lang.Object ref = sqlState_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          sqlState_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string sql_state = 4;</code>
       */
      public Builder setSqlState(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        sqlState_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string sql_state = 4;</code>
       */
      public Builder clearSqlState() {
        bitField0_ = (bitField0_ & ~0x00000004);
        sqlState_ = getDefaultInstance().getSqlState();
        onChanged();
        return this;
      }
      /**
       * <code>required string sql_state = 4;</code>
       */
      public Builder setSqlStateBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        sqlState_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object msg_ = "";
      /**
       * <code>required string msg = 3;</code>
       */
      public boolean hasMsg() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>required string msg = 3;</code>
       */
      public java.lang.String getMsg() {
        java.lang.Object ref = msg_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            msg_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string msg = 3;</code>
       */
      public com.google.protobuf.ByteString
          getMsgBytes() {
        java.lang.Object ref = msg_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          msg_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string msg = 3;</code>
       */
      public Builder setMsg(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        msg_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string msg = 3;</code>
       */
      public Builder clearMsg() {
        bitField0_ = (bitField0_ & ~0x00000008);
        msg_ = getDefaultInstance().getMsg();
        onChanged();
        return this;
      }
      /**
       * <code>required string msg = 3;</code>
       */
      public Builder setMsgBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        msg_ = value;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Error)
    }

    static {
      defaultInstance = new Error(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Error)
  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_ClientMessages_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_ClientMessages_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_ServerMessages_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_ServerMessages_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Ok_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Ok_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Error_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Error_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\014mysqlx.proto\022\006Mysqlx\032\020mysqlx_sql.proto" +
      "\032\026mysqlx_resultset.proto\032\021mysqlx_crud.pr" +
      "oto\032\024mysqlx_session.proto\032\027mysqlx_connec" +
      "tion.proto\032\023mysqlx_expect.proto\032\023mysqlx_" +
      "notice.proto\"\206\003\n\016ClientMessages\"\363\002\n\004Type" +
      "\022\030\n\024CON_CAPABILITIES_GET\020\001\022\030\n\024CON_CAPABI" +
      "LITIES_SET\020\002\022\r\n\tCON_CLOSE\020\003\022\033\n\027SESS_AUTH" +
      "ENTICATE_START\020\004\022\036\n\032SESS_AUTHENTICATE_CO" +
      "NTINUE\020\005\022\016\n\nSESS_RESET\020\006\022\016\n\nSESS_CLOSE\020\007" +
      "\022\024\n\020SQL_STMT_EXECUTE\020\014\022\r\n\tCRUD_FIND\020\021\022\017\n",
      "\013CRUD_INSERT\020\022\022\017\n\013CRUD_UPDATE\020\023\022\017\n\013CRUD_" +
      "DELETE\020\024\022\017\n\013EXPECT_OPEN\020\030\022\020\n\014EXPECT_CLOS" +
      "E\020\031\022\024\n\020CRUD_CREATE_VIEW\020\036\022\024\n\020CRUD_MODIFY" +
      "_VIEW\020\037\022\022\n\016CRUD_DROP_VIEW\020 \022\020\n\014CRUD_FIND" +
      "_V2\020!\"\342\002\n\016ServerMessages\"\317\002\n\004Type\022\006\n\002OK\020" +
      "\000\022\t\n\005ERROR\020\001\022\025\n\021CONN_CAPABILITIES\020\002\022\036\n\032S" +
      "ESS_AUTHENTICATE_CONTINUE\020\003\022\030\n\024SESS_AUTH" +
      "ENTICATE_OK\020\004\022\n\n\006NOTICE\020\013\022\036\n\032RESULTSET_C" +
      "OLUMN_META_DATA\020\014\022\021\n\rRESULTSET_ROW\020\r\022\030\n\024" +
      "RESULTSET_FETCH_DONE\020\016\022\035\n\031RESULTSET_FETC",
      "H_SUSPENDED\020\017\022(\n$RESULTSET_FETCH_DONE_MO" +
      "RE_RESULTSETS\020\020\022\027\n\023SQL_STMT_EXECUTE_OK\020\021" +
      "\022(\n$RESULTSET_FETCH_DONE_MORE_OUT_PARAMS" +
      "\020\022\"\021\n\002Ok\022\013\n\003msg\030\001 \001(\t\"\210\001\n\005Error\022/\n\010sever" +
      "ity\030\001 \001(\0162\026.Mysqlx.Error.Severity:\005ERROR" +
      "\022\014\n\004code\030\002 \002(\r\022\021\n\tsql_state\030\004 \002(\t\022\013\n\003msg" +
      "\030\003 \002(\t\" \n\010Severity\022\t\n\005ERROR\020\000\022\t\n\005FATAL\020\001" +
      "B\031\n\027com.mysql.cj.x.protobuf"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          com.mysql.cj.x.protobuf.MysqlxSql.getDescriptor(),
          com.mysql.cj.x.protobuf.MysqlxResultset.getDescriptor(),
          com.mysql.cj.x.protobuf.MysqlxCrud.getDescriptor(),
          com.mysql.cj.x.protobuf.MysqlxSession.getDescriptor(),
          com.mysql.cj.x.protobuf.MysqlxConnection.getDescriptor(),
          com.mysql.cj.x.protobuf.MysqlxExpect.getDescriptor(),
          com.mysql.cj.x.protobuf.MysqlxNotice.getDescriptor(),
        }, assigner);
    internal_static_Mysqlx_ClientMessages_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_Mysqlx_ClientMessages_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_ClientMessages_descriptor,
        new java.lang.String[] { });
    internal_static_Mysqlx_ServerMessages_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_Mysqlx_ServerMessages_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_ServerMessages_descriptor,
        new java.lang.String[] { });
    internal_static_Mysqlx_Ok_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_Mysqlx_Ok_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Ok_descriptor,
        new java.lang.String[] { "Msg", });
    internal_static_Mysqlx_Error_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_Mysqlx_Error_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Error_descriptor,
        new java.lang.String[] { "Severity", "Code", "SqlState", "Msg", });
    com.mysql.cj.x.protobuf.MysqlxSql.getDescriptor();
    com.mysql.cj.x.protobuf.MysqlxResultset.getDescriptor();
    com.mysql.cj.x.protobuf.MysqlxCrud.getDescriptor();
    com.mysql.cj.x.protobuf.MysqlxSession.getDescriptor();
    com.mysql.cj.x.protobuf.MysqlxConnection.getDescriptor();
    com.mysql.cj.x.protobuf.MysqlxExpect.getDescriptor();
    com.mysql.cj.x.protobuf.MysqlxNotice.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
