/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.rmi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.RemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import mx4j.adaptor.interceptor.AdaptorInterceptor;
import mx4j.adaptor.interceptor.Interceptor;
import mx4j.adaptor.interceptor.Invocation;
import mx4j.adaptor.interceptor.InvocationResult;
import mx4j.adaptor.rmi.RMIProtocolAdaptor;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.util.MethodTernaryTree;
import mx4j.util.Utils;

public class RMIProtocolAdaptorImpl
extends RemoteObject
implements RMIProtocolAdaptor {
    private MBeanServer m_server;
    private ObjectName m_name;
    private Interceptor m_headInterceptor;
    private String m_hostName;
    private String m_hostAddress;
    private ArrayList m_interceptorNames = new ArrayList();

    public RMIProtocolAdaptorImpl(MBeanServer server, ObjectName name, List interceptors) {
        this.m_server = server;
        this.m_name = name;
        if (interceptors == null || interceptors.size() == 0) {
            this.m_headInterceptor = new InvokerAdaptorInterceptor();
        } else {
            Logger logger = this.getLogger();
            if (logger.isEnabledFor(10)) {
                logger.debug("Interceptors are: " + interceptors);
            }
            int i = 1;
            while (i < interceptors.size()) {
                Interceptor previous = (Interceptor)interceptors.get(i - 1);
                Interceptor next = (Interceptor)interceptors.get(i);
                previous.setNext(next);
                this.registerInterceptor(previous);
                ++i;
            }
            Interceptor last = (Interceptor)interceptors.get(interceptors.size() - 1);
            last.setNext(new InvokerAdaptorInterceptor());
            this.registerInterceptor(last);
            this.m_headInterceptor = (Interceptor)interceptors.get(0);
        }
    }

    private void registerInterceptor(Interceptor interceptor) {
        block8: {
            if (this.m_name == null) {
                return;
            }
            Logger logger = this.getLogger();
            try {
                ObjectName interceptorObjectName = null;
                if (interceptor instanceof AdaptorInterceptor) {
                    AdaptorInterceptor i = (AdaptorInterceptor)interceptor;
                    interceptorObjectName = i.getObjectName();
                }
                if (interceptorObjectName == null) {
                    if (logger.isEnabledFor(10)) {
                        logger.debug("Adaptor ObjectName: " + this.m_name);
                    }
                    String domain = this.m_name.getDomain();
                    Hashtable<String, String> props = this.m_name.getKeyPropertyList();
                    props.put("interceptor", interceptor.getType());
                    interceptorObjectName = new ObjectName(domain, props);
                }
                if (logger.isEnabledFor(10)) {
                    logger.debug("Adaptor interceptor ObjectName: " + interceptorObjectName);
                }
                this.m_server.registerMBean(interceptor, interceptorObjectName);
                this.m_interceptorNames.add(interceptorObjectName);
                if (logger.isEnabledFor(0)) {
                    logger.trace("Adaptor interceptor registered successfully");
                }
            }
            catch (Exception x) {
                if (!logger.isEnabledFor(0)) break block8;
                logger.trace("Cannot register interceptor", x);
            }
        }
    }

    public void unregisterInterceptors() {
        Logger logger = this.getLogger();
        int i = 0;
        while (i < this.m_interceptorNames.size()) {
            block5: {
                ObjectName name = (ObjectName)this.m_interceptorNames.get(i);
                if (logger.isEnabledFor(10)) {
                    logger.debug("Unregistering adaptor interceptor with ObjectName: " + name);
                }
                try {
                    this.m_server.unregisterMBean(name);
                    if (logger.isEnabledFor(0)) {
                        logger.trace("Adaptor interceptor unregistered successfully");
                    }
                }
                catch (Exception x) {
                    if (!logger.isEnabledFor(0)) break block5;
                    logger.trace("Cannot unregister interceptor", x);
                }
            }
            ++i;
        }
    }

    public InvocationResult invoke(Invocation invocation) throws Exception {
        return this.m_headInterceptor.invoke(invocation);
    }

    public String getHostName() {
        if (this.m_hostName == null) {
            try {
                InetAddress host = InetAddress.getLocalHost();
                this.m_hostName = host.getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return this.m_hostName;
    }

    public String getHostAddress() {
        if (this.m_hostAddress == null) {
            try {
                InetAddress host = InetAddress.getLocalHost();
                this.m_hostAddress = host.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return this.m_hostAddress;
    }

    private Logger getLogger() {
        return Log.getLogger("mx4j.implementation." + this.getClass().getName());
    }

    public final class InvokerAdaptorInterceptor
    extends AdaptorInterceptor {
        private MethodTernaryTree m_methods = new MethodTernaryTree();
        static /* synthetic */ Class class$javax$management$MBeanServer;

        public InvokerAdaptorInterceptor() {
            RMIProtocolAdaptorImpl.this.registerInterceptor(this);
        }

        public String getType() {
            return "invoker";
        }

        public void setEnabled(boolean value) {
        }

        public boolean isEnabled() {
            return true;
        }

        protected InvocationResult doInvoke(Invocation invocation) throws Exception {
            Logger logger = this.getLogger();
            boolean debug = logger.isEnabledFor(10);
            if (debug) {
                logger.debug("Last interceptor, invoking MBeanServer");
            }
            String name = invocation.getMethodName();
            if (debug) {
                logger.debug("Method name is: " + name);
            }
            String[] signature = invocation.getSignature();
            Class[] params = Utils.loadClasses((ClassLoader)Thread.currentThread().getContextClassLoader(), (String[])signature);
            if (debug) {
                logger.debug("Signature is: " + Arrays.asList(signature));
            }
            Object[] args = invocation.getArguments();
            if (debug) {
                logger.debug("Arguments are: " + Arrays.asList(args));
            }
            try {
                Method m;
                Object result = null;
                if (this.isMBeanServerInvocation(name, params)) {
                    if (RMIProtocolAdaptorImpl.this.m_server == null) {
                        throw new IllegalStateException("Target MBeanServer is not set. Either call setMBeanServer or register this MBean");
                    }
                    m = this.getMBeanServerMethod(name, signature, params);
                    result = this.invokeMBeanServerMethod(m, args);
                } else {
                    m = RMIProtocolAdaptorImpl.this.getClass().getMethod(name, params);
                    result = m.invoke((Object)RMIProtocolAdaptorImpl.this, args);
                }
                InvocationResult invocationResult = new InvocationResult();
                invocationResult.setResult(result);
                return invocationResult;
            }
            catch (InvocationTargetException x) {
                Throwable t = x.getTargetException();
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw (Error)t;
            }
        }

        private Method getMBeanServerMethod(String name, String[] signature, Class[] params) throws NoSuchMethodException {
            MethodTernaryTree methodTernaryTree = this.m_methods;
            synchronized (methodTernaryTree) {
                Method m = (Method)this.m_methods.get(name, signature);
                if (m == null) {
                    try {
                        m = (class$javax$management$MBeanServer == null ? (class$javax$management$MBeanServer = InvokerAdaptorInterceptor.class$("javax.management.MBeanServer")) : class$javax$management$MBeanServer).getMethod(name, params);
                    }
                    catch (NoSuchMethodException x) {
                        if ("removeNotificationListener".equals(name)) {
                            Class[] newParams = new Class[]{params[0], params[1]};
                            m = (class$javax$management$MBeanServer == null ? (class$javax$management$MBeanServer = InvokerAdaptorInterceptor.class$("javax.management.MBeanServer")) : class$javax$management$MBeanServer).getMethod(name, newParams);
                        }
                        throw x;
                    }
                    this.m_methods.put(name, signature, (Object)m);
                }
                Method method = m;
                return method;
            }
        }

        private Object invokeMBeanServerMethod(Method method, Object[] params) throws Exception {
            if ("removeNotificationListener".equals(method.getName())) {
                Object[] newParams = new Object[]{params[0], params[1]};
                return method.invoke((Object)RMIProtocolAdaptorImpl.this.m_server, newParams);
            }
            return method.invoke((Object)RMIProtocolAdaptorImpl.this.m_server, params);
        }

        private boolean isMBeanServerInvocation(String name, Class[] params) {
            return !name.equals("getHostName") && !name.equals("getHostAddress");
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

