/*
 * Decompiled with CFR 0.152.
 */
package mx4j.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import mx4j.util.TimeTask;

public class TimeQueue {
    private Thread m_thread;
    private boolean m_started;
    private ArrayList m_tasks = new ArrayList();

    public void start() {
        if (!this.m_started) {
            this.m_thread = new Thread((Runnable)new Loop(), "MBean Timer Notification Thread");
            this.m_thread.setDaemon(true);
            this.m_thread.start();
            this.m_started = true;
        }
    }

    public void stop() {
        if (this.m_started) {
            this.m_thread.interrupt();
            try {
                this.m_thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.m_thread = null;
            this.m_started = false;
        }
    }

    public int size() {
        return this.m_tasks.size();
    }

    public void schedule(TimeTask task) {
        TimeQueue timeQueue = this;
        synchronized (timeQueue) {
            this.m_tasks.add(task);
            Collections.sort(this.m_tasks);
            this.notifyAll();
        }
    }

    public void unschedule(TimeTask task) {
        TimeQueue timeQueue = this;
        synchronized (timeQueue) {
            ((AbstractCollection)this.m_tasks).remove(task);
        }
    }

    public void clear() {
        TimeQueue timeQueue = this;
        synchronized (timeQueue) {
            this.m_tasks.clear();
        }
    }

    private TimeTask getTask() throws InterruptedException {
        TimeQueue timeQueue = this;
        synchronized (timeQueue) {
            TimeTask task;
            while (this.m_tasks.isEmpty()) {
                this.wait();
            }
            TimeTask timeTask = task = (TimeTask)this.m_tasks.get(0);
            return timeTask;
        }
    }

    private class Loop
    implements Runnable {
        private Loop() {
        }

        public void run() {
            while (!TimeQueue.this.m_thread.isInterrupted()) {
                try {
                    boolean runTask;
                    TimeTask task = TimeQueue.this.getTask();
                    long now = System.currentTimeMillis();
                    long executionTime = task.getNextExecutionTime();
                    long timeToWait = executionTime - now;
                    boolean bl = runTask = timeToWait <= 0L;
                    if (!runTask) {
                        TimeQueue lock;
                        TimeQueue timeQueue = lock = TimeQueue.this;
                        synchronized (timeQueue) {
                            lock.wait(timeToWait);
                            continue;
                        }
                    }
                    TimeQueue.this.unschedule(task);
                    if (task.isPeriodic()) {
                        task.setNextExecutionTime(executionTime + task.getPeriod());
                        TimeQueue.this.schedule(task);
                    } else {
                        task.setFinished(true);
                    }
                    try {
                        task.run();
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                }
                catch (InterruptedException x) {
                    break;
                }
            }
        }
    }
}

