/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server.interceptor;

import java.security.AccessControlException;
import java.security.Permission;
import java.security.ProtectionDomain;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ReflectionException;
import mx4j.server.MBeanMetaData;
import mx4j.server.MBeanPermission;
import mx4j.server.MBeanTrustPermission;
import mx4j.server.interceptor.DefaultMBeanServerInterceptor;

public class SecurityMBeanServerInterceptor
extends DefaultMBeanServerInterceptor {
    public String getType() {
        return "security";
    }

    public boolean isEnabled() {
        return true;
    }

    public void addNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) {
        this.checkPermission(new MBeanPermission(metadata.info.getClassName(), "addListener"));
        super.addNotificationListener(metadata, listener, filter, handback);
    }

    public void removeNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.checkPermission(new MBeanPermission(metadata.info.getClassName(), "removeListener"));
        super.removeNotificationListener(metadata, listener, filter, handback);
    }

    public void instantiate(MBeanMetaData metadata, String className, String[] params, Object[] args) throws ReflectionException, MBeanException {
        this.checkPermission(new MBeanPermission(className, "newMBean"));
        super.instantiate(metadata, className, params, args);
    }

    public MBeanInfo getMBeanInfo(MBeanMetaData metadata) {
        this.checkPermission(new MBeanPermission(metadata.info.getClassName(), "getMBeanInfo"));
        return super.getMBeanInfo(metadata);
    }

    public Object invoke(MBeanMetaData metadata, String method, String[] params, Object[] args) throws MBeanException, ReflectionException {
        StringBuffer b = new StringBuffer(metadata.info.getClassName()).append("#").append(method);
        this.checkPermission(new MBeanPermission(b.toString(), "invokeOperation"));
        return super.invoke(metadata, method, params, args);
    }

    public AttributeList getAttributes(MBeanMetaData metadata, String[] attributes) {
        this.checkPermission(new MBeanPermission(metadata.info.getClassName() + "#*", "getAttribute"));
        return super.getAttributes(metadata, attributes);
    }

    public AttributeList setAttributes(MBeanMetaData metadata, AttributeList attributes) {
        this.checkPermission(new MBeanPermission(metadata.info.getClassName() + "#*", "setAttribute"));
        return super.setAttributes(metadata, attributes);
    }

    public Object getAttribute(MBeanMetaData metadata, String attribute) throws MBeanException, AttributeNotFoundException, ReflectionException {
        StringBuffer b = new StringBuffer(metadata.info.getClassName()).append("#").append(attribute);
        this.checkPermission(new MBeanPermission(b.toString(), "getAttribute"));
        return super.getAttribute(metadata, attribute);
    }

    public void setAttribute(MBeanMetaData metadata, Attribute attribute) throws MBeanException, AttributeNotFoundException, InvalidAttributeValueException, ReflectionException {
        StringBuffer b = new StringBuffer(metadata.info.getClassName()).append("#").append(attribute.getName());
        this.checkPermission(new MBeanPermission(b.toString(), "setAttribute"));
        super.setAttribute(metadata, attribute);
    }

    public void registration(MBeanMetaData metadata, int operation) throws MBeanRegistrationException {
        switch (operation) {
            case 1: {
                this.checkPermission(new MBeanPermission(metadata.info.getClassName(), "registerMBean"));
                this.checkTrustRegistration(metadata.mbean.getClass().getProtectionDomain(), new MBeanTrustPermission("register"));
                break;
            }
            case 4: {
                this.checkPermission(new MBeanPermission(metadata.info.getClassName(), "unregisterMBean"));
                break;
            }
        }
        super.registration(metadata, operation);
    }

    private void checkPermission(Permission p) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(p);
        }
    }

    private void checkTrustRegistration(ProtectionDomain domain, Permission permission) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && !domain.implies(permission)) {
            throw new AccessControlException("Access denied: MBean class is not trusted for registration");
        }
    }
}

