/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import javax.management.relation.RoleStatus;

public class RoleUnresolved
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -48350262537070138L;
    private String roleName;
    private List roleValue;
    private int problemType;

    public RoleUnresolved(String roleName, List roleValues, int problemType) throws IllegalArgumentException {
        this.setRoleName(roleName);
        this.setRoleValue(roleValues);
        this.setProblemType(problemType);
    }

    public int getProblemType() {
        return this.problemType;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public List getRoleValue() {
        return this.roleValue == null ? null : new ArrayList(this.roleValue);
    }

    public void setRoleName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Role Name cannot be null");
        }
        this.roleName = name;
    }

    public void setRoleValue(List list) {
        if (list != null) {
            if (this.roleValue == null) {
                this.roleValue = new ArrayList();
            }
            this.roleValue.clear();
            this.roleValue.addAll(list);
        } else {
            this.roleValue = null;
        }
    }

    public void setProblemType(int type) {
        if (!RoleStatus.isRoleStatus(type)) {
            throw new IllegalArgumentException("Problem Type unknown");
        }
        this.problemType = type;
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        try {
            void ignored;
            RoleUnresolved tempRole = (RoleUnresolved)super.clone();
            tempRole.roleValue = this.getRoleValue();
            return ignored;
        }
        catch (CloneNotSupportedException ignored) {
            return null;
        }
    }

    public String toString() {
        StringBuffer roleBuff = new StringBuffer();
        roleBuff.append("Role Name: ").append(this.roleName);
        if (this.roleValue != null) {
            roleBuff.append("\nRole Values:");
            Iterator i = this.roleValue.iterator();
            while (i.hasNext()) {
                ObjectName objectName = (ObjectName)i.next();
                roleBuff.append(objectName);
                if (!i.hasNext()) continue;
                roleBuff.append(", ");
            }
        }
        roleBuff.append("\nProblem Type:");
        roleBuff.append(this.problemType);
        return roleBuff.toString();
    }
}

