(ns mx.interware.arp.web.rest-handle
  (:require [clojure.data.json :as json]
            [clojure.tools.logging :as log]
            [ring.util.response :refer [response]]
            [mx.interware.arp.util.date-util :as d]
            [mx.interware.arp.streams.common :as common]
            [mx.interware.arp.util.error-codes :as error-codes]))

(defn index-handler
  [request]
  (response "Hello there!"))

(defn item-handler
  [{:keys [route-params] :as request}]
  (response (str "Item id : " (:id route-params) ", name : " (:name route-params))))

(defn event-handler
  [sink request]
  (try
    (let [body  (slurp (:body request))
          _     (log/info "body : " body)
          event (try
                  (json/read-str body :key-fn keyword)
                  (catch Exception e
                    (log/warn "Cannot parse JSON value : " body)
                    {:error true :error-code error-codes/PARSE-ERROR :error-message (str "Cannot parse JSON value : " body)}))
          _     (log/info "event : " (pr-str event))]
      (sink event)
      (response {:success true :date (d/current-date)}))
    (catch Exception e
      (do
        (.printStackTrace e)
        (response {:success false :date (d/current-date)})))))



(defn state-handler
  [states {:keys [route-params] :as request}]
  (try
    (let [id-key (keyword (:id route-params))
          state  (id-key states)
          result (common/arp-state-as-map state)]
      (response result))
    (catch Exception e
      (do
        (log/warn "State not found for : " route-params ". Reason :" (.getMessage e))
        (.printStackTrace e)
        (response {:success false :date (d/current-date)})))))