/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.fontprovider;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Typeface;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import java.io.FileInputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import moe.shizuku.fontprovider.FontRequest;
import moe.shizuku.fontprovider.FontRequests;
import moe.shizuku.fontprovider.compat.FontFamilyCompat;
import moe.shizuku.fontprovider.compat.TypefaceCompat;
import moe.shizuku.fontprovider.font.BundledFontFamily;
import moe.shizuku.fontprovider.font.Font;
import moe.shizuku.fontprovider.font.FontFamily;

public class FontProviderClient {
    private static final String TAG = "FontProviderClient";
    private static final String PACKAGE = "moe.shizuku.fontprovider";
    private static final int MIN_VERSION = 91;
    private static Map<String, ByteBuffer> sBufferCache = new HashMap<String, ByteBuffer>();
    private final ContentResolver mResolver;
    private boolean mNextRequestReplaceFallbackFonts;

    public static int checkAvailability(Context context) {
        PackageInfo pi = null;
        try {
            pi = context.getPackageManager().getPackageInfo(PACKAGE, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        if (pi == null) {
            return 1;
        }
        if (!pi.applicationInfo.enabled) {
            return 2;
        }
        if (pi.versionCode < 91) {
            return 3;
        }
        return 0;
    }

    @Nullable
    public static FontProviderClient create(Context context) {
        if (FontProviderClient.checkAvailability(context) != 0) {
            return null;
        }
        context = context.getApplicationContext();
        sBufferCache.clear();
        return new FontProviderClient(context);
    }

    private static int resolveWeight(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return 400;
        }
        if (name.endsWith("-thin")) {
            return 100;
        }
        if (name.endsWith("-demilight")) {
            return 200;
        }
        if (name.endsWith("-light")) {
            return 300;
        }
        if (name.endsWith("-medium")) {
            return 500;
        }
        if (name.endsWith("-bold")) {
            return 700;
        }
        if (name.endsWith("-black")) {
            return 900;
        }
        return 400;
    }

    private FontProviderClient(Context context) {
        this.mResolver = context.getContentResolver();
    }

    public void setNextRequestReplaceFallbackFonts(boolean nextRequestReplaceFallbackFonts) {
        this.mNextRequestReplaceFallbackFonts = nextRequestReplaceFallbackFonts;
    }

    @Nullable
    public Typeface[] replace(@NonNull String fontName, String ... name) {
        return this.replace(FontRequests.DEFAULT_SANS_SERIF_FONTS, fontName, name);
    }

    @Nullable
    public Typeface[] replace(@NonNull FontRequest[] defaultFonts, @NonNull String fontName, String ... name) {
        int[] weight = new int[name.length];
        for (int i = 0; i < name.length; ++i) {
            weight[i] = FontProviderClient.resolveWeight(name[i]);
        }
        return this.replace(defaultFonts, fontName, name, weight);
    }

    @Nullable
    public Typeface[] replace(@NonNull FontRequest[] defaultFonts, @NonNull String fontName, @NonNull String[] name, @NonNull int[] weight) {
        if (name.length != weight.length) {
            throw new IllegalArgumentException("length of name and weight should be same");
        }
        Map<String, Typeface> systemFontMap = TypefaceCompat.getSystemFontMap();
        if (systemFontMap == null) {
            return null;
        }
        Typeface base = this.request(defaultFonts, fontName, weight);
        if (base == null) {
            return null;
        }
        Typeface[] typefaces = new Typeface[name.length];
        for (int i = 0; i < name.length; ++i) {
            typefaces[i] = weight[i] != 400 ? TypefaceCompat.createWeightAlias(base, weight[i]) : base;
            systemFontMap.put(name[i], typefaces[i]);
        }
        return typefaces;
    }

    @Nullable
    public Typeface request(@NonNull FontRequest[] defaultFonts, @NonNull String fontName, int ... weight) {
        return this.request(FontRequests.create(defaultFonts, fontName, weight));
    }

    @Nullable
    public Typeface request(@NonNull FontRequests fontRequests) {
        BundledFontFamily bundledFontFamily;
        long time = System.currentTimeMillis();
        try {
            bundledFontFamily = fontRequests.request(this.mResolver);
        }
        catch (Exception e) {
            return null;
        }
        Log.d((String)TAG, (String)("get info and load font costs " + (System.currentTimeMillis() - time) + "ms"));
        if (bundledFontFamily == null) {
            return null;
        }
        boolean ignoreDefault = fontRequests.ignoreDefault();
        FontFamily[] fontFamilies = bundledFontFamily.families;
        Object families = !ignoreDefault ? Array.newInstance(FontFamilyCompat.getFontFamilyClass(), fontFamilies.length + 1) : Array.newInstance(FontFamilyCompat.getFontFamilyClass(), fontFamilies.length);
        int i = 0;
        Object fallbackFonts = TypefaceCompat.getFallbackFontsArray();
        if (fallbackFonts == null || Array.getLength(fallbackFonts) == 0) {
            return null;
        }
        if (!ignoreDefault) {
            Array.set(families, i++, Array.get(fallbackFonts, 0));
        }
        for (FontFamily fontFamily : fontFamilies) {
            FontFamilyCompat fontFamilyCompat = new FontFamilyCompat(fontFamily.language, fontFamily.variant);
            if (fontFamilyCompat.getFontFamily() == null) {
                return null;
            }
            for (Font font : fontFamily.fonts) {
                try {
                    if (Build.VERSION.SDK_INT >= 24) {
                        ByteBuffer byteBuffer = sBufferCache.get(font.filename);
                        if (byteBuffer == null) {
                            ParcelFileDescriptor pfd = bundledFontFamily.fd.get(font.filename);
                            int size = (int)font.size;
                            if (pfd == null) {
                                Log.w((String)TAG, (String)"ParcelFileDescriptor is null");
                                return null;
                            }
                            FileInputStream is = new FileInputStream(pfd.getFileDescriptor());
                            FileChannel fileChannel = is.getChannel();
                            byteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                            sBufferCache.put(font.filename, byteBuffer);
                        }
                        if (fontFamilyCompat.addFont(byteBuffer, font.ttcIndex, font.weight, font.italic ? 1 : 0)) continue;
                        return null;
                    }
                    String path = font.path;
                    if (path == null) {
                        Log.w((String)TAG, (String)("Font " + font.filename + " not downloaded?"));
                        return null;
                    }
                    if (fontFamilyCompat.addFont(path, font.weight, font.italic ? 1 : 0)) continue;
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (!fontFamilyCompat.freeze()) {
                return null;
            }
            Array.set(families, i++, fontFamilyCompat.getFontFamily());
        }
        if (this.mNextRequestReplaceFallbackFonts) {
            int j;
            int systemLength = Array.getLength(fallbackFonts);
            int myLength = Array.getLength(families);
            Object newFallbackFonts = Array.newInstance(FontFamilyCompat.getFontFamilyClass(), systemLength + myLength);
            for (j = 0; j < myLength; ++j) {
                Array.set(newFallbackFonts, j, Array.get(families, j));
            }
            for (j = 0; j < systemLength; ++j) {
                Array.set(newFallbackFonts, j + myLength, Array.get(fallbackFonts, j));
            }
            TypefaceCompat.setFallbackFontsArray(newFallbackFonts);
            this.mNextRequestReplaceFallbackFonts = false;
        }
        return TypefaceCompat.createFromFamiliesWithDefault(families, -1, -1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FontProviderAvailability {
        public static final int OK = 0;
        public static final int NOT_INSTALLED = 1;
        public static final int DISABLED = 2;
        public static final int VERSION_TOO_LOW = 3;
    }
}

