/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.fontprovider;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetFileDescriptor;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import java.io.FileInputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moe.shizuku.fontprovider.FontProviderServiceConnection;
import moe.shizuku.fontprovider.FontRequest;
import moe.shizuku.fontprovider.FontRequests;
import moe.shizuku.fontprovider.IFontProvider;
import moe.shizuku.fontprovider.compat.FontFamilyCompat;
import moe.shizuku.fontprovider.compat.TypefaceCompat;
import moe.shizuku.fontprovider.font.Font;
import moe.shizuku.fontprovider.font.FontFamily;

public class FontProviderClient {
    private static final String TAG = "FontProviderClient";
    private static final String ACTION = "moe.shizuku.fontprovider.action.BIND";
    private static final String PACKAGE = "moe.shizuku.fontprovider";
    private static final int MIN_VERSION = 5;
    private static Map<String, ByteBuffer> sBufferCache = new HashMap<String, ByteBuffer>();
    private final Context mContext;
    private final ContentResolver mResolver;
    private final IFontProvider mFontProvider;
    private List<TextView> mTextViewCache = new ArrayList<TextView>();

    public static int checkAvailability(Context context) {
        PackageInfo pi = null;
        try {
            pi = context.getPackageManager().getPackageInfo(PACKAGE, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        if (pi == null) {
            return 1;
        }
        if (!pi.applicationInfo.enabled) {
            return 2;
        }
        if (pi.versionCode < 5) {
            return 3;
        }
        return 0;
    }

    public static void create(Activity activity, Callback callback) {
        FontProviderClient.create(activity, callback, new String[]{null});
    }

    public static void create(Activity activity, Callback callback, String ... names) {
        if (FontProviderClient.checkAvailability((Context)activity) != 0) {
            return;
        }
        Map<String, Typeface> typefaceMap = TypefaceCompat.getSystemFontMap();
        if (typefaceMap != null) {
            for (String name : names) {
                if (typefaceMap.containsKey(name)) continue;
                typefaceMap.put(name, TypefaceCompat.createWeightAlias(Typeface.SANS_SERIF, 400));
            }
        }
        sBufferCache.clear();
        FontProviderClient.bind((Context)activity, callback);
    }

    public static void create(Context context, Callback callback) {
        if (FontProviderClient.checkAvailability(context) != 0) {
            return;
        }
        sBufferCache.clear();
        FontProviderClient.bind(context, callback);
    }

    private static void bind(Context context, Callback callback) {
        Intent intent = new Intent(ACTION).setPackage(PACKAGE);
        try {
            FontProviderServiceConnection connection = new FontProviderServiceConnection(context, callback);
            context.getApplicationContext().bindService(intent, (ServiceConnection)connection, 1);
        }
        catch (Exception e) {
            Log.i((String)TAG, (String)"can't bindService", (Throwable)e);
        }
    }

    @Nullable
    public static FontProviderClient createSync(Context context) {
        if (FontProviderClient.checkAvailability(context) != 0) {
            return null;
        }
        context = context.getApplicationContext();
        sBufferCache.clear();
        return new FontProviderClient(context);
    }

    private FontProviderClient(Context context) {
        this.mContext = context;
        this.mResolver = context.getContentResolver();
        this.mFontProvider = null;
    }

    FontProviderClient(Context context, IFontProvider fontProvider) {
        this.mContext = context;
        this.mResolver = null;
        this.mFontProvider = fontProvider;
    }

    public Typeface replace(String name, String fontName) {
        return this.replace(name, FontRequests.create(name, fontName));
    }

    public Typeface replace(String name, String fontName, int ... weight) {
        return this.replace(name, FontRequests.create(name, fontName, weight));
    }

    public Typeface replace(String name, FontRequests fontRequests) {
        Typeface typeface = this.request(fontRequests);
        if (typeface != null && TypefaceCompat.getSystemFontMap() != null) {
            if (this.mContext instanceof Activity) {
                if (this.mTextViewCache.isEmpty()) {
                    Activity activity = (Activity)this.mContext;
                    View decor = activity.getWindow().getDecorView();
                    if (decor instanceof ViewGroup) {
                        this.replaceTypeface((ViewGroup)decor, name, typeface);
                    }
                } else {
                    this.replaceTypeface(name, typeface);
                }
            }
            TypefaceCompat.getSystemFontMap().put(name, typeface);
            return typeface;
        }
        return null;
    }

    public Typeface request(FontRequests fontRequests) {
        boolean ignoreDefault = true;
        FontFamily[] fontFamilies = new FontFamily[]{};
        for (FontRequest fontRequest : fontRequests.requests) {
            if (fontRequest.equals(FontRequest.DEFAULT)) {
                ignoreDefault = false;
                continue;
            }
            try {
                long time = System.currentTimeMillis();
                fontFamilies = this.mFontProvider != null ? FontFamily.combine(fontFamilies, fontRequest.loadFontFamily(this.mFontProvider)) : FontFamily.combine(fontFamilies, fontRequest.loadFontFamily(this.mResolver));
                Log.d((String)TAG, (String)("get info for " + fontRequest.name + " costs " + (System.currentTimeMillis() - time) + "ms"));
            }
            catch (RemoteException e) {
                e.printStackTrace();
                return null;
            }
        }
        Object families = !ignoreDefault ? Array.newInstance(FontFamilyCompat.getFontFamilyClass(), fontFamilies.length + 1) : Array.newInstance(FontFamilyCompat.getFontFamilyClass(), fontFamilies.length);
        int i = 0;
        Object fallbackFonts = TypefaceCompat.getFallbackFontsArray();
        if (fallbackFonts == null || Array.getLength(fallbackFonts) == 0) {
            return null;
        }
        if (!ignoreDefault) {
            Array.set(families, i++, Array.get(fallbackFonts, 0));
        }
        for (FontFamily fontFamily : fontFamilies) {
            FontFamilyCompat fontFamilyCompat = new FontFamilyCompat(fontFamily.language, fontFamily.variant);
            if (fontFamilyCompat.getFontFamily() == null) {
                return null;
            }
            for (Font font : fontFamily.fonts) {
                try {
                    if (Build.VERSION.SDK_INT >= 24) {
                        ByteBuffer byteBuffer;
                        ByteBuffer byteBuffer2 = byteBuffer = font.buffer != null ? font.buffer : sBufferCache.get(font.filename);
                        if (byteBuffer == null) {
                            long time = System.currentTimeMillis();
                            ParcelFileDescriptor pfd = null;
                            int size = (int)font.size;
                            if (this.mFontProvider != null) {
                                pfd = this.mFontProvider.getFontFileDescriptor(font.filename);
                            } else {
                                AssetFileDescriptor afd = this.mResolver.openAssetFileDescriptor(Uri.parse((String)("content://moe.shizuku.fontprovider/file/" + font.filename)), "r");
                                if (afd != null) {
                                    pfd = afd.getParcelFileDescriptor();
                                }
                            }
                            Log.d((String)TAG, (String)("open file " + font.filename + " costs " + (System.currentTimeMillis() - time) + "ms"));
                            if (pfd == null) {
                                Log.e((String)TAG, (String)"ParcelFileDescriptor is null");
                                return null;
                            }
                            FileInputStream is = new FileInputStream(pfd.getFileDescriptor());
                            FileChannel fileChannel = is.getChannel();
                            byteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                            sBufferCache.put(font.filename, byteBuffer);
                        }
                        if (fontFamilyCompat.addFont(byteBuffer, font.ttcIndex, font.weight, font.italic ? 1 : 0)) continue;
                        return null;
                    }
                    String path = font.path;
                    if (path == null) {
                        Log.e((String)TAG, (String)("Font " + font.filename + " not downloaded?"));
                        return null;
                    }
                    if (fontFamilyCompat.addFont(path, font.weight, font.italic ? 1 : 0)) continue;
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (!fontFamilyCompat.freeze()) {
                return null;
            }
            Array.set(families, i++, fontFamilyCompat.getFontFamily());
        }
        return TypefaceCompat.createFromFamiliesWithDefault(families, fontRequests.weight[0], -1);
    }

    private void replaceTypeface(String name, Typeface typeface) {
        for (TextView view : this.mTextViewCache) {
            this.replaceTypeface(view, name, typeface);
        }
    }

    private void replaceTypeface(ViewGroup parent, String name, Typeface typeface) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            View view = parent.getChildAt(i);
            if (view instanceof ViewGroup) {
                this.replaceTypeface((ViewGroup)view, name, typeface);
                continue;
            }
            if (!(view instanceof TextView)) continue;
            this.mTextViewCache.add((TextView)view);
            this.replaceTypeface((TextView)view, name, typeface);
        }
    }

    private void replaceTypeface(TextView view, String name, Typeface typeface) {
        Typeface[] typefaces = new Typeface[]{Typeface.create((String)name, (int)0), Typeface.create((String)name, (int)1), Typeface.create((String)name, (int)2), Typeface.create((String)name, (int)3)};
        for (Typeface t : typefaces) {
            if (!view.getTypeface().equals((Object)t)) continue;
            view.setTypeface(Typeface.create((Typeface)typeface, (int)t.getStyle()));
            break;
        }
    }

    public static interface Callback {
        public boolean onServiceConnected(FontProviderClient var1, ServiceConnection var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FontProviderAvailability {
        public static final int OK = 0;
        public static final int NOT_INSTALLED = 1;
        public static final int DISABLED = 2;
        public static final int VERSION_TOO_LOW = 3;
    }
}

