/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.fontprovider;

import android.text.TextUtils;
import java.util.Arrays;
import moe.shizuku.fontprovider.FontRequest;

public class FontRequests {
    private static FontRequest[] DEFAULT_SANS_SERIF_FONTS = new FontRequest[]{FontRequest.DEFAULT};
    private static FontRequest[] DEFAULT_SERIF_FONTS = new FontRequest[]{FontRequest.NOTO_SERIF};
    public final int[] weight;
    public final FontRequest[] requests;

    private static int[] resolveWeight(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return new int[]{400, 700};
        }
        if (name.endsWith("-thin")) {
            return new int[]{100};
        }
        if (name.endsWith("-demilight")) {
            return new int[]{200};
        }
        if (name.endsWith("-light")) {
            return new int[]{300};
        }
        if (name.endsWith("-medium")) {
            return new int[]{500};
        }
        if (name.endsWith("-bold")) {
            return new int[]{700};
        }
        if (name.endsWith("-black")) {
            return new int[]{900};
        }
        return new int[]{400, 700};
    }

    private static boolean resolveIsSerif(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        return name.startsWith("serif");
    }

    public static void setDefaultSansSerifFonts(FontRequest ... fonts) {
        DEFAULT_SANS_SERIF_FONTS = fonts;
    }

    public static void setDefaultSerifFonts(FontRequest ... fonts) {
        DEFAULT_SERIF_FONTS = fonts;
    }

    private static FontRequest[] getDefaultFont(String name) {
        return FontRequests.resolveIsSerif(name) ? DEFAULT_SERIF_FONTS : DEFAULT_SANS_SERIF_FONTS;
    }

    public static FontRequests create(String name, String fontName) {
        return FontRequests.create(FontRequests.getDefaultFont(name), fontName, FontRequests.resolveWeight(name));
    }

    public static FontRequests create(FontRequest[] defaultFonts, String name, int ... weight) {
        return new FontRequests(weight, FontRequest.combine(defaultFonts, {new FontRequest(name, weight)}));
    }

    public FontRequests(int weight, FontRequest ... requests) {
        this(new int[]{weight}, requests);
    }

    public FontRequests(int[] weight, FontRequest ... requests) {
        this.weight = weight;
        this.requests = requests;
    }

    public String toString() {
        return "FontRequests{weight=" + this.weight + ", requests=" + Arrays.toString(this.requests) + '}';
    }
}

