/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.fontprovider;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.util.Log;
import moe.shizuku.fontprovider.FontProviderClient;
import moe.shizuku.fontprovider.IFontProvider;

class FontProviderServiceConnection
implements ServiceConnection {
    private Context mContext;
    private FontProviderClient.Callback mCallback;

    FontProviderServiceConnection(Context context, FontProviderClient.Callback callback) {
        this.mContext = context;
        this.mCallback = callback;
    }

    public void onServiceConnected(ComponentName componentName, IBinder binder) {
        IFontProvider fontProvider = IFontProvider.Stub.asInterface(binder);
        FontProviderClient client = new FontProviderClient(this.mContext, fontProvider);
        if (this.mCallback.onServiceConnected(client, this)) {
            try {
                this.mContext.getApplicationContext().unbindService((ServiceConnection)this);
            }
            catch (Exception e) {
                Log.w((String)"FontProvider", (String)"failed to unbind service", (Throwable)e);
            }
        }
    }

    public void onServiceDisconnected(ComponentName componentName) {
    }
}

