/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.fontprovider;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.graphics.Typeface;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import java.io.FileInputStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import moe.shizuku.fontprovider.FontProviderServiceConnection;
import moe.shizuku.fontprovider.FontRequest;
import moe.shizuku.fontprovider.FontRequests;
import moe.shizuku.fontprovider.IFontProvider;
import moe.shizuku.fontprovider.compat.FontFamilyCompat;
import moe.shizuku.fontprovider.compat.TypefaceCompat;
import moe.shizuku.fontprovider.font.Font;
import moe.shizuku.fontprovider.font.FontFamily;

public class FontProviderClient {
    private static final String TAG = "FontProviderClient";
    private static final String ACTION = "moe.shizuku.fontprovider.action.BIND";
    private static final String PACKAGE = "moe.shizuku.fontprovider";
    private static Map<String, ByteBuffer> sBufferCache = new HashMap<String, ByteBuffer>();
    private IFontProvider mFontProvider;
    private ServiceConnection mServiceConnection;

    public static void create(Context context, Callback callback) {
        context = context.getApplicationContext();
        Intent intent = new Intent(ACTION).setPackage(PACKAGE);
        sBufferCache.clear();
        try {
            context.bindService(intent, (ServiceConnection)new FontProviderServiceConnection(context, callback), 1);
        }
        catch (Exception e) {
            Log.i((String)TAG, (String)"can't bindService", (Throwable)e);
        }
    }

    public FontProviderClient(ServiceConnection serviceConnection, IFontProvider fontProvider) {
        this.mServiceConnection = serviceConnection;
        this.mFontProvider = fontProvider;
    }

    public void unbindService(Context context) {
        try {
            context.getApplicationContext().unbindService(this.mServiceConnection);
        }
        catch (Exception e) {
            Log.i((String)TAG, (String)"can't unbindService", (Throwable)e);
        }
    }

    public IFontProvider getFontProvider() {
        return this.mFontProvider;
    }

    private static int[] resolveWeight(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return new int[]{400, 700};
        }
        if (name.endsWith("-thin")) {
            return new int[]{100};
        }
        if (name.endsWith("-demilight")) {
            return new int[]{200};
        }
        if (name.endsWith("-light")) {
            return new int[]{300};
        }
        if (name.endsWith("-medium")) {
            return new int[]{500};
        }
        if (name.endsWith("-bold")) {
            return new int[]{700};
        }
        if (name.endsWith("-black")) {
            return new int[]{900};
        }
        return new int[]{400, 700};
    }

    private static boolean resolveIsSerif(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        return name.startsWith("serif");
    }

    public Typeface replace(String name, String fontName) {
        return this.replace(name, fontName, FontProviderClient.resolveIsSerif(name) ? FontRequest.NOTO_SERIF : FontRequest.DEFAULT);
    }

    public Typeface replace(String name, String fontName, FontRequest defaultFont) {
        return this.replace(name, FontRequests.create(defaultFont, fontName, FontProviderClient.resolveWeight(name)));
    }

    public Typeface replace(String name, FontRequests fontRequests) {
        Typeface typeface = this.request(fontRequests);
        if (typeface != null && TypefaceCompat.getSystemFontMap() != null) {
            TypefaceCompat.getSystemFontMap().put(name, typeface);
            return typeface;
        }
        return null;
    }

    public Typeface request(FontRequests fontRequests) {
        boolean ignoreDefault = true;
        FontFamily[] fontFamilies = new FontFamily[]{};
        for (FontRequest fontRequest : fontRequests.requests) {
            if (fontRequest.equals(FontRequest.DEFAULT)) {
                ignoreDefault = false;
                continue;
            }
            try {
                fontFamilies = FontFamily.combine(fontFamilies, fontRequest.getFontFamily(this.mFontProvider));
            }
            catch (RemoteException e) {
                e.printStackTrace();
                return null;
            }
        }
        Object families = !ignoreDefault ? Array.newInstance(FontFamilyCompat.getFontFamilyClass(), fontFamilies.length + 1) : Array.newInstance(FontFamilyCompat.getFontFamilyClass(), fontFamilies.length);
        int i = 0;
        Object fallbackFonts = TypefaceCompat.getFallbackFontsArray();
        if (fallbackFonts == null || Array.getLength(fallbackFonts) == 0) {
            return null;
        }
        if (!ignoreDefault) {
            Array.set(families, i++, Array.get(fallbackFonts, 0));
        }
        for (FontFamily fontFamily : fontFamilies) {
            FontFamilyCompat fontFamilyCompat = new FontFamilyCompat(fontFamily.language, fontFamily.variant);
            if (fontFamilyCompat.getFontFamily() == null) {
                return null;
            }
            for (Font font : fontFamily.fonts) {
                try {
                    if (Build.VERSION.SDK_INT >= 24) {
                        ByteBuffer byteBuffer;
                        ByteBuffer byteBuffer2 = byteBuffer = font.buffer != null ? font.buffer : sBufferCache.get(font.filename);
                        if (byteBuffer == null) {
                            ParcelFileDescriptor pfd = this.mFontProvider.getFontFileDescriptor(font.filename);
                            if (pfd == null) {
                                Log.e((String)TAG, (String)"ParcelFileDescriptor is null");
                                return null;
                            }
                            int size = this.mFontProvider.getFontFileSize(font.filename);
                            FileInputStream is = new FileInputStream(pfd.getFileDescriptor());
                            FileChannel fileChannel = is.getChannel();
                            byteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                        }
                        if (fontFamilyCompat.addFont(byteBuffer, font.ttcIndex, font.weight, font.italic ? 1 : 0)) continue;
                        return null;
                    }
                    String path = this.mFontProvider.getFontFilePath(font.filename);
                    if (path == null) {
                        Log.e((String)TAG, (String)"Font not downloaded?");
                        return null;
                    }
                    if (fontFamilyCompat.addFont(path, font.weight, font.italic ? 1 : 0)) continue;
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (!fontFamilyCompat.freeze()) {
                return null;
            }
            Array.set(families, i++, fontFamilyCompat.getFontFamily());
        }
        return TypefaceCompat.createFromFamiliesWithDefault(families, fontRequests.weight[0], -1);
    }

    public static interface Callback {
        public boolean onServiceConnected(FontProviderClient var1);
    }
}

