/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.fontprovider.compat;

import android.annotation.SuppressLint;
import android.os.Build;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import moe.shizuku.fontprovider.compat.FontFamilyImpl;
import moe.shizuku.fontprovider.compat.FontFamilyImpl24;
import moe.shizuku.fontprovider.compat.FontFamilyImpl26;

@SuppressLint(value={"PrivateApi"})
public class FontFamilyCompat {
    private static Class<?> cls;
    private static FontFamilyImpl sImpl;
    private Object mFontFamily;

    public static Class<?> getFontFamilyClass() {
        return cls;
    }

    public static Class<?> getFontFamilyArrayClass() {
        return Array.newInstance(cls, 0).getClass();
    }

    private static FontFamilyImpl getImpl() {
        if (sImpl != null) {
            return sImpl;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            sImpl = new FontFamilyImpl26();
        } else if (Build.VERSION.SDK_INT >= 24) {
            sImpl = new FontFamilyImpl24();
        } else {
            throw new IllegalStateException("unsupported system version");
        }
        return sImpl;
    }

    public FontFamilyCompat(String lang, int variant) {
        this(FontFamilyCompat.getImpl().create(lang, variant));
    }

    private FontFamilyCompat(Object fontFamily) {
        this.mFontFamily = fontFamily;
    }

    public Object getFontFamily() {
        return this.mFontFamily;
    }

    public boolean addFont(ByteBuffer font, int ttcIndex, int weight, int italic) {
        return FontFamilyCompat.getImpl().addFont(this.getFontFamily(), font, ttcIndex, weight, italic);
    }

    public boolean freeze() {
        return FontFamilyCompat.getImpl().freeze(this.getFontFamily());
    }

    static {
        try {
            cls = Class.forName("android.graphics.FontFamily");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

