/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.fontprovider.compat;

import android.annotation.SuppressLint;
import android.graphics.Typeface;
import android.support.annotation.RequiresApi;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import moe.shizuku.fontprovider.compat.FontFamilyCompat;
import moe.shizuku.fontprovider.compat.TypefaceCompat;

@SuppressLint(value={"PrivateApi"})
@RequiresApi(api=24)
public class TypefaceCompatApi24
extends TypefaceCompat {
    private static boolean available = true;
    private static Method createFromFamiliesWithDefaultMethod;
    private static Method nativeCreateWeightAliasMethod;
    private static Constructor constructor;
    private static Field nativeInstanceField;

    public static Typeface createFromFamiliesWithDefault(Object families, int weight) {
        if (!available) {
            return null;
        }
        try {
            Typeface base = (Typeface)createFromFamiliesWithDefaultMethod.invoke(null, families);
            long native_instance = (Long)nativeCreateWeightAliasMethod.invoke(null, TypefaceCompatApi24.getNativeInstance(base), weight);
            return (Typeface)constructor.newInstance(native_instance);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static long getNativeInstance(Typeface typeface) throws IllegalAccessException {
        return (Long)nativeInstanceField.get(typeface);
    }

    static {
        try {
            createFromFamiliesWithDefaultMethod = Typeface.class.getDeclaredMethod("createFromFamiliesWithDefault", FontFamilyCompat.getFontFamilyArrayClass());
            createFromFamiliesWithDefaultMethod.setAccessible(true);
            constructor = Typeface.class.getDeclaredConstructor(Long.TYPE);
            constructor.setAccessible(true);
            nativeCreateWeightAliasMethod = Typeface.class.getDeclaredMethod("nativeCreateWeightAlias", Long.TYPE, Integer.TYPE);
            nativeCreateWeightAliasMethod.setAccessible(true);
            nativeInstanceField = Typeface.class.getDeclaredField("native_instance");
            nativeInstanceField.setAccessible(true);
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            e.printStackTrace();
            available = false;
        }
    }
}

