/*
 * Decompiled with CFR 0.152.
 */
package moe.kyokobot.koe.codec.udpqueue;

import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import moe.kyokobot.koe.MediaConnection;
import moe.kyokobot.koe.codec.AbstractFramePoller;
import moe.kyokobot.koe.codec.Codec;
import moe.kyokobot.koe.codec.OpusCodec;
import moe.kyokobot.koe.codec.udpqueue.QueueManagerPool;
import moe.kyokobot.koe.internal.handler.DiscordUDPConnection;
import moe.kyokobot.koe.media.IntReference;
import moe.kyokobot.koe.media.MediaFrameProvider;

public class UdpQueueOpusFramePoller
extends AbstractFramePoller {
    private final QueueManagerPool.UdpQueueWrapper manager;
    private final IntReference timestamp = new IntReference();
    private long lastFrame;

    public UdpQueueOpusFramePoller(QueueManagerPool.UdpQueueWrapper manager, MediaConnection connection) {
        super(connection);
        this.manager = manager;
    }

    public void start() {
        if (this.polling) {
            throw new IllegalStateException("Polling already started!");
        }
        this.polling = true;
        this.lastFrame = System.currentTimeMillis();
        this.eventLoop.execute(this::populateQueue);
    }

    public void stop() {
        if (this.polling) {
            this.polling = false;
        }
    }

    void populateQueue() {
        if (!this.polling || this.manager == null) {
            return;
        }
        int remaining = this.manager.getRemainingCapacity();
        DiscordUDPConnection handler = (DiscordUDPConnection)this.connection.getConnectionHandler();
        MediaFrameProvider sender = this.connection.getAudioSender();
        OpusCodec codec = OpusCodec.INSTANCE;
        for (int i = 0; i < remaining; ++i) {
            if (sender == null || handler == null || !sender.canSendFrame((Codec)codec)) continue;
            ByteBuf buf = this.allocator.buffer();
            int start = buf.writerIndex();
            sender.retrieve((Codec)codec, buf, this.timestamp);
            int len = buf.writerIndex() - start;
            ByteBuf packet = handler.createPacket((byte)120, this.timestamp.get(), buf, len, false);
            if (packet != null) {
                this.manager.queuePacket(packet.nioBuffer(), (InetSocketAddress)handler.getServerAddress());
                packet.release();
            }
            buf.release();
        }
        long frameDelay = 40L - (System.currentTimeMillis() - this.lastFrame);
        if (frameDelay > 0L) {
            this.eventLoop.schedule(this::loop, frameDelay, TimeUnit.MILLISECONDS);
        } else {
            this.loop();
        }
    }

    private void loop() {
        this.lastFrame = System.currentTimeMillis() < this.lastFrame + 60L ? (this.lastFrame += 40L) : System.currentTimeMillis();
        this.populateQueue();
    }
}

