/*
 * Decompiled with CFR 0.152.
 */
package moe.feng.common.stepperview.internal;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.FrameLayout;

public class ClipOvalFrameLayout
extends FrameLayout {
    private Path path = new Path();

    public ClipOvalFrameLayout(Context context) {
        super(context);
        this.init();
    }

    public ClipOvalFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ClipOvalFrameLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        if (!ClipOvalFrameLayout.isPreLollipop()) {
            this.setClipToOutline(true);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (ClipOvalFrameLayout.isPreLollipop()) {
            float halfWidth = (float)w / 2.0f;
            float halfHeight = (float)h / 2.0f;
            this.path.reset();
            this.path.addCircle(halfWidth, halfHeight, Math.min(halfWidth, halfHeight), Path.Direction.CW);
            this.path.close();
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        if (ClipOvalFrameLayout.isPreLollipop()) {
            int save = canvas.save();
            canvas.clipPath(this.path);
            super.dispatchDraw(canvas);
            canvas.restoreToCount(save);
        } else {
            super.dispatchDraw(canvas);
        }
    }

    private static boolean isPreLollipop() {
        return Build.VERSION.SDK_INT < 21;
    }
}

