/*
 * Decompiled with CFR 0.152.
 */
package mobi.carton.csr;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import java.util.ArrayList;

public class ContinuousSpeechRecognition
implements RecognitionListener {
    private OnTextListener mOnTextListener;
    private OnRmsListener mOnRmsListener;
    private SpeechRecognizer mSpeechRecognizer;
    private Intent mRecognizerIntent;
    private boolean continuousListening = false;

    public ContinuousSpeechRecognition(Context context) {
        this.mSpeechRecognizer = SpeechRecognizer.createSpeechRecognizer((Context)context);
        this.mSpeechRecognizer.setRecognitionListener((RecognitionListener)this);
        this.mRecognizerIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        this.mRecognizerIntent.putExtra("android.speech.extra.LANGUAGE_PREFERENCE", "en");
        this.mRecognizerIntent.putExtra("calling_package", context.getPackageName());
        this.mRecognizerIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "web_search");
        this.mRecognizerIntent.putExtra("android.speech.extra.MAX_RESULTS", 5);
    }

    public void start() {
        this.continuousListening = true;
        this.mSpeechRecognizer.startListening(this.mRecognizerIntent);
    }

    public void stop() {
        this.continuousListening = false;
        this.mSpeechRecognizer.stopListening();
    }

    public void destroy() {
        this.continuousListening = false;
        this.mSpeechRecognizer.destroy();
    }

    public void setOnTextListener(OnTextListener l) {
        this.mOnTextListener = l;
    }

    public void setOnRmsListener(OnRmsListener l) {
        this.mOnRmsListener = l;
    }

    public void onReadyForSpeech(Bundle params) {
    }

    public void onBeginningOfSpeech() {
    }

    public void onRmsChanged(float rmsdB) {
        if (this.mOnRmsListener != null) {
            this.mOnRmsListener.onRmsChanged(rmsdB);
        }
    }

    public void onBufferReceived(byte[] buffer) {
    }

    public void onEndOfSpeech() {
    }

    public void onError(int error) {
        if (this.mOnTextListener != null) {
            this.mOnTextListener.onError(error);
        }
        switch (error) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (!this.continuousListening) break;
                this.mSpeechRecognizer.destroy();
                this.mSpeechRecognizer.setRecognitionListener((RecognitionListener)this);
                this.mSpeechRecognizer.startListening(this.mRecognizerIntent);
                break;
            }
        }
    }

    public void onResults(Bundle results) {
        if (this.mOnTextListener != null) {
            ArrayList matchedText = results.getStringArrayList("results_recognition");
            this.mOnTextListener.onTextMatched(matchedText);
        }
        if (this.continuousListening) {
            this.mSpeechRecognizer.startListening(this.mRecognizerIntent);
        }
    }

    public void onPartialResults(Bundle partialResults) {
    }

    public void onEvent(int eventType, Bundle params) {
    }

    public static interface OnRmsListener {
        public void onRmsChanged(float var1);
    }

    public static interface OnTextListener {
        public void onTextMatched(ArrayList<String> var1);

        public void onError(int var1);
    }
}

