/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.wkb.util;

import java.util.List;
import mil.nga.wkb.geom.CircularString;
import mil.nga.wkb.geom.CompoundCurve;
import mil.nga.wkb.geom.Geometry;
import mil.nga.wkb.geom.GeometryCollection;
import mil.nga.wkb.geom.GeometryEnvelope;
import mil.nga.wkb.geom.GeometryType;
import mil.nga.wkb.geom.LineString;
import mil.nga.wkb.geom.MultiLineString;
import mil.nga.wkb.geom.MultiPoint;
import mil.nga.wkb.geom.MultiPolygon;
import mil.nga.wkb.geom.Point;
import mil.nga.wkb.geom.Polygon;
import mil.nga.wkb.geom.PolyhedralSurface;
import mil.nga.wkb.geom.TIN;
import mil.nga.wkb.geom.Triangle;

public class GeometryEnvelopeBuilder {
    public static GeometryEnvelope buildEnvelope(Geometry geometry) {
        GeometryEnvelope envelope = new GeometryEnvelope();
        envelope.setMinX(Double.MAX_VALUE);
        envelope.setMaxX(-1.7976931348623157E308);
        envelope.setMinY(Double.MAX_VALUE);
        envelope.setMaxY(-1.7976931348623157E308);
        GeometryEnvelopeBuilder.buildEnvelope(geometry, envelope);
        return envelope;
    }

    public static void buildEnvelope(Geometry geometry, GeometryEnvelope envelope) {
        GeometryType geometryType = geometry.getGeometryType();
        switch (geometryType) {
            case POINT: {
                GeometryEnvelopeBuilder.addPointMessage(envelope, (Point)geometry);
                break;
            }
            case LINESTRING: {
                GeometryEnvelopeBuilder.addLineStringMessage(envelope, (LineString)geometry);
                break;
            }
            case POLYGON: {
                GeometryEnvelopeBuilder.addPolygonMessage(envelope, (Polygon)geometry);
                break;
            }
            case MULTIPOINT: {
                GeometryEnvelopeBuilder.addMultiPointMessage(envelope, (MultiPoint)geometry);
                break;
            }
            case MULTILINESTRING: {
                GeometryEnvelopeBuilder.addMultiLineStringMessage(envelope, (MultiLineString)geometry);
                break;
            }
            case MULTIPOLYGON: {
                GeometryEnvelopeBuilder.addMultiPolygonMessage(envelope, (MultiPolygon)geometry);
                break;
            }
            case CIRCULARSTRING: {
                GeometryEnvelopeBuilder.addLineStringMessage(envelope, (CircularString)geometry);
                break;
            }
            case COMPOUNDCURVE: {
                GeometryEnvelopeBuilder.addCompoundCurveMessage(envelope, (CompoundCurve)geometry);
                break;
            }
            case POLYHEDRALSURFACE: {
                GeometryEnvelopeBuilder.addPolyhedralSurfaceMessage(envelope, (PolyhedralSurface)geometry);
                break;
            }
            case TIN: {
                GeometryEnvelopeBuilder.addPolyhedralSurfaceMessage(envelope, (TIN)geometry);
                break;
            }
            case TRIANGLE: {
                GeometryEnvelopeBuilder.addPolygonMessage(envelope, (Triangle)geometry);
                break;
            }
            case GEOMETRYCOLLECTION: {
                GeometryEnvelopeBuilder.updateHasZandM(envelope, geometry);
                GeometryCollection geomCollection = (GeometryCollection)geometry;
                List geometries = geomCollection.getGeometries();
                for (Geometry subGeometry : geometries) {
                    GeometryEnvelopeBuilder.buildEnvelope(subGeometry, envelope);
                }
                break;
            }
        }
    }

    private static void updateHasZandM(GeometryEnvelope envelope, Geometry geometry) {
        if (!envelope.hasZ() && geometry.hasZ()) {
            envelope.setHasZ(true);
        }
        if (!envelope.hasM() && geometry.hasM()) {
            envelope.setHasM(true);
        }
    }

    private static void addPointMessage(GeometryEnvelope envelope, Point point) {
        Double m;
        Double z;
        GeometryEnvelopeBuilder.updateHasZandM(envelope, point);
        double x = point.getX();
        double y = point.getY();
        if (x < envelope.getMinX()) {
            envelope.setMinX(x);
        }
        if (x > envelope.getMaxX()) {
            envelope.setMaxX(x);
        }
        if (y < envelope.getMinY()) {
            envelope.setMinY(y);
        }
        if (y > envelope.getMaxY()) {
            envelope.setMaxY(y);
        }
        if (point.hasZ() && (z = point.getZ()) != null) {
            if (envelope.getMinZ() == null || z < envelope.getMinZ()) {
                envelope.setMinZ(z);
            }
            if (envelope.getMaxZ() == null || z > envelope.getMaxZ()) {
                envelope.setMaxZ(z);
            }
        }
        if (point.hasM() && (m = point.getM()) != null) {
            if (envelope.getMinM() == null || m < envelope.getMinM()) {
                envelope.setMinM(m);
            }
            if (envelope.getMaxM() == null || m > envelope.getMaxM()) {
                envelope.setMaxM(m);
            }
        }
    }

    private static void addMultiPointMessage(GeometryEnvelope envelope, MultiPoint multiPoint) {
        GeometryEnvelopeBuilder.updateHasZandM(envelope, multiPoint);
        List<Point> points = multiPoint.getPoints();
        for (Point point : points) {
            GeometryEnvelopeBuilder.addPointMessage(envelope, point);
        }
    }

    private static void addLineStringMessage(GeometryEnvelope envelope, LineString lineString) {
        GeometryEnvelopeBuilder.updateHasZandM(envelope, lineString);
        for (Point point : lineString.getPoints()) {
            GeometryEnvelopeBuilder.addPointMessage(envelope, point);
        }
    }

    private static void addMultiLineStringMessage(GeometryEnvelope envelope, MultiLineString multiLineString) {
        GeometryEnvelopeBuilder.updateHasZandM(envelope, multiLineString);
        List<LineString> lineStrings = multiLineString.getLineStrings();
        for (LineString lineString : lineStrings) {
            GeometryEnvelopeBuilder.addLineStringMessage(envelope, lineString);
        }
    }

    private static void addPolygonMessage(GeometryEnvelope envelope, Polygon polygon) {
        GeometryEnvelopeBuilder.updateHasZandM(envelope, polygon);
        List rings = polygon.getRings();
        for (LineString ring : rings) {
            GeometryEnvelopeBuilder.addLineStringMessage(envelope, ring);
        }
    }

    private static void addMultiPolygonMessage(GeometryEnvelope envelope, MultiPolygon multiPolygon) {
        GeometryEnvelopeBuilder.updateHasZandM(envelope, multiPolygon);
        List<Polygon> polygons = multiPolygon.getPolygons();
        for (Polygon polygon : polygons) {
            GeometryEnvelopeBuilder.addPolygonMessage(envelope, polygon);
        }
    }

    private static void addCompoundCurveMessage(GeometryEnvelope envelope, CompoundCurve compoundCurve) {
        GeometryEnvelopeBuilder.updateHasZandM(envelope, compoundCurve);
        List<LineString> lineStrings = compoundCurve.getLineStrings();
        for (LineString lineString : lineStrings) {
            GeometryEnvelopeBuilder.addLineStringMessage(envelope, lineString);
        }
    }

    private static void addPolyhedralSurfaceMessage(GeometryEnvelope envelope, PolyhedralSurface polyhedralSurface) {
        GeometryEnvelopeBuilder.updateHasZandM(envelope, polyhedralSurface);
        List<Polygon> polygons = polyhedralSurface.getPolygons();
        for (Polygon polygon : polygons) {
            GeometryEnvelopeBuilder.addPolygonMessage(envelope, polygon);
        }
    }
}

