/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.tiff;

import mil.nga.tiff.util.TiffException;

public enum FieldType {
    BYTE(1),
    ASCII(1),
    SHORT(2),
    LONG(4),
    RATIONAL(8),
    SBYTE(1),
    UNDEFINED(1),
    SSHORT(2),
    SLONG(4),
    SRATIONAL(8),
    FLOAT(4),
    DOUBLE(8);

    private final int bytes;

    private FieldType(int bytes) {
        this.bytes = bytes;
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    public int getBytes() {
        return this.bytes;
    }

    public int getBits() {
        return this.bytes * 8;
    }

    public static FieldType getFieldType(int fieldType) {
        return FieldType.values()[fieldType - 1];
    }

    public static FieldType getFieldType(int sampleFormat, int bitsPerSample) {
        FieldType fieldType = null;
        block0 : switch (sampleFormat) {
            case 1: {
                switch (bitsPerSample) {
                    case 8: {
                        fieldType = BYTE;
                        break;
                    }
                    case 16: {
                        fieldType = SHORT;
                        break;
                    }
                    case 32: {
                        fieldType = LONG;
                    }
                }
                break;
            }
            case 2: {
                switch (bitsPerSample) {
                    case 8: {
                        fieldType = SBYTE;
                        break;
                    }
                    case 16: {
                        fieldType = SSHORT;
                        break;
                    }
                    case 32: {
                        fieldType = SLONG;
                    }
                }
                break;
            }
            case 3: {
                switch (bitsPerSample) {
                    case 32: {
                        fieldType = FLOAT;
                        break block0;
                    }
                    case 64: {
                        fieldType = DOUBLE;
                    }
                }
            }
        }
        if (fieldType == null) {
            throw new TiffException("Unsupported field type for sample format: " + sampleFormat + ", bits per sample: " + bitsPerSample);
        }
        return fieldType;
    }

    public static int getSampleFormat(FieldType fieldType) {
        int sampleFormat;
        switch (fieldType) {
            case BYTE: 
            case SHORT: 
            case LONG: {
                sampleFormat = 1;
                break;
            }
            case SBYTE: 
            case SSHORT: 
            case SLONG: {
                sampleFormat = 2;
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                sampleFormat = 3;
                break;
            }
            default: {
                throw new TiffException("Unsupported sample format for field type: " + fieldType);
            }
        }
        return sampleFormat;
    }
}

