/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.util.centroid;

import java.util.List;
import mil.nga.sf.CompoundCurve;
import mil.nga.sf.Curve;
import mil.nga.sf.CurvePolygon;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryCollection;
import mil.nga.sf.GeometryType;
import mil.nga.sf.LineString;
import mil.nga.sf.MultiPolygon;
import mil.nga.sf.Point;
import mil.nga.sf.Polygon;
import mil.nga.sf.PolyhedralSurface;
import mil.nga.sf.util.SFException;

public class CentroidSurface {
    private Point base;
    private double area = 0.0;
    private Point sum = new Point();

    public CentroidSurface() {
    }

    public CentroidSurface(Geometry geometry) {
        this.add(geometry);
    }

    public void add(Geometry geometry) {
        GeometryType geometryType = geometry.getGeometryType();
        switch (geometryType) {
            case POLYGON: 
            case TRIANGLE: {
                this.add((Polygon)geometry);
                break;
            }
            case MULTIPOLYGON: {
                MultiPolygon multiPolygon = (MultiPolygon)geometry;
                this.add(multiPolygon.getPolygons());
                break;
            }
            case CURVEPOLYGON: {
                CurvePolygon curvePolygon = (CurvePolygon)geometry;
                this.add(curvePolygon);
                break;
            }
            case POLYHEDRALSURFACE: 
            case TIN: {
                PolyhedralSurface polyhedralSurface = (PolyhedralSurface)geometry;
                this.add(polyhedralSurface.getPolygons());
                break;
            }
            case GEOMETRYCOLLECTION: 
            case MULTICURVE: 
            case MULTISURFACE: {
                GeometryCollection geomCollection = (GeometryCollection)geometry;
                List geometries = geomCollection.getGeometries();
                for (Geometry subGeometry : geometries) {
                    this.add(subGeometry);
                }
                break;
            }
            case POINT: 
            case MULTIPOINT: 
            case LINESTRING: 
            case CIRCULARSTRING: 
            case MULTILINESTRING: 
            case COMPOUNDCURVE: {
                break;
            }
            default: {
                throw new SFException("Unsupported " + this.getClass().getSimpleName() + " Geometry Type: " + (Object)((Object)geometryType));
            }
        }
    }

    private void add(List<Polygon> polygons) {
        for (Polygon polygon : polygons) {
            this.add(polygon);
        }
    }

    private void add(Polygon polygon) {
        List rings = polygon.getRings();
        this.add((LineString)rings.get(0));
        for (int i = 1; i < rings.size(); ++i) {
            this.addHole((LineString)rings.get(i));
        }
    }

    private void add(CurvePolygon<Curve> curvePolygon) {
        List<Curve> rings = curvePolygon.getRings();
        Curve curve = rings.get(0);
        GeometryType curveGeometryType = curve.getGeometryType();
        switch (curveGeometryType) {
            case COMPOUNDCURVE: {
                CompoundCurve compoundCurve = (CompoundCurve)curve;
                for (LineString lineString : compoundCurve.getLineStrings()) {
                    this.add(lineString);
                }
                break;
            }
            case LINESTRING: 
            case CIRCULARSTRING: {
                this.add((LineString)curve);
                break;
            }
            default: {
                throw new SFException("Unexpected Curve Type: " + (Object)((Object)curveGeometryType));
            }
        }
        block9: for (int i = 1; i < rings.size(); ++i) {
            Curve curveHole = rings.get(i);
            GeometryType curveHoleGeometryType = curveHole.getGeometryType();
            switch (curveHoleGeometryType) {
                case COMPOUNDCURVE: {
                    CompoundCurve compoundCurveHole = (CompoundCurve)curveHole;
                    for (LineString lineStringHole : compoundCurveHole.getLineStrings()) {
                        this.addHole(lineStringHole);
                    }
                    continue block9;
                }
                case LINESTRING: 
                case CIRCULARSTRING: {
                    this.addHole((LineString)curveHole);
                    continue block9;
                }
                default: {
                    throw new SFException("Unexpected Curve Type: " + (Object)((Object)curveHoleGeometryType));
                }
            }
        }
    }

    private void add(LineString lineString) {
        this.add(true, lineString);
    }

    private void addHole(LineString lineString) {
        this.add(false, lineString);
    }

    private void add(boolean positive, LineString lineString) {
        List<Point> points = lineString.getPoints();
        Point firstPoint = points.get(0);
        if (this.base == null) {
            this.base = firstPoint;
        }
        for (int i = 0; i < points.size() - 1; ++i) {
            Point point = points.get(i);
            Point nextPoint = points.get(i + 1);
            this.addTriangle(positive, this.base, point, nextPoint);
        }
        Point lastPoint = points.get(points.size() - 1);
        if (firstPoint.getX() != lastPoint.getX() || firstPoint.getY() != lastPoint.getY()) {
            this.addTriangle(positive, this.base, lastPoint, firstPoint);
        }
    }

    private void addTriangle(boolean positive, Point point1, Point point2, Point point3) {
        double sign = positive ? 1.0 : -1.0;
        Point triangleCenter3 = this.centroid3(point1, point2, point3);
        double area2 = CentroidSurface.area2(point1, point2, point3);
        this.sum.setX(this.sum.getX() + sign * area2 * triangleCenter3.getX());
        this.sum.setY(this.sum.getY() + sign * area2 * triangleCenter3.getY());
        this.area += sign * area2;
    }

    private Point centroid3(Point point1, Point point2, Point point3) {
        double x = point1.getX() + point2.getX() + point3.getX();
        double y = point1.getY() + point2.getY() + point3.getY();
        Point point = new Point(x, y);
        return point;
    }

    private static double area2(Point point1, Point point2, Point point3) {
        return (point2.getX() - point1.getX()) * (point3.getY() - point1.getY()) - (point3.getX() - point1.getX()) * (point2.getY() - point1.getY());
    }

    public Point getCentroid() {
        Point centroid = new Point(this.sum.getX() / 3.0 / this.area, this.sum.getY() / 3.0 / this.area);
        return centroid;
    }
}

