/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.util;

import java.util.List;
import mil.nga.sf.CircularString;
import mil.nga.sf.CompoundCurve;
import mil.nga.sf.Curve;
import mil.nga.sf.CurvePolygon;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryCollection;
import mil.nga.sf.GeometryEnvelope;
import mil.nga.sf.GeometryType;
import mil.nga.sf.LineString;
import mil.nga.sf.MultiLineString;
import mil.nga.sf.MultiPoint;
import mil.nga.sf.MultiPolygon;
import mil.nga.sf.Point;
import mil.nga.sf.Polygon;
import mil.nga.sf.PolyhedralSurface;
import mil.nga.sf.TIN;
import mil.nga.sf.Triangle;

public class GeometryEnvelopeBuilder {
    public static GeometryEnvelope buildEnvelope(Geometry geometry) {
        GeometryEnvelope envelope = new GeometryEnvelope();
        envelope.setMinX(Double.MAX_VALUE);
        envelope.setMaxX(-1.7976931348623157E308);
        envelope.setMinY(Double.MAX_VALUE);
        envelope.setMaxY(-1.7976931348623157E308);
        GeometryEnvelopeBuilder.buildEnvelope(geometry, envelope);
        return envelope;
    }

    public static void buildEnvelope(Geometry geometry, GeometryEnvelope envelope) {
        GeometryType geometryType = geometry.getGeometryType();
        switch (geometryType) {
            case POINT: {
                GeometryEnvelopeBuilder.addPoint(envelope, (Point)geometry);
                break;
            }
            case LINESTRING: {
                GeometryEnvelopeBuilder.addLineString(envelope, (LineString)geometry);
                break;
            }
            case POLYGON: {
                GeometryEnvelopeBuilder.addPolygon(envelope, (Polygon)geometry);
                break;
            }
            case MULTIPOINT: {
                GeometryEnvelopeBuilder.addMultiPoint(envelope, (MultiPoint)geometry);
                break;
            }
            case MULTILINESTRING: {
                GeometryEnvelopeBuilder.addMultiLineString(envelope, (MultiLineString)geometry);
                break;
            }
            case MULTIPOLYGON: {
                GeometryEnvelopeBuilder.addMultiPolygon(envelope, (MultiPolygon)geometry);
                break;
            }
            case CIRCULARSTRING: {
                GeometryEnvelopeBuilder.addLineString(envelope, (CircularString)geometry);
                break;
            }
            case COMPOUNDCURVE: {
                GeometryEnvelopeBuilder.addCompoundCurve(envelope, (CompoundCurve)geometry);
                break;
            }
            case CURVEPOLYGON: {
                CurvePolygon curvePolygon = (CurvePolygon)geometry;
                GeometryEnvelopeBuilder.addCurvePolygon(envelope, curvePolygon);
                break;
            }
            case POLYHEDRALSURFACE: {
                GeometryEnvelopeBuilder.addPolyhedralSurface(envelope, (PolyhedralSurface)geometry);
                break;
            }
            case TIN: {
                GeometryEnvelopeBuilder.addPolyhedralSurface(envelope, (TIN)geometry);
                break;
            }
            case TRIANGLE: {
                GeometryEnvelopeBuilder.addPolygon(envelope, (Triangle)geometry);
                break;
            }
            case GEOMETRYCOLLECTION: 
            case MULTICURVE: 
            case MULTISURFACE: {
                GeometryEnvelopeBuilder.updateHasZandM(envelope, geometry);
                GeometryCollection geomCollection = (GeometryCollection)geometry;
                List geometries = geomCollection.getGeometries();
                for (Geometry subGeometry : geometries) {
                    GeometryEnvelopeBuilder.buildEnvelope(subGeometry, envelope);
                }
                break;
            }
        }
    }

    private static void updateHasZandM(GeometryEnvelope envelope, Geometry geometry) {
        if (!envelope.hasZ() && geometry.hasZ()) {
            envelope.setHasZ(true);
        }
        if (!envelope.hasM() && geometry.hasM()) {
            envelope.setHasM(true);
        }
    }

    private static void addPoint(GeometryEnvelope envelope, Point point) {
        Double m;
        Double z;
        GeometryEnvelopeBuilder.updateHasZandM(envelope, point);
        double x = point.getX();
        double y = point.getY();
        if (x < envelope.getMinX()) {
            envelope.setMinX(x);
        }
        if (x > envelope.getMaxX()) {
            envelope.setMaxX(x);
        }
        if (y < envelope.getMinY()) {
            envelope.setMinY(y);
        }
        if (y > envelope.getMaxY()) {
            envelope.setMaxY(y);
        }
        if (point.hasZ() && (z = point.getZ()) != null) {
            if (envelope.getMinZ() == null || z < envelope.getMinZ()) {
                envelope.setMinZ(z);
            }
            if (envelope.getMaxZ() == null || z > envelope.getMaxZ()) {
                envelope.setMaxZ(z);
            }
        }
        if (point.hasM() && (m = point.getM()) != null) {
            if (envelope.getMinM() == null || m < envelope.getMinM()) {
                envelope.setMinM(m);
            }
            if (envelope.getMaxM() == null || m > envelope.getMaxM()) {
                envelope.setMaxM(m);
            }
        }
    }

    private static void addMultiPoint(GeometryEnvelope envelope, MultiPoint multiPoint) {
        GeometryEnvelopeBuilder.updateHasZandM(envelope, multiPoint);
        List<Point> points = multiPoint.getPoints();
        for (Point point : points) {
            GeometryEnvelopeBuilder.addPoint(envelope, point);
        }
    }

    private static void addLineString(GeometryEnvelope envelope, LineString lineString) {
        GeometryEnvelopeBuilder.updateHasZandM(envelope, lineString);
        for (Point point : lineString.getPoints()) {
            GeometryEnvelopeBuilder.addPoint(envelope, point);
        }
    }

    private static void addMultiLineString(GeometryEnvelope envelope, MultiLineString multiLineString) {
        GeometryEnvelopeBuilder.updateHasZandM(envelope, multiLineString);
        List<LineString> lineStrings = multiLineString.getLineStrings();
        for (LineString lineString : lineStrings) {
            GeometryEnvelopeBuilder.addLineString(envelope, lineString);
        }
    }

    private static void addPolygon(GeometryEnvelope envelope, Polygon polygon) {
        GeometryEnvelopeBuilder.updateHasZandM(envelope, polygon);
        List rings = polygon.getRings();
        for (LineString ring : rings) {
            GeometryEnvelopeBuilder.addLineString(envelope, ring);
        }
    }

    private static void addMultiPolygon(GeometryEnvelope envelope, MultiPolygon multiPolygon) {
        GeometryEnvelopeBuilder.updateHasZandM(envelope, multiPolygon);
        List<Polygon> polygons = multiPolygon.getPolygons();
        for (Polygon polygon : polygons) {
            GeometryEnvelopeBuilder.addPolygon(envelope, polygon);
        }
    }

    private static void addCompoundCurve(GeometryEnvelope envelope, CompoundCurve compoundCurve) {
        GeometryEnvelopeBuilder.updateHasZandM(envelope, compoundCurve);
        List<LineString> lineStrings = compoundCurve.getLineStrings();
        for (LineString lineString : lineStrings) {
            GeometryEnvelopeBuilder.addLineString(envelope, lineString);
        }
    }

    private static void addCurvePolygon(GeometryEnvelope envelope, CurvePolygon<Curve> curvePolygon) {
        GeometryEnvelopeBuilder.updateHasZandM(envelope, curvePolygon);
        List<Curve> rings = curvePolygon.getRings();
        for (Curve ring : rings) {
            GeometryEnvelopeBuilder.buildEnvelope(ring, envelope);
        }
    }

    private static void addPolyhedralSurface(GeometryEnvelope envelope, PolyhedralSurface polyhedralSurface) {
        GeometryEnvelopeBuilder.updateHasZandM(envelope, polyhedralSurface);
        List<Polygon> polygons = polyhedralSurface.getPolygons();
        for (Polygon polygon : polygons) {
            GeometryEnvelopeBuilder.addPolygon(envelope, polygon);
        }
    }
}

