/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.operation;

import java.util.ArrayList;
import java.util.List;
import mil.nga.crs.CRSType;
import mil.nga.crs.CoordinateReferenceSystem;
import mil.nga.crs.operation.CommonOperation;
import mil.nga.crs.operation.Operation;

public class ConcatenatedOperation
extends Operation {
    private CoordinateReferenceSystem target = null;
    private List<CommonOperation> operations = new ArrayList<CommonOperation>();

    public ConcatenatedOperation() {
        super(CRSType.CONCATENATED_OPERATION);
    }

    public ConcatenatedOperation(String name, CoordinateReferenceSystem source, CoordinateReferenceSystem target) {
        super(name, CRSType.CONCATENATED_OPERATION, source);
        this.setTarget(target);
    }

    public CoordinateReferenceSystem getTarget() {
        return this.target;
    }

    public void setTarget(CoordinateReferenceSystem target) {
        this.target = target;
    }

    public List<CommonOperation> getOperations() {
        return this.operations;
    }

    public int numOperations() {
        return this.operations != null ? this.operations.size() : 0;
    }

    public CommonOperation getOperation(int index) {
        return this.operations.get(index);
    }

    public void setOperations(List<CommonOperation> operations) {
        this.operations = operations;
    }

    public void addOperation(CommonOperation operation) {
        this.operations.add(operation);
    }

    public void addOperations(List<CommonOperation> operations) {
        this.operations.addAll(operations);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.operations == null ? 0 : this.operations.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConcatenatedOperation other = (ConcatenatedOperation)obj;
        if (this.operations == null ? other.operations != null : !this.operations.equals(other.operations)) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }
}

