/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.common;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import mil.nga.crs.common.DatumEnsembleMember;
import mil.nga.crs.common.Identifiable;
import mil.nga.crs.common.Identifier;
import mil.nga.crs.wkt.CRSWriter;

public abstract class DatumEnsemble
implements Identifiable {
    private static final Logger logger = Logger.getLogger(DatumEnsemble.class.getName());
    private String name = null;
    private List<DatumEnsembleMember> members = new ArrayList<DatumEnsembleMember>();
    private double accuracy;
    private String accuracyText;
    private List<Identifier> identifiers = null;

    public DatumEnsemble() {
    }

    public DatumEnsemble(String name, DatumEnsembleMember member, double accuracy) {
        this.setName(name);
        this.addMember(member);
        this.setAccuracy(accuracy);
    }

    public DatumEnsemble(String name, DatumEnsembleMember member, String accuracy) {
        this.setName(name);
        this.addMember(member);
        this.setAccuracy(accuracy);
    }

    public DatumEnsemble(String name, List<DatumEnsembleMember> members, double accuracy) {
        this.setName(name);
        this.addMembers(members);
        this.setAccuracy(accuracy);
    }

    public DatumEnsemble(String name, List<DatumEnsembleMember> members, String accuracy) {
        this.setName(name);
        this.addMembers(members);
        this.setAccuracy(accuracy);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<DatumEnsembleMember> getMembers() {
        return this.members;
    }

    public int numMembers() {
        return this.members.size();
    }

    public DatumEnsembleMember getMember(int index) {
        return this.members.get(index);
    }

    public void setMembers(List<DatumEnsembleMember> members) {
        this.members = members;
    }

    public void addMember(DatumEnsembleMember member) {
        this.members.add(member);
    }

    public void addMembers(List<DatumEnsembleMember> members) {
        this.members.addAll(members);
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public String getAccuracyText() {
        return this.accuracyText;
    }

    public void setAccuracy(double accuracy) {
        this.accuracy = accuracy;
        this.accuracyText = String.valueOf(accuracy);
    }

    public void setAccuracy(String accuracy) {
        this.accuracyText = accuracy;
        this.accuracy = Double.parseDouble(accuracy);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public boolean hasIdentifiers() {
        return this.identifiers != null && !this.identifiers.isEmpty();
    }

    @Override
    public int numIdentifiers() {
        return this.identifiers != null ? this.identifiers.size() : 0;
    }

    @Override
    public Identifier getIdentifier(int index) {
        return this.identifiers.get(index);
    }

    @Override
    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    public void addIdentifier(Identifier identifier) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.add(identifier);
    }

    @Override
    public void addIdentifiers(List<Identifier> identifiers) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.addAll(identifiers);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.accuracy);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.identifiers == null ? 0 : this.identifiers.hashCode());
        result = 31 * result + (this.members == null ? 0 : this.members.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatumEnsemble other = (DatumEnsemble)obj;
        if (Double.doubleToLongBits(this.accuracy) != Double.doubleToLongBits(other.accuracy)) {
            return false;
        }
        if (this.identifiers == null ? other.identifiers != null : !this.identifiers.equals(other.identifiers)) {
            return false;
        }
        if (this.members == null ? other.members != null : !this.members.equals(other.members)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String value = null;
        try (CRSWriter writer = new CRSWriter();){
            writer.write(this);
            value = writer.toString();
        }
        return value;
    }
}

