/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import mil.nga.crs.common.Axis;
import mil.nga.crs.common.CoordinateSystemType;
import mil.nga.crs.common.Identifiable;
import mil.nga.crs.common.Identifier;
import mil.nga.crs.common.Unit;
import mil.nga.crs.wkt.CRSWriter;

public class CoordinateSystem
implements Identifiable {
    private static final Logger logger = Logger.getLogger(CoordinateSystem.class.getName());
    private CoordinateSystemType type = null;
    private int dimension;
    private List<Identifier> identifiers = null;
    private List<Axis> axes = new ArrayList<Axis>();
    private Unit unit = null;

    public CoordinateSystem() {
    }

    public CoordinateSystem(CoordinateSystemType type, int dimension, Axis axis) {
        this.setType(type);
        this.setDimension(dimension);
        this.addAxis(axis);
    }

    public CoordinateSystem(CoordinateSystemType type, int dimension, List<Axis> axes) {
        this.setType(type);
        this.setDimension(dimension);
        this.addAxes(axes);
    }

    public CoordinateSystemType getType() {
        return this.type;
    }

    public void setType(CoordinateSystemType type) {
        this.type = type;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public boolean hasIdentifiers() {
        return this.identifiers != null && !this.identifiers.isEmpty();
    }

    @Override
    public int numIdentifiers() {
        return this.identifiers != null ? this.identifiers.size() : 0;
    }

    @Override
    public Identifier getIdentifier(int index) {
        return this.identifiers.get(index);
    }

    @Override
    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    public void addIdentifier(Identifier identifier) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.add(identifier);
    }

    @Override
    public void addIdentifiers(List<Identifier> identifiers) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.addAll(identifiers);
    }

    public List<Axis> getAxes() {
        return this.axes;
    }

    public int numAxes() {
        return this.axes.size();
    }

    public Axis getAxis(int index) {
        return this.axes.get(index);
    }

    public void setAxes(List<Axis> axes) {
        this.axes = axes;
    }

    public void addAxis(Axis axis) {
        this.axes.add(axis);
    }

    public void addAxes(List<Axis> axes) {
        this.axes.addAll(axes);
    }

    public Unit getUnit() {
        return this.unit;
    }

    public boolean hasUnit() {
        return this.getUnit() != null;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public Unit getAxisUnit() {
        Unit axisUnit;
        block1: {
            Axis axis;
            axisUnit = this.getUnit();
            if (axisUnit != null) break block1;
            Iterator<Axis> iterator = this.axes.iterator();
            while (iterator.hasNext() && (axisUnit = (axis = iterator.next()).getUnit()) == null) {
            }
        }
        return axisUnit;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.axes == null ? 0 : this.axes.hashCode());
        result = 31 * result + this.dimension;
        result = 31 * result + (this.identifiers == null ? 0 : this.identifiers.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoordinateSystem other = (CoordinateSystem)obj;
        if (this.axes == null ? other.axes != null : !this.axes.equals(other.axes)) {
            return false;
        }
        if (this.dimension != other.dimension) {
            return false;
        }
        if (this.identifiers == null ? other.identifiers != null : !this.identifiers.equals(other.identifiers)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.unit == null ? other.unit != null : !this.unit.equals(other.unit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String value = null;
        try (CRSWriter writer = new CRSWriter();){
            writer.write(this);
            value = writer.toString();
        }
        return value;
    }
}

