/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.crs.CRSType;
import mil.nga.crs.CategoryType;
import mil.nga.crs.common.ScopeExtentIdentifierRemark;
import mil.nga.crs.wkt.CRSWriter;

public abstract class CRS
implements ScopeExtentIdentifierRemark {
    private static final Logger logger = Logger.getLogger(CRS.class.getName());
    private CRSType type = null;
    private Map<String, Object> extras = null;

    public CRS() {
    }

    public CRS(CRSType type) {
        this.setType(type);
    }

    public CRSType getType() {
        return this.type;
    }

    public void setType(CRSType type) {
        this.type = type;
    }

    public CategoryType getCategoryType() {
        CategoryType categoryType = null;
        if (this.type != null) {
            categoryType = this.type.getCategoryType();
        }
        return categoryType;
    }

    public Map<String, Object> getExtras() {
        return this.extras;
    }

    public boolean hasExtras() {
        return this.extras != null && !this.extras.isEmpty();
    }

    public int numExtras() {
        return this.extras != null ? this.extras.size() : 0;
    }

    public Object getExtra(String name) {
        Object extra = null;
        if (this.hasExtras()) {
            extra = this.extras.get(name);
        }
        return extra;
    }

    public void setExtras(Map<String, Object> extras) {
        this.extras = extras;
    }

    public void addExtra(String name, Object extra) {
        if (this.extras == null) {
            this.extras = new LinkedHashMap<String, Object>();
        }
        this.extras.put(name, extra);
    }

    public void addExtras(Map<String, Object> extras) {
        if (this.extras == null) {
            this.extras = new LinkedHashMap<String, Object>();
        }
        this.extras.putAll(extras);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CRS other = (CRS)obj;
        return this.type == other.type;
    }

    public String toString() {
        String value = null;
        try {
            value = CRSWriter.write(this);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to write CRS WKT, type: " + this.type, e);
            value = super.toString();
        }
        return value;
    }
}

