(ns oz.jupyter
  (:require [oz.core]
            [clojure.string :as string]
            [clojure.tools.reader :as reader]
            [clojure.tools.reader.reader-types :as rt]
            [clojure.java.io :as io]))


  
(meta (reader/read-string (slurp "test.clj")))
(reader/read (rt/string-push-back-reader (slurp "test.clj")))

(meta
  (reader/read (rt/string-push-back-reader 
                          "\n[1,2,3\n4 5]")))


(meta (reader/read (clojure.lang.LineNumberingPushbackReader. (io/reader (io/file "test.clj")))))
(meta (reader/read (clojure.lang.LineNumberingPushbackReader. (io/reader (io/file "test.clj")))))

(meta (reader/read-string "\n[1,2,3\n4 5]"))

(meta (reader/read (rt/string-push-back-reader (slurp "test.clj"))))
(meta (reader/read (rt/indexing-push-back-reader (slurp "test.clj") 1 "blah.clj")))

(-> (slurp "test.clj")
    ;(rt/string-push-back-reader)
    ;(rt/indexing-push-back-reader 1 "blach.clj")
    (rt/indexing-push-back-reader)
    reader/read
    meta)

(meta (reader/read (rt/string-push-back-reader (slurp "test.clj"))))
(meta (reader/read (rt/indexing-push-back-reader (slurp "test.clj") 1 "blah.clj")))


(def md-comment-regex
  #"^;; ?(.*)")

(re-matches md-comment-regex ";; blah")
(re-matches md-comment-regex ";;   blah")
(re-matches md-comment-regex ";;blah")
(re-matches md-comment-regex ";;")

;(defn- merge-lines
  ;[previous next]
  ;(-> previous
      ;(assoc :end-line (:end-line next)
             ;:end-column (:end-column next))
      ;(update :body str "\n" (:body next))))

;(defn- close-previous [{:as iter :keys [previous]}]
  ;(if previous
    ;(-> iter
       ;(dissoc :previous)
       ;(update :results conj previous))
    ;iter))

;(defn md-comments
  ;[code-string]
  ;(->> code-string
       ;(string/split-lines)
       ;(map (fn [i line]
              ;(when-let [md-line (second (re-matches md-comment-regex line))]
                ;{:line (inc i)
                 ;:column 1
                 ;:end-line (inc i)
                 ;:end-column (inc (count line))
                 ;:body md-line}))
            ;(range))
       ;(reduce (fn [{:as iter :keys [previous]} next]
                 ;(cond
                   ;;; if both previous and next lines are md comments, merge
                   ;(and previous next)
                   ;(update iter :previous merge-lines next)
                   ;;; if only the previous line is an md comment, close and add to results
                   ;previous
                   ;(close-previous iter)
                   ;;; if only the next line is an md comment, set as previous for next iter
                   ;next
                   ;(assoc iter :previous next)
                   ;;; otherwise, just return iter unchanged
                   ;:else iter))
               ;{:results []})
       ;close-previous
       ;:results))

;(md-comments (slurp "test.clj"))

(defn code-forms [code-string filename]
  (let [lines (string/split-lines code-string)
        line-count (count lines)
        reader (-> code-string
                   (rt/indexing-push-back-reader 1 filename))]
    (loop [forms []]
      (let [form (try (reader/read reader)
                   (catch Exception e (ex-data e)))]
        (if (= :reader-exception (:type form))
          ;; if we have an exception, check to make sure we're not just at a natural termination of file
          (if (and (= :eof (:ex-kind form))
                   (or (< line-count (:line form))
                       (and (= line-count (:line form))
                            (> (:col form) (count (last lines))))))
            forms
            ;; if it's a real exception, stop processing but include the exception as final form
            (conj forms form))
          ;; otherwise, add to forms, and continue processing
          (recur (conj forms form)))))))

(code-forms "(code stuff)" "test.clj")
(count "(code stuff)")

(let [reader (-> ""
                 (rt/indexing-push-back-reader 1 "test.clj"))]
  (try (reader/read reader)
       (catch Exception e (ex-data e))))

(let [reader (-> (slurp "test.clj")
                 (rt/indexing-push-back-reader 1 "test.clj"))]
  (reader/read reader)
  (reader/read reader)
  (reader/read reader)
  (reader/read reader)
  (try (reader/read reader)
       (catch Exception e (ex-data e))))

;(defn ingest-code
  ;[code-string filename]
  ;(->> (concat (md-comments code-string)
               ;(code-forms code-string filename))
       ;(sort-by (fn [{:keys [line column]}]))))

#inst "2018-09-08"

(code-forms (slurp "test.clj") "filename.clj")


;^:stuff
;:this
;; pickup; how do you solve sort-by when you have forms that can't have metadata attached?
;; how do you deal with ;;;? in regex?
    

(let [reader (-> "(this (that more))"
                 (rt/indexing-push-back-reader 1 "test.clj"))]
  (meta (first (reader/read reader))))

;(let [reader (-> "(this (that more))"
                 ;;(rt/push-back-reader)
                 ;(rt/string-reader)
                 ;;(rt/source-logging-reader?)
                 ;(rt/indexing-push-back-reader 1 "test.clj"))]
  ;;(reader/read reader))
  ;;(.read reader)
  ;(map :name (:members (clojure.reflect/reflect reader)))
  ;(:members (clojure.reflect/reflect reader))
  ;(.get_line_number reader)
  ;(.unread reader))
  ;;(.-line reader))

(defn- merge-lines
  [previous next]
  (-> previous
      (assoc :end-line (:end-line next)
             :end-column (:end-column next))
      (update :body str "\n" (:body next))))

(defn- close-previous [{:as iter :keys [previous]} next]
  (-> iter
     (dissoc :previous)
     (update :results conj previous)
     (assoc :previous next)))

(defn- line-type-match? [previous next]
  (= (:src-type previous) (:src-type next)))

(defn ingest-code
  [code-string filename]
  (-> (string/split-lines code-string)
    (->> (map (fn [i line]
                (merge
                  {:line (inc i)
                   :column 1
                   :end-line (inc i)
                   :end-column (inc (count line))}
                  (if-let [md-line (second (re-matches md-comment-regex line))]
                    {:src-type :md-line
                     :body md-line}
                    {:src-type :code
                     :body line})))
              (range))
         (reduce (fn [{:as iter :keys [previous]} next]
                   (cond
                     ;; if the line types match, merge them
                     (line-type-match? previous next)
                     (update iter :previous merge-lines next)
                     ;; if no previous line, just set next as previous for next iter
                     (not previous)
                     (assoc iter :previous next)
                     ;; otherwise, close previous
                     :else (close-previous iter next)))
                 {:results []}))
         ; make sure to close previous at the end, no matter what
    (close-previous nil)
    :results
    (->> (map (fn [{:as block :keys [src-type body]}]
                (if (= :code src-type)
                  (assoc block :forms (code-forms body filename))
                  block))))))

(ingest-code (slurp "test.clj") "test.clj")


