package melo.android.mvvm

import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.lifecycle.ViewModelProviders
import melo.android.mvvm.dagger.ViewModelFactory
import javax.inject.Inject

const val TAG = "MFragment"
abstract class MFragment<MODEL: MViewModel>: Fragment() {

    lateinit var model: MODEL

    @Inject
    lateinit var viewModeFactory: ViewModelFactory

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        injectFragment()

        Log.d(TAG, "instance " + this)
        Log.d(TAG, "factory " + viewModeFactory)
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        model = ViewModelProviders.of(this, this.viewModeFactory).get(getViewModelClass())
        lifecycle.addObserver(model)
        Log.d(TAG, "created fragment model " + model)

        return super.onCreateView(inflater, container, savedInstanceState)
    }

    abstract fun getViewModelClass(): Class<MODEL>
    abstract fun injectFragment()
}