/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.HttpUtils;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthMeituanRequest
extends AuthDefaultRequest {
    public AuthMeituanRequest(AuthConfig config) {
        super(config, AuthDefaultSource.MEITUAN);
    }

    public AuthMeituanRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.MEITUAN, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        HashMap<String, String> form = new HashMap<String, String>(4);
        form.put("app_id", this.config.getClientId());
        form.put("secret", this.config.getClientSecret());
        form.put("code", authCallback.getCode());
        form.put("grant_type", "authorization_code");
        String response = new HttpUtils(this.config.getHttpConfig()).post(this.source.accessToken(), form, false);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return AuthToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).expireIn(object.getIntValue("expires_in")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        HashMap<String, String> form = new HashMap<String, String>(3);
        form.put("app_id", this.config.getClientId());
        form.put("secret", this.config.getClientSecret());
        form.put("access_token", authToken.getAccessToken());
        String response = new HttpUtils(this.config.getHttpConfig()).post(this.source.userInfo(), form, false);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return AuthUser.builder().rawUserInfo(object).uuid(object.getString("openid")).username(object.getString("nickname")).nickname(object.getString("nickname")).avatar(object.getString("avatar")).gender(AuthUserGender.UNKNOWN).token(authToken).source(this.source.toString()).build();
    }

    @Override
    public AuthResponse refresh(AuthToken oldToken) {
        HashMap<String, String> form = new HashMap<String, String>(4);
        form.put("app_id", this.config.getClientId());
        form.put("secret", this.config.getClientSecret());
        form.put("refresh_token", oldToken.getRefreshToken());
        form.put("grant_type", "refresh_token");
        String response = new HttpUtils(this.config.getHttpConfig()).post(this.source.refresh(), form, false);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(AuthToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).expireIn(object.getIntValue("expires_in")).build()).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error_code")) {
            throw new AuthException(object.getString("erroe_msg"));
        }
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(super.authorize(state)).queryParam("scope", "").build();
    }
}

