/*
 * Decompiled with CFR 0.152.
 */
package me.zheteng.countrycodeselector;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import me.zheteng.countrycodeselector.Country;
import me.zheteng.countrycodeselector.CountryCodeSelectorActivity;
import me.zheteng.countrycodeselector.CountryCodeSelectorFragment;
import me.zheteng.countrycodeselector.CountryListManager;
import me.zheteng.countrycodeselector.R;

public class PhoneInputView
extends FrameLayout {
    public static final String ACTION_SEND_RESULT = "me.zheteng.countrycodeselector.action.SendResult";
    public static final String EXTRA_COUNTRY = "me.zheteng.countrycodeselector.extra.Country";
    public static final String EXTRA_THEME_COLOR = "me.zheteng.countrycodeselector.extra.ThemeColor";
    public static final String EXTRA_SELECTOR_TYPE = "me.zheteng.countrycodeselector.extra.Type";
    public static final int SELECTOR_TYPE_ACTIVITY = 0;
    public static final int SELECTOR_TYPE_DIALOG = 1;
    private int mThemeColor;
    private int mCountrySelectorType;
    private EditText mPhoneNumber;
    private EditText mCountryCode;
    private Context mContext;
    private TextView mCountryName;
    private final View.OnClickListener mOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (v == PhoneInputView.this.mCountryName) {
                PhoneInputView.this.onCountryNameClicked();
            }
        }
    };
    private BroadcastReceiver mResultReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            Country country = (Country)intent.getParcelableExtra(PhoneInputView.EXTRA_COUNTRY);
            PhoneInputView.this.mCountryName.setText((CharSequence)country.getName());
            PhoneInputView.this.mCountryCode.setText((CharSequence)country.getCode());
            PhoneInputView.this.mPhoneNumber.requestFocus();
        }
    };
    private TextWatcher mTextWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int before, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int after) {
            if (s.length() == 0) {
                PhoneInputView.this.mCountryName.setText(R.string.ccs_choose_a_country);
            } else {
                Country country = PhoneInputView.this.getCountryByCode(s.toString());
                if (country != null) {
                    PhoneInputView.this.mCountryName.setText((CharSequence)country.getName());
                    PhoneInputView.this.mPhoneNumber.requestFocus();
                } else {
                    PhoneInputView.this.mCountryName.setText(R.string.ccs_invalid_country_code);
                }
            }
        }

        public void afterTextChanged(Editable s) {
        }
    };

    public PhoneInputView(Context context) {
        this(context, null);
    }

    public PhoneInputView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PhoneInputView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        Drawable[] drawables;
        this.mContext = context;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ccs_PhoneInputView, defStyleAttr, 0);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        int layoutResId = a.getResourceId(R.styleable.ccs_PhoneInputView_ccs_layout, R.layout.ccs_phone_input_view);
        inflater.inflate(layoutResId, (ViewGroup)this, true);
        this.mCountryName = (TextView)this.findViewById(R.id.select_country);
        this.mCountryCode = (EditText)this.findViewById(R.id.edit_country_code);
        this.mPhoneNumber = (EditText)this.findViewById(R.id.edit_phone_number);
        this.mThemeColor = a.getColor(R.styleable.ccs_PhoneInputView_ccs_theme_color, ContextCompat.getColor((Context)context, (int)R.color.ccs_default_color));
        this.mCountryName.getBackground().setColorFilter(this.mThemeColor, PorterDuff.Mode.SRC_ATOP);
        for (Drawable drawable : drawables = this.mCountryName.getCompoundDrawables()) {
            if (drawable == null) continue;
            drawable.setColorFilter(this.mThemeColor, PorterDuff.Mode.SRC_ATOP);
        }
        this.mPhoneNumber.getBackground().setColorFilter(this.mThemeColor, PorterDuff.Mode.SRC_ATOP);
        this.mCountryCode.getBackground().setColorFilter(this.mThemeColor, PorterDuff.Mode.SRC_ATOP);
        this.mCountrySelectorType = a.getInt(R.styleable.ccs_PhoneInputView_ccs_country_selector_type, 0);
        this.mCountryName.setOnClickListener(this.mOnClickListener);
        this.mCountryCode.addTextChangedListener(this.mTextWatcher);
        this.mCountryCode.setText((CharSequence)"1");
        a.recycle();
    }

    public String getPhoneNumber() {
        return this.mPhoneNumber.getText().toString();
    }

    public String getCountryCode() {
        return this.mCountryCode.getText().toString();
    }

    public void setCountryCode(@IntRange(from=1L, to=999L) int code) {
        this.mCountryCode.setText((CharSequence)("" + code));
    }

    public void setThemeColor(@ColorInt int color2) {
        this.mThemeColor = color2;
    }

    @ColorInt
    public int getThemeColor() {
        return this.mThemeColor;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        IntentFilter filter = new IntentFilter(ACTION_SEND_RESULT);
        this.mContext.registerReceiver(this.mResultReceiver, filter);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mContext.unregisterReceiver(this.mResultReceiver);
    }

    private Country getCountryByCode(String s) {
        List<Country> list = CountryListManager.from(this.getContext()).getList();
        if (list == null) {
            return null;
        }
        ArrayList<Country> tmp = new ArrayList<Country>();
        for (Country country : list) {
            if (!country.getCode().equals(s)) continue;
            tmp.add(country);
        }
        if (tmp.size() == 1) {
            return (Country)tmp.get(0);
        }
        if (tmp.size() == 0) {
            return null;
        }
        for (Country country : tmp) {
            if (country.getPhonePatterns() == null) continue;
            return country;
        }
        return (Country)tmp.get(0);
    }

    private void onCountryNameClicked() {
        if (this.mCountrySelectorType == 0) {
            Intent intent = new Intent(this.mContext, CountryCodeSelectorActivity.class);
            intent.putExtra(EXTRA_THEME_COLOR, this.mThemeColor);
            intent.putExtra(EXTRA_SELECTOR_TYPE, 0);
            this.mContext.startActivity(intent);
        } else if (this.mCountrySelectorType == 1) {
            if (this.mContext instanceof FragmentActivity) {
                FragmentActivity context = (FragmentActivity)this.mContext;
                Intent intent = new Intent();
                intent.putExtra(EXTRA_THEME_COLOR, this.mThemeColor);
                intent.putExtra(EXTRA_SELECTOR_TYPE, 1);
                final CountryCodeSelectorFragment picker = CountryCodeSelectorFragment.newInstance(intent);
                picker.show(context.getSupportFragmentManager(), "COUNTRY_CODE_PICKER");
                picker.setOnCountrySelectListener(new CountryCodeSelectorFragment.OnCountrySelectListener(){

                    @Override
                    public void onCountrySelect(Country country) {
                        picker.dismiss();
                    }
                });
            } else {
                throw new IllegalStateException("Activity should be instance of FragmentActivity");
            }
        }
    }

    public void setCountrySelectorType(@SelectorType int selectorType) {
        this.mCountrySelectorType = selectorType;
    }

    public int getCountrySelectorType() {
        return this.mCountrySelectorType;
    }

    public static @interface SelectorType {
    }
}

