/*
 * Decompiled with CFR 0.152.
 */
package me.zheteng.countrycodeselector;

import android.content.Context;
import com.univocity.parsers.tsv.TsvFormat;
import com.univocity.parsers.tsv.TsvParser;
import com.univocity.parsers.tsv.TsvParserSettings;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.zheteng.countrycodeselector.Country;
import me.zheteng.countrycodeselector.R;

public class CountryListManager {
    private List<Country> mList;
    private static CountryListManager INSTANCE;

    private CountryListManager(InputStream inputStream) {
        this.mList = this.parseCountryList(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CountryListManager from(Context context) {
        if (INSTANCE != null) return INSTANCE;
        Class<CountryListManager> clazz = CountryListManager.class;
        synchronized (CountryListManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new CountryListManager(context.getResources().openRawResource(R.raw.ccs_countries));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public List<Country> parseCountryList(InputStream is) {
        try {
            TsvParserSettings settings = new TsvParserSettings();
            ((TsvFormat)settings.getFormat()).setLineSeparator("\n");
            TsvParser parser = new TsvParser(settings);
            List allRows = parser.parseAll(is);
            ArrayList<Country> countries = new ArrayList<Country>();
            for (String[] allRow : allRows) {
                String group;
                Country country = new Country();
                country.setIsoCode(allRow[0]);
                country.setName(allRow[1]);
                country.setCode(allRow[2]);
                country.setMcc(allRow[3]);
                country.setMnc(allRow[4]);
                String pattern = allRow[7];
                if (pattern != null) {
                    String[] split = pattern.split(";");
                    country.setPhonePatterns(Arrays.asList(split));
                }
                if ((group = allRow[8]) != null) {
                    String[] split = group.split(";");
                    country.setPhonePatternGroups(Arrays.asList(split));
                }
                country.setNameInEnglish(allRow[11]);
                countries.add(country);
            }
            return countries;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public List<Country> getList() {
        return this.mList;
    }

    public synchronized void release() {
        if (this.mList != null) {
            this.mList.clear();
            this.mList = null;
            INSTANCE = null;
        }
    }
}

