/*
 * Decompiled with CFR 0.152.
 */
package me.zheteng.countrycodeselector;

import android.content.Context;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import me.zheteng.countrycodeselector.Country;
import me.zheteng.countrycodeselector.CountryListManager;
import me.zheteng.countrycodeselector.R;

public class CountryCodeSelectorFragment
extends DialogFragment
implements TextWatcher {
    private static final String TAG = "CCSFragment";
    private List<Country> mCountryList;
    private RecyclerView mRecyclerView;
    private CountryListAdapter mAdapter;
    private int mThemeColor;
    private OnCountrySelectListener mOnCountrySelectListener;
    private int mType;

    public static CountryCodeSelectorFragment newInstance(Intent intent) {
        Bundle args = intent.getExtras();
        CountryCodeSelectorFragment fragment = new CountryCodeSelectorFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle arguments = this.getArguments();
        this.mThemeColor = arguments.getInt("me.zheteng.countrycodeselector.extra.ThemeColor", ContextCompat.getColor((Context)this.getActivity(), (int)R.color.ccs_default_color));
        this.mType = arguments.getInt("me.zheteng.countrycodeselector.extra.Type");
        this.mCountryList = CountryListManager.from((Context)this.getActivity()).getList();
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.ccs_fragment_country_code_selector, container, false);
        this.mRecyclerView = (RecyclerView)view.findViewById(R.id.recycler_view);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        this.mAdapter = new CountryListAdapter();
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mAdapter.setList(this.mCountryList);
        if (this.mType == 1) {
            this.getDialog().setTitle(R.string.ccs_choose_a_country);
            int width = this.getResources().getDimensionPixelSize(R.dimen.ccs_dialog_width);
            int height = this.getResources().getDimensionPixelSize(R.dimen.ccs_dialog_height);
            this.getDialog().getWindow().setLayout(width, height);
        }
        return view;
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        this.mAdapter.setFilter(s.toString());
    }

    public void afterTextChanged(Editable s) {
    }

    public OnCountrySelectListener getOnCountrySelectListener() {
        return this.mOnCountrySelectListener;
    }

    public void setOnCountrySelectListener(OnCountrySelectListener onCountrySelectListener) {
        this.mOnCountrySelectListener = onCountrySelectListener;
    }

    public static interface OnCountrySelectListener {
        public void onCountrySelect(Country var1);
    }

    public class SearchViewHolder
    extends RecyclerView.ViewHolder {
        EditText search;

        public SearchViewHolder(View itemView) {
            super(itemView);
            this.search = (EditText)itemView.findViewById(R.id.search);
            this.search.getBackground().setColorFilter(CountryCodeSelectorFragment.this.mThemeColor, PorterDuff.Mode.SRC_ATOP);
            this.search.addTextChangedListener((TextWatcher)CountryCodeSelectorFragment.this);
        }
    }

    public class CountryViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        TextView countryName;
        TextView countryNameEnglish;
        TextView countryCode;
        ImageView active;

        public CountryViewHolder(View itemView) {
            super(itemView);
            this.countryName = (TextView)itemView.findViewById(R.id.country_name);
            this.countryNameEnglish = (TextView)itemView.findViewById(R.id.country_name_english);
            this.countryCode = (TextView)itemView.findViewById(R.id.county_code);
            this.active = (ImageView)itemView.findViewById(R.id.active);
            itemView.setOnClickListener((View.OnClickListener)this);
        }

        public void onClick(View v) {
            Country country = (Country)this.itemView.getTag();
            Intent intent = new Intent("me.zheteng.countrycodeselector.action.SendResult");
            intent.putExtra("me.zheteng.countrycodeselector.extra.Country", (Parcelable)country);
            CountryCodeSelectorFragment.this.getActivity().sendBroadcast(intent);
            if (CountryCodeSelectorFragment.this.mOnCountrySelectListener != null) {
                CountryCodeSelectorFragment.this.mOnCountrySelectListener.onCountrySelect(country);
            }
        }
    }

    public class CountryListAdapter
    extends RecyclerView.Adapter {
        public static final int VIEW_TYPE_SEARCH = 1;
        public static final int VIEW_TYPE_ITEM = 2;
        List<Country> mList;
        List<Country> mFilteredList = new ArrayList<Country>();
        int mActive;

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
            RecyclerView.ViewHolder holder = null;
            switch (viewType) {
                case 2: {
                    View view = inflater.inflate(R.layout.ccs_item_country, parent, false);
                    holder = new CountryViewHolder(view);
                    break;
                }
                case 1: {
                    View view = inflater.inflate(R.layout.ccs_item_search, parent, false);
                    holder = new SearchViewHolder(view);
                }
            }
            return holder;
        }

        public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
            if (holder instanceof CountryViewHolder) {
                CountryViewHolder viewHolder = (CountryViewHolder)holder;
                Country country = this.mFilteredList.get(position - 1);
                viewHolder.itemView.setTag((Object)country);
                viewHolder.countryName.setText((CharSequence)country.getName());
                viewHolder.countryNameEnglish.setText((CharSequence)country.getNameInEnglish());
                viewHolder.countryCode.setText((CharSequence)("+" + country.getCode()));
                if (TextUtils.equals((CharSequence)country.getName(), (CharSequence)country.getNameInEnglish())) {
                    viewHolder.countryNameEnglish.setVisibility(8);
                } else {
                    viewHolder.countryNameEnglish.setVisibility(0);
                }
                if (position == this.mActive) {
                    viewHolder.active.setVisibility(0);
                    viewHolder.countryName.setTextColor(CountryCodeSelectorFragment.this.mThemeColor);
                } else {
                    viewHolder.active.setVisibility(4);
                    viewHolder.countryName.setTextColor(ContextCompat.getColor((Context)CountryCodeSelectorFragment.this.getActivity(), (int)17170444));
                }
            } else if (holder instanceof SearchViewHolder) {
                SearchViewHolder viewHolder = (SearchViewHolder)holder;
                viewHolder.search.requestFocus();
            }
        }

        public int getItemCount() {
            return this.getListSize() + 1;
        }

        public void setList(List<Country> list) {
            this.mList = list;
            if (this.mList != null) {
                this.mFilteredList.addAll(this.mList);
            }
            this.notifyDataSetChanged();
        }

        public void setFilter(String s) {
            this.mFilteredList.clear();
            for (Country country : this.mList) {
                if (!TextUtils.isEmpty((CharSequence)s) && !country.getCode().toLowerCase().contains(s.toLowerCase()) && !country.getName().toLowerCase().contains(s.toLowerCase()) && !country.getNameInEnglish().toLowerCase().contains(s.toLowerCase())) continue;
                this.mFilteredList.add(country);
            }
            this.notifyDataSetChanged();
        }

        private int getListSize() {
            return this.mFilteredList == null ? 0 : this.mFilteredList.size();
        }

        public int getItemViewType(int position) {
            if (position == 0) {
                return 1;
            }
            return 2;
        }
    }
}

