/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialratingbar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import androidx.appcompat.content.res.AppCompatResources;
import me.zhanghai.android.materialratingbar.ClipDrawableCompat;
import me.zhanghai.android.materialratingbar.R;
import me.zhanghai.android.materialratingbar.TileDrawable;
import me.zhanghai.android.materialratingbar.internal.ThemeUtils;

public class MaterialRatingDrawable
extends LayerDrawable {
    public MaterialRatingDrawable(Context context, boolean fillBackgroundStars) {
        super(new Drawable[]{MaterialRatingDrawable.createLayerDrawableWithTintAttrRes(fillBackgroundStars ? R.drawable.mrb_star_icon_black_36dp : R.drawable.mrb_star_border_icon_black_36dp, fillBackgroundStars ? R.attr.colorControlHighlight : R.attr.colorControlNormal, context), fillBackgroundStars ? MaterialRatingDrawable.createClippedLayerDrawableWithTintColor(R.drawable.mrb_star_icon_black_36dp, 0, context) : MaterialRatingDrawable.createClippedLayerDrawableWithTintAttrRes(R.drawable.mrb_star_border_icon_black_36dp, R.attr.colorControlActivated, context), MaterialRatingDrawable.createClippedLayerDrawableWithTintAttrRes(R.drawable.mrb_star_icon_black_36dp, R.attr.colorControlActivated, context)});
        this.setId(0, 0x1020000);
        this.setId(1, 16908303);
        this.setId(2, 16908301);
    }

    private static Drawable createLayerDrawableWithTintColor(int tileRes, int tintColor, Context context) {
        TileDrawable drawable2 = new TileDrawable(AppCompatResources.getDrawable((Context)context, (int)tileRes));
        drawable2.mutate();
        drawable2.setTint(tintColor);
        return drawable2;
    }

    private static Drawable createLayerDrawableWithTintAttrRes(int tileRes, int tintAttrRes, Context context) {
        int tintColor = ThemeUtils.getColorFromAttrRes(tintAttrRes, context);
        return MaterialRatingDrawable.createLayerDrawableWithTintColor(tileRes, tintColor, context);
    }

    @SuppressLint(value={"RtlHardcoded"})
    private static Drawable createClippedLayerDrawableWithTintColor(int tileResId, int tintColor, Context context) {
        return new ClipDrawableCompat(MaterialRatingDrawable.createLayerDrawableWithTintColor(tileResId, tintColor, context), 3, 1);
    }

    @SuppressLint(value={"RtlHardcoded"})
    private static Drawable createClippedLayerDrawableWithTintAttrRes(int tileResId, int tintAttrRes, Context context) {
        return new ClipDrawableCompat(MaterialRatingDrawable.createLayerDrawableWithTintAttrRes(tileResId, tintAttrRes, context), 3, 1);
    }

    @SuppressLint(value={"RtlHardcoded"})
    private static Drawable createClippedTransparentLayerDrawable() {
        return new ClipDrawableCompat(new TileDrawable((Drawable)new ColorDrawable(0)), 3, 1);
    }

    public float getTileRatio() {
        Drawable drawable2 = this.getTileDrawableByLayerId(16908301).getDrawable();
        return (float)drawable2.getIntrinsicWidth() / (float)drawable2.getIntrinsicHeight();
    }

    public void setStarCount(int count) {
        this.getTileDrawableByLayerId(0x1020000).setTileCount(count);
        this.getTileDrawableByLayerId(16908303).setTileCount(count);
        this.getTileDrawableByLayerId(16908301).setTileCount(count);
    }

    @SuppressLint(value={"NewApi"})
    private TileDrawable getTileDrawableByLayerId(int id2) {
        Drawable layerDrawable = this.findDrawableByLayerId(id2);
        switch (id2) {
            case 0x1020000: {
                return (TileDrawable)layerDrawable;
            }
            case 16908301: 
            case 16908303: {
                ClipDrawableCompat clipDrawable = (ClipDrawableCompat)layerDrawable;
                return (TileDrawable)clipDrawable.getDrawable();
            }
        }
        throw new RuntimeException();
    }
}

