/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialratingbar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v7.widget.TintTypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.RatingBar;
import me.zhanghai.android.materialratingbar.MaterialRatingDrawable;
import me.zhanghai.android.materialratingbar.R;
import me.zhanghai.android.materialratingbar.TintableDrawable;
import me.zhanghai.android.materialratingbar.internal.DrawableCompat;

@SuppressLint(value={"AppCompatCustomView"})
public class MaterialRatingBar
extends RatingBar {
    private static final String TAG = MaterialRatingBar.class.getSimpleName();
    private TintInfo mProgressTintInfo = new TintInfo();
    private MaterialRatingDrawable mDrawable;
    private OnRatingChangeListener mOnRatingChangeListener;
    private float mLastKnownRating;

    public MaterialRatingBar(Context context) {
        super(context);
        this.init(null, 0);
    }

    public MaterialRatingBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public MaterialRatingBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    private void init(AttributeSet attrs, int defStyleAttr) {
        Context context = this.getContext();
        TintTypedArray a = TintTypedArray.obtainStyledAttributes((Context)context, (AttributeSet)attrs, (int[])R.styleable.MaterialRatingBar, (int)defStyleAttr, (int)0);
        if (a.hasValue(R.styleable.MaterialRatingBar_mrb_progressTint)) {
            this.mProgressTintInfo.mProgressTintList = a.getColorStateList(R.styleable.MaterialRatingBar_mrb_progressTint);
            this.mProgressTintInfo.mHasProgressTintList = true;
        }
        if (a.hasValue(R.styleable.MaterialRatingBar_mrb_progressTintMode)) {
            this.mProgressTintInfo.mProgressTintMode = DrawableCompat.parseTintMode(a.getInt(R.styleable.MaterialRatingBar_mrb_progressTintMode, -1), null);
            this.mProgressTintInfo.mHasProgressTintMode = true;
        }
        if (a.hasValue(R.styleable.MaterialRatingBar_mrb_secondaryProgressTint)) {
            this.mProgressTintInfo.mSecondaryProgressTintList = a.getColorStateList(R.styleable.MaterialRatingBar_mrb_secondaryProgressTint);
            this.mProgressTintInfo.mHasSecondaryProgressTintList = true;
        }
        if (a.hasValue(R.styleable.MaterialRatingBar_mrb_secondaryProgressTintMode)) {
            this.mProgressTintInfo.mSecondaryProgressTintMode = DrawableCompat.parseTintMode(a.getInt(R.styleable.MaterialRatingBar_mrb_secondaryProgressTintMode, -1), null);
            this.mProgressTintInfo.mHasSecondaryProgressTintMode = true;
        }
        if (a.hasValue(R.styleable.MaterialRatingBar_mrb_progressBackgroundTint)) {
            this.mProgressTintInfo.mProgressBackgroundTintList = a.getColorStateList(R.styleable.MaterialRatingBar_mrb_progressBackgroundTint);
            this.mProgressTintInfo.mHasProgressBackgroundTintList = true;
        }
        if (a.hasValue(R.styleable.MaterialRatingBar_mrb_progressBackgroundTintMode)) {
            this.mProgressTintInfo.mProgressBackgroundTintMode = DrawableCompat.parseTintMode(a.getInt(R.styleable.MaterialRatingBar_mrb_progressBackgroundTintMode, -1), null);
            this.mProgressTintInfo.mHasProgressBackgroundTintMode = true;
        }
        if (a.hasValue(R.styleable.MaterialRatingBar_mrb_indeterminateTint)) {
            this.mProgressTintInfo.mIndeterminateTintList = a.getColorStateList(R.styleable.MaterialRatingBar_mrb_indeterminateTint);
            this.mProgressTintInfo.mHasIndeterminateTintList = true;
        }
        if (a.hasValue(R.styleable.MaterialRatingBar_mrb_indeterminateTintMode)) {
            this.mProgressTintInfo.mIndeterminateTintMode = DrawableCompat.parseTintMode(a.getInt(R.styleable.MaterialRatingBar_mrb_indeterminateTintMode, -1), null);
            this.mProgressTintInfo.mHasIndeterminateTintMode = true;
        }
        boolean fillBackgroundStars = a.getBoolean(R.styleable.MaterialRatingBar_mrb_fillBackgroundStars, this.isIndicator());
        a.recycle();
        this.mDrawable = new MaterialRatingDrawable(this.getContext(), fillBackgroundStars);
        this.mDrawable.setStarCount(this.getNumStars());
        this.setProgressDrawable((Drawable)this.mDrawable);
    }

    public void setNumStars(int numStars) {
        super.setNumStars(numStars);
        if (this.mDrawable != null) {
            this.mDrawable.setStarCount(numStars);
        }
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int height = this.getMeasuredHeight();
        int width = Math.round((float)height * this.mDrawable.getTileRatio() * (float)this.getNumStars());
        this.setMeasuredDimension(View.resolveSizeAndState((int)width, (int)widthMeasureSpec, (int)0), height);
    }

    public void setProgressDrawable(Drawable d) {
        super.setProgressDrawable(d);
        if (this.mProgressTintInfo != null) {
            this.applyProgressTints();
        }
    }

    public void setIndeterminateDrawable(Drawable d) {
        super.setIndeterminateDrawable(d);
        if (this.mProgressTintInfo != null) {
            this.applyIndeterminateTint();
        }
    }

    @Nullable
    public ColorStateList getProgressTintList() {
        return this.mProgressTintInfo.mProgressTintList;
    }

    public void setProgressTintList(@Nullable ColorStateList tint) {
        this.mProgressTintInfo.mProgressTintList = tint;
        this.mProgressTintInfo.mHasProgressTintList = true;
        this.applyPrimaryProgressTint();
    }

    @Nullable
    public PorterDuff.Mode getProgressTintMode() {
        return this.mProgressTintInfo.mProgressTintMode;
    }

    public void setProgressTintMode(@Nullable PorterDuff.Mode tintMode) {
        this.mProgressTintInfo.mProgressTintMode = tintMode;
        this.mProgressTintInfo.mHasProgressTintMode = true;
        this.applyPrimaryProgressTint();
    }

    @Nullable
    public ColorStateList getSecondaryProgressTintList() {
        return this.mProgressTintInfo.mSecondaryProgressTintList;
    }

    public void setSecondaryProgressTintList(@Nullable ColorStateList tint) {
        this.mProgressTintInfo.mSecondaryProgressTintList = tint;
        this.mProgressTintInfo.mHasSecondaryProgressTintList = true;
        this.applySecondaryProgressTint();
    }

    @Nullable
    public PorterDuff.Mode getSecondaryProgressTintMode() {
        return this.mProgressTintInfo.mSecondaryProgressTintMode;
    }

    public void setSecondaryProgressTintMode(@Nullable PorterDuff.Mode tintMode) {
        this.mProgressTintInfo.mSecondaryProgressTintMode = tintMode;
        this.mProgressTintInfo.mHasSecondaryProgressTintMode = true;
        this.applySecondaryProgressTint();
    }

    @Nullable
    public ColorStateList getProgressBackgroundTintList() {
        return this.mProgressTintInfo.mProgressBackgroundTintList;
    }

    public void setProgressBackgroundTintList(@Nullable ColorStateList tint) {
        this.mProgressTintInfo.mProgressBackgroundTintList = tint;
        this.mProgressTintInfo.mHasProgressBackgroundTintList = true;
        this.applyProgressBackgroundTint();
    }

    @Nullable
    public PorterDuff.Mode getProgressBackgroundTintMode() {
        return this.mProgressTintInfo.mProgressBackgroundTintMode;
    }

    public void setProgressBackgroundTintMode(@Nullable PorterDuff.Mode tintMode) {
        this.mProgressTintInfo.mProgressBackgroundTintMode = tintMode;
        this.mProgressTintInfo.mHasProgressBackgroundTintMode = true;
        this.applyProgressBackgroundTint();
    }

    @Nullable
    public ColorStateList getIndeterminateTintList() {
        return this.mProgressTintInfo.mIndeterminateTintList;
    }

    public void setIndeterminateTintList(@Nullable ColorStateList tint) {
        this.mProgressTintInfo.mIndeterminateTintList = tint;
        this.mProgressTintInfo.mHasIndeterminateTintList = true;
        this.applyIndeterminateTint();
    }

    @Nullable
    public PorterDuff.Mode getIndeterminateTintMode() {
        return this.mProgressTintInfo.mIndeterminateTintMode;
    }

    public void setIndeterminateTintMode(@Nullable PorterDuff.Mode tintMode) {
        this.mProgressTintInfo.mIndeterminateTintMode = tintMode;
        this.mProgressTintInfo.mHasIndeterminateTintMode = true;
        this.applyIndeterminateTint();
    }

    private void applyProgressTints() {
        if (this.getProgressDrawable() == null) {
            return;
        }
        this.applyPrimaryProgressTint();
        this.applyProgressBackgroundTint();
        this.applySecondaryProgressTint();
    }

    private void applyPrimaryProgressTint() {
        Drawable target;
        if (this.getProgressDrawable() == null) {
            return;
        }
        if ((this.mProgressTintInfo.mHasProgressTintList || this.mProgressTintInfo.mHasProgressTintMode) && (target = this.getTintTargetFromProgressDrawable(16908301, true)) != null) {
            this.applyTintForDrawable(target, this.mProgressTintInfo.mProgressTintList, this.mProgressTintInfo.mHasProgressTintList, this.mProgressTintInfo.mProgressTintMode, this.mProgressTintInfo.mHasProgressTintMode);
        }
    }

    private void applySecondaryProgressTint() {
        Drawable target;
        if (this.getProgressDrawable() == null) {
            return;
        }
        if ((this.mProgressTintInfo.mHasSecondaryProgressTintList || this.mProgressTintInfo.mHasSecondaryProgressTintMode) && (target = this.getTintTargetFromProgressDrawable(16908303, false)) != null) {
            this.applyTintForDrawable(target, this.mProgressTintInfo.mSecondaryProgressTintList, this.mProgressTintInfo.mHasSecondaryProgressTintList, this.mProgressTintInfo.mSecondaryProgressTintMode, this.mProgressTintInfo.mHasSecondaryProgressTintMode);
        }
    }

    private void applyProgressBackgroundTint() {
        Drawable target;
        if (this.getProgressDrawable() == null) {
            return;
        }
        if ((this.mProgressTintInfo.mHasProgressBackgroundTintList || this.mProgressTintInfo.mHasProgressBackgroundTintMode) && (target = this.getTintTargetFromProgressDrawable(0x1020000, false)) != null) {
            this.applyTintForDrawable(target, this.mProgressTintInfo.mProgressBackgroundTintList, this.mProgressTintInfo.mHasProgressBackgroundTintList, this.mProgressTintInfo.mProgressBackgroundTintMode, this.mProgressTintInfo.mHasProgressBackgroundTintMode);
        }
    }

    private Drawable getTintTargetFromProgressDrawable(int layerId, boolean shouldFallback) {
        Drawable progressDrawable = this.getProgressDrawable();
        if (progressDrawable == null) {
            return null;
        }
        progressDrawable.mutate();
        Drawable layerDrawable = null;
        if (progressDrawable instanceof LayerDrawable) {
            layerDrawable = ((LayerDrawable)progressDrawable).findDrawableByLayerId(layerId);
        }
        if (layerDrawable == null && shouldFallback) {
            layerDrawable = progressDrawable;
        }
        return layerDrawable;
    }

    private void applyIndeterminateTint() {
        Drawable indeterminateDrawable = this.getIndeterminateDrawable();
        if (indeterminateDrawable == null) {
            return;
        }
        if (this.mProgressTintInfo.mHasIndeterminateTintList || this.mProgressTintInfo.mHasIndeterminateTintMode) {
            indeterminateDrawable.mutate();
            this.applyTintForDrawable(indeterminateDrawable, this.mProgressTintInfo.mIndeterminateTintList, this.mProgressTintInfo.mHasIndeterminateTintList, this.mProgressTintInfo.mIndeterminateTintMode, this.mProgressTintInfo.mHasIndeterminateTintMode);
        }
    }

    @SuppressLint(value={"NewApi"})
    private void applyTintForDrawable(Drawable drawable2, ColorStateList tintList, boolean hasTintList, PorterDuff.Mode tintMode, boolean hasTintMode) {
        if (hasTintList || hasTintMode) {
            if (hasTintList) {
                if (drawable2 instanceof TintableDrawable) {
                    ((TintableDrawable)drawable2).setTintList(tintList);
                } else {
                    Log.w((String)TAG, (String)"Drawable did not implement TintableDrawable, it won't be tinted below Lollipop");
                    if (Build.VERSION.SDK_INT >= 21) {
                        drawable2.setTintList(tintList);
                    }
                }
            }
            if (hasTintMode) {
                if (drawable2 instanceof TintableDrawable) {
                    ((TintableDrawable)drawable2).setTintMode(tintMode);
                } else {
                    Log.w((String)TAG, (String)"Drawable did not implement TintableDrawable, it won't be tinted below Lollipop");
                    if (Build.VERSION.SDK_INT >= 21) {
                        drawable2.setTintMode(tintMode);
                    }
                }
            }
            if (drawable2.isStateful()) {
                drawable2.setState(this.getDrawableState());
            }
        }
    }

    public OnRatingChangeListener getOnRatingChangeListener() {
        return this.mOnRatingChangeListener;
    }

    public void setOnRatingChangeListener(OnRatingChangeListener listener) {
        this.mOnRatingChangeListener = listener;
    }

    public synchronized void setSecondaryProgress(int secondaryProgress) {
        super.setSecondaryProgress(secondaryProgress);
        float rating = this.getRating();
        if (this.mOnRatingChangeListener != null && rating != this.mLastKnownRating) {
            this.mOnRatingChangeListener.onRatingChanged(this, rating);
        }
        this.mLastKnownRating = rating;
    }

    private static class TintInfo {
        public ColorStateList mProgressTintList;
        public PorterDuff.Mode mProgressTintMode;
        public boolean mHasProgressTintList;
        public boolean mHasProgressTintMode;
        public ColorStateList mSecondaryProgressTintList;
        public PorterDuff.Mode mSecondaryProgressTintMode;
        public boolean mHasSecondaryProgressTintList;
        public boolean mHasSecondaryProgressTintMode;
        public ColorStateList mProgressBackgroundTintList;
        public PorterDuff.Mode mProgressBackgroundTintMode;
        public boolean mHasProgressBackgroundTintList;
        public boolean mHasProgressBackgroundTintMode;
        public ColorStateList mIndeterminateTintList;
        public PorterDuff.Mode mIndeterminateTintMode;
        public boolean mHasIndeterminateTintList;
        public boolean mHasIndeterminateTintMode;

        private TintInfo() {
        }
    }

    public static interface OnRatingChangeListener {
        public void onRatingChanged(MaterialRatingBar var1, float var2);
    }
}

