/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialprogressbar;

import android.graphics.Canvas;
import android.graphics.Paint;
import me.zhanghai.android.materialprogressbar.BaseSingleCircularProgressDrawable;
import me.zhanghai.android.materialprogressbar.ShowBackgroundDrawable;

class SingleCircularProgressDrawable
extends BaseSingleCircularProgressDrawable
implements ShowBackgroundDrawable {
    private static final int LEVEL_MAX = 10000;
    private static final float START_ANGLE_MAX_NORMAL = 0.0f;
    private static final float START_ANGLE_MAX_DYNAMIC = 360.0f;
    private static final float SWEEP_ANGLE_MAX = 360.0f;
    private final float mStartAngleMax;
    private boolean mShowBackground;

    SingleCircularProgressDrawable(int style) {
        switch (style) {
            case 0: {
                this.mStartAngleMax = 0.0f;
                break;
            }
            case 1: {
                this.mStartAngleMax = 360.0f;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for style");
            }
        }
    }

    protected boolean onLevelChange(int level) {
        this.invalidateSelf();
        return true;
    }

    @Override
    public boolean getShowBackground() {
        return this.mShowBackground;
    }

    @Override
    public void setShowBackground(boolean show) {
        if (this.mShowBackground != show) {
            this.mShowBackground = show;
            this.invalidateSelf();
        }
    }

    @Override
    protected void onDrawRing(Canvas canvas, Paint paint) {
        int level = this.getLevel();
        if (level == 0) {
            return;
        }
        float ratio = (float)level / 10000.0f;
        float startAngle = ratio * this.mStartAngleMax;
        float sweepAngle = ratio * 360.0f;
        this.drawRing(canvas, paint, startAngle, sweepAngle);
        if (this.mShowBackground) {
            this.drawRing(canvas, paint, startAngle, sweepAngle);
        }
    }
}

