/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialprogressbar;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.ProgressBar;
import me.zhanghai.android.materialprogressbar.HorizontalProgressDrawable;
import me.zhanghai.android.materialprogressbar.IndeterminateHorizontalProgressDrawable;
import me.zhanghai.android.materialprogressbar.IndeterminateProgressDrawable;
import me.zhanghai.android.materialprogressbar.IntrinsicPaddingDrawable;
import me.zhanghai.android.materialprogressbar.R;
import me.zhanghai.android.materialprogressbar.ShowTrackDrawable;
import me.zhanghai.android.materialprogressbar.TintableDrawable;
import me.zhanghai.android.materialprogressbar.internal.DrawableCompat;

public class MaterialProgressBar
extends ProgressBar {
    private static final String TAG = MaterialProgressBar.class.getSimpleName();
    public static final int PROGRESS_STYLE_CIRCULAR = 0;
    public static final int PROGRESS_STYLE_HORIZONTAL = 1;
    private int mProgressStyle;
    private TintInfo mProgressTintInfo = new TintInfo();

    public MaterialProgressBar(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public MaterialProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public MaterialProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public MaterialProgressBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MaterialProgressBar, defStyleAttr, defStyleRes);
        this.mProgressStyle = a.getInt(R.styleable.MaterialProgressBar_mpb_progressStyle, 0);
        boolean setBothDrawables = a.getBoolean(R.styleable.MaterialProgressBar_mpb_setBothDrawables, false);
        boolean useIntrinsicPadding = a.getBoolean(R.styleable.MaterialProgressBar_mpb_useIntrinsicPadding, true);
        boolean showTrack = a.getBoolean(R.styleable.MaterialProgressBar_mpb_showTrack, this.mProgressStyle == 1);
        if (a.hasValue(R.styleable.MaterialProgressBar_mpb_progressTint)) {
            this.mProgressTintInfo.mProgressTintList = a.getColorStateList(R.styleable.MaterialProgressBar_mpb_progressTint);
            this.mProgressTintInfo.mHasProgressTintList = true;
        }
        if (a.hasValue(R.styleable.MaterialProgressBar_mpb_progressTintMode)) {
            this.mProgressTintInfo.mProgressTintMode = DrawableCompat.parseTintMode(a.getInt(R.styleable.MaterialProgressBar_mpb_progressTintMode, -1), null);
            this.mProgressTintInfo.mHasProgressTintMode = true;
        }
        if (a.hasValue(R.styleable.MaterialProgressBar_mpb_secondaryProgressTint)) {
            this.mProgressTintInfo.mSecondaryProgressTintList = a.getColorStateList(R.styleable.MaterialProgressBar_mpb_secondaryProgressTint);
            this.mProgressTintInfo.mHasSecondaryProgressTintList = true;
        }
        if (a.hasValue(R.styleable.MaterialProgressBar_mpb_secondaryProgressTintMode)) {
            this.mProgressTintInfo.mSecondaryProgressTintMode = DrawableCompat.parseTintMode(a.getInt(R.styleable.MaterialProgressBar_mpb_secondaryProgressTintMode, -1), null);
            this.mProgressTintInfo.mHasSecondaryProgressTintMode = true;
        }
        if (a.hasValue(R.styleable.MaterialProgressBar_mpb_progressBackgroundTint)) {
            this.mProgressTintInfo.mProgressBackgroundTintList = a.getColorStateList(R.styleable.MaterialProgressBar_mpb_progressBackgroundTint);
            this.mProgressTintInfo.mHasProgressBackgroundTintList = true;
        }
        if (a.hasValue(R.styleable.MaterialProgressBar_mpb_progressBackgroundTintMode)) {
            this.mProgressTintInfo.mProgressBackgroundTintMode = DrawableCompat.parseTintMode(a.getInt(R.styleable.MaterialProgressBar_mpb_progressBackgroundTintMode, -1), null);
            this.mProgressTintInfo.mHasProgressBackgroundTintMode = true;
        }
        if (a.hasValue(R.styleable.MaterialProgressBar_mpb_indeterminateTint)) {
            this.mProgressTintInfo.mIndeterminateTintList = a.getColorStateList(R.styleable.MaterialProgressBar_mpb_indeterminateTint);
            this.mProgressTintInfo.mHasIndeterminateTintList = true;
        }
        if (a.hasValue(R.styleable.MaterialProgressBar_mpb_indeterminateTintMode)) {
            this.mProgressTintInfo.mIndeterminateTintMode = DrawableCompat.parseTintMode(a.getInt(R.styleable.MaterialProgressBar_mpb_indeterminateTintMode, -1), null);
            this.mProgressTintInfo.mHasIndeterminateTintMode = true;
        }
        a.recycle();
        switch (this.mProgressStyle) {
            case 0: {
                if (!this.isIndeterminate() || setBothDrawables) {
                    throw new UnsupportedOperationException("Determinate circular drawable is not yet supported");
                }
                if (this.isInEditMode()) break;
                this.setIndeterminateDrawable(new IndeterminateProgressDrawable(context));
                break;
            }
            case 1: {
                if ((this.isIndeterminate() || setBothDrawables) && !this.isInEditMode()) {
                    this.setIndeterminateDrawable(new IndeterminateHorizontalProgressDrawable(context));
                }
                if (this.isIndeterminate() && !setBothDrawables) break;
                this.setProgressDrawable((Drawable)new HorizontalProgressDrawable(context));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown progress style: " + this.mProgressStyle);
            }
        }
        this.setUseIntrinsicPadding(useIntrinsicPadding);
        this.setShowTrack(showTrack);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.fixCanvasScalingWhenHardwareAccelerated();
    }

    private void fixCanvasScalingWhenHardwareAccelerated() {
        if (Build.VERSION.SDK_INT < 18 && this.isHardwareAccelerated() && this.getLayerType() != 1) {
            this.setLayerType(1, null);
        }
    }

    public int getProgressStyle() {
        return this.mProgressStyle;
    }

    public Drawable getCurrentDrawable() {
        return this.isIndeterminate() ? this.getIndeterminateDrawable() : this.getProgressDrawable();
    }

    public boolean getUseIntrinsicPadding() {
        Drawable drawable = this.getCurrentDrawable();
        if (drawable instanceof IntrinsicPaddingDrawable) {
            return ((IntrinsicPaddingDrawable)drawable).getUseIntrinsicPadding();
        }
        throw new IllegalStateException("Drawable does not implement IntrinsicPaddingDrawable");
    }

    public void setUseIntrinsicPadding(boolean useIntrinsicPadding) {
        Drawable indeterminateDrawable;
        Drawable drawable = this.getCurrentDrawable();
        if (drawable instanceof IntrinsicPaddingDrawable) {
            ((IntrinsicPaddingDrawable)drawable).setUseIntrinsicPadding(useIntrinsicPadding);
        }
        if ((indeterminateDrawable = this.getIndeterminateDrawable()) instanceof IntrinsicPaddingDrawable) {
            ((IntrinsicPaddingDrawable)indeterminateDrawable).setUseIntrinsicPadding(useIntrinsicPadding);
        }
    }

    public boolean getShowTrack() {
        Drawable drawable = this.getCurrentDrawable();
        if (drawable instanceof ShowTrackDrawable) {
            return ((ShowTrackDrawable)drawable).getShowTrack();
        }
        return false;
    }

    public void setShowTrack(boolean showTrack) {
        Drawable indeterminateDrawable;
        Drawable drawable = this.getCurrentDrawable();
        if (drawable instanceof ShowTrackDrawable) {
            ((ShowTrackDrawable)drawable).setShowTrack(showTrack);
        }
        if ((indeterminateDrawable = this.getIndeterminateDrawable()) instanceof ShowTrackDrawable) {
            ((ShowTrackDrawable)indeterminateDrawable).setShowTrack(showTrack);
        }
    }

    public void setProgressDrawable(Drawable d) {
        super.setProgressDrawable(d);
        if (this.mProgressTintInfo != null) {
            this.applyProgressTints();
        }
    }

    public void setIndeterminateDrawable(Drawable d) {
        super.setIndeterminateDrawable(d);
        if (this.mProgressTintInfo != null) {
            this.applyIndeterminateTint();
        }
    }

    @Nullable
    public ColorStateList getProgressTintList() {
        return this.mProgressTintInfo.mProgressTintList;
    }

    public void setProgressTintList(@Nullable ColorStateList tint) {
        this.mProgressTintInfo.mProgressTintList = tint;
        this.mProgressTintInfo.mHasProgressTintList = true;
        this.applyPrimaryProgressTint();
    }

    @Nullable
    public PorterDuff.Mode getProgressTintMode() {
        return this.mProgressTintInfo.mProgressTintMode;
    }

    public void setProgressTintMode(@Nullable PorterDuff.Mode tintMode) {
        this.mProgressTintInfo.mProgressTintMode = tintMode;
        this.mProgressTintInfo.mHasProgressTintMode = true;
        this.applyPrimaryProgressTint();
    }

    @Nullable
    public ColorStateList getSecondaryProgressTintList() {
        return this.mProgressTintInfo.mSecondaryProgressTintList;
    }

    public void setSecondaryProgressTintList(@Nullable ColorStateList tint) {
        this.mProgressTintInfo.mSecondaryProgressTintList = tint;
        this.mProgressTintInfo.mHasSecondaryProgressTintList = true;
        this.applySecondaryProgressTint();
    }

    @Nullable
    public PorterDuff.Mode getSecondaryProgressTintMode() {
        return this.mProgressTintInfo.mSecondaryProgressTintMode;
    }

    public void setSecondaryProgressTintMode(@Nullable PorterDuff.Mode tintMode) {
        this.mProgressTintInfo.mSecondaryProgressTintMode = tintMode;
        this.mProgressTintInfo.mHasSecondaryProgressTintMode = true;
        this.applySecondaryProgressTint();
    }

    @Nullable
    public ColorStateList getProgressBackgroundTintList() {
        return this.mProgressTintInfo.mProgressBackgroundTintList;
    }

    public void setProgressBackgroundTintList(@Nullable ColorStateList tint) {
        this.mProgressTintInfo.mProgressBackgroundTintList = tint;
        this.mProgressTintInfo.mHasProgressBackgroundTintList = true;
        this.applyProgressBackgroundTint();
    }

    @Nullable
    public PorterDuff.Mode getProgressBackgroundTintMode() {
        return this.mProgressTintInfo.mProgressBackgroundTintMode;
    }

    public void setProgressBackgroundTintMode(@Nullable PorterDuff.Mode tintMode) {
        this.mProgressTintInfo.mProgressBackgroundTintMode = tintMode;
        this.mProgressTintInfo.mHasProgressBackgroundTintMode = true;
        this.applyProgressBackgroundTint();
    }

    @Nullable
    public ColorStateList getIndeterminateTintList() {
        return this.mProgressTintInfo.mIndeterminateTintList;
    }

    public void setIndeterminateTintList(@Nullable ColorStateList tint) {
        this.mProgressTintInfo.mIndeterminateTintList = tint;
        this.mProgressTintInfo.mHasIndeterminateTintList = true;
        this.applyIndeterminateTint();
    }

    @Nullable
    public PorterDuff.Mode getIndeterminateTintMode() {
        return this.mProgressTintInfo.mIndeterminateTintMode;
    }

    public void setIndeterminateTintMode(@Nullable PorterDuff.Mode tintMode) {
        this.mProgressTintInfo.mIndeterminateTintMode = tintMode;
        this.mProgressTintInfo.mHasIndeterminateTintMode = true;
        this.applyIndeterminateTint();
    }

    private void applyProgressTints() {
        if (this.getProgressDrawable() == null) {
            return;
        }
        this.applyPrimaryProgressTint();
        this.applyProgressBackgroundTint();
        this.applySecondaryProgressTint();
    }

    private void applyPrimaryProgressTint() {
        Drawable target;
        if (this.getProgressDrawable() == null) {
            return;
        }
        if ((this.mProgressTintInfo.mHasProgressTintList || this.mProgressTintInfo.mHasProgressTintMode) && (target = this.getTintTargetFromProgressDrawable(16908301, true)) != null) {
            this.applyTintForDrawable(target, this.mProgressTintInfo.mProgressTintList, this.mProgressTintInfo.mHasProgressTintList, this.mProgressTintInfo.mProgressTintMode, this.mProgressTintInfo.mHasProgressTintMode);
        }
    }

    private void applySecondaryProgressTint() {
        Drawable target;
        if (this.getProgressDrawable() == null) {
            return;
        }
        if ((this.mProgressTintInfo.mHasSecondaryProgressTintList || this.mProgressTintInfo.mHasSecondaryProgressTintMode) && (target = this.getTintTargetFromProgressDrawable(16908303, false)) != null) {
            this.applyTintForDrawable(target, this.mProgressTintInfo.mSecondaryProgressTintList, this.mProgressTintInfo.mHasSecondaryProgressTintList, this.mProgressTintInfo.mSecondaryProgressTintMode, this.mProgressTintInfo.mHasSecondaryProgressTintMode);
        }
    }

    private void applyProgressBackgroundTint() {
        Drawable target;
        if (this.getProgressDrawable() == null) {
            return;
        }
        if ((this.mProgressTintInfo.mHasProgressBackgroundTintList || this.mProgressTintInfo.mHasProgressBackgroundTintMode) && (target = this.getTintTargetFromProgressDrawable(0x1020000, false)) != null) {
            this.applyTintForDrawable(target, this.mProgressTintInfo.mProgressBackgroundTintList, this.mProgressTintInfo.mHasProgressBackgroundTintList, this.mProgressTintInfo.mProgressBackgroundTintMode, this.mProgressTintInfo.mHasProgressBackgroundTintMode);
        }
    }

    @Nullable
    private Drawable getTintTargetFromProgressDrawable(int layerId, boolean shouldFallback) {
        Drawable progressDrawable = this.getProgressDrawable();
        if (progressDrawable == null) {
            return null;
        }
        progressDrawable.mutate();
        Drawable layerDrawable = null;
        if (progressDrawable instanceof LayerDrawable) {
            layerDrawable = ((LayerDrawable)progressDrawable).findDrawableByLayerId(layerId);
        }
        if (layerDrawable == null && shouldFallback) {
            layerDrawable = progressDrawable;
        }
        return layerDrawable;
    }

    private void applyIndeterminateTint() {
        Drawable indeterminateDrawable = this.getIndeterminateDrawable();
        if (indeterminateDrawable == null) {
            return;
        }
        if (this.mProgressTintInfo.mHasIndeterminateTintList || this.mProgressTintInfo.mHasIndeterminateTintMode) {
            indeterminateDrawable.mutate();
            this.applyTintForDrawable(indeterminateDrawable, this.mProgressTintInfo.mIndeterminateTintList, this.mProgressTintInfo.mHasIndeterminateTintList, this.mProgressTintInfo.mIndeterminateTintMode, this.mProgressTintInfo.mHasIndeterminateTintMode);
        }
    }

    @SuppressLint(value={"NewApi"})
    private void applyTintForDrawable(Drawable drawable, ColorStateList tintList, boolean hasTintList, PorterDuff.Mode tintMode, boolean hasTintMode) {
        if (hasTintList || hasTintMode) {
            if (hasTintList) {
                if (drawable instanceof TintableDrawable) {
                    ((TintableDrawable)drawable).setTintList(tintList);
                } else {
                    Log.w((String)TAG, (String)"Drawable did not implement TintableDrawable, it won't be tinted below Lollipop");
                    if (Build.VERSION.SDK_INT >= 21) {
                        drawable.setTintList(tintList);
                    }
                }
            }
            if (hasTintMode) {
                if (drawable instanceof TintableDrawable) {
                    ((TintableDrawable)drawable).setTintMode(tintMode);
                } else {
                    Log.w((String)TAG, (String)"Drawable did not implement TintableDrawable, it won't be tinted below Lollipop");
                    if (Build.VERSION.SDK_INT >= 21) {
                        drawable.setTintMode(tintMode);
                    }
                }
            }
            if (drawable.isStateful()) {
                drawable.setState(this.getDrawableState());
            }
        }
    }

    private static class TintInfo {
        public ColorStateList mProgressTintList;
        public PorterDuff.Mode mProgressTintMode;
        public boolean mHasProgressTintList;
        public boolean mHasProgressTintMode;
        public ColorStateList mSecondaryProgressTintList;
        public PorterDuff.Mode mSecondaryProgressTintMode;
        public boolean mHasSecondaryProgressTintList;
        public boolean mHasSecondaryProgressTintMode;
        public ColorStateList mProgressBackgroundTintList;
        public PorterDuff.Mode mProgressBackgroundTintMode;
        public boolean mHasProgressBackgroundTintList;
        public boolean mHasProgressBackgroundTintMode;
        public ColorStateList mIndeterminateTintList;
        public PorterDuff.Mode mIndeterminateTintMode;
        public boolean mHasIndeterminateTintList;
        public boolean mHasIndeterminateTintMode;

        private TintInfo() {
        }
    }
}

