/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialprogressbar.internal;

import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TypeEvaluator;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.support.annotation.Size;
import android.util.Property;

class ObjectAnimatorCompatBase {
    private static final int NUM_POINTS = 500;

    private ObjectAnimatorCompatBase() {
    }

    public static ObjectAnimator ofArgb(Object target, String propertyName, int ... values) {
        ObjectAnimator animator = ObjectAnimator.ofInt((Object)target, (String)propertyName, (int[])values);
        animator.setEvaluator((TypeEvaluator)new ArgbEvaluator());
        return animator;
    }

    public static <T> ObjectAnimator ofArgb(T target, Property<T, Integer> property, int ... values) {
        ObjectAnimator animator = ObjectAnimator.ofInt(target, property, (int[])values);
        animator.setEvaluator((TypeEvaluator)new ArgbEvaluator());
        return animator;
    }

    public static ObjectAnimator ofFloat(Object target, String xPropertyName, String yPropertyName, Path path) {
        float[] xValues = new float[500];
        float[] yValues = new float[500];
        ObjectAnimatorCompatBase.calculateXYValues(path, xValues, yValues);
        PropertyValuesHolder xPvh = PropertyValuesHolder.ofFloat((String)xPropertyName, (float[])xValues);
        PropertyValuesHolder yPvh = PropertyValuesHolder.ofFloat((String)yPropertyName, (float[])yValues);
        return ObjectAnimator.ofPropertyValuesHolder((Object)target, (PropertyValuesHolder[])new PropertyValuesHolder[]{xPvh, yPvh});
    }

    public static <T> ObjectAnimator ofFloat(T target, Property<T, Float> xProperty, Property<T, Float> yProperty, Path path) {
        float[] xValues = new float[500];
        float[] yValues = new float[500];
        ObjectAnimatorCompatBase.calculateXYValues(path, xValues, yValues);
        PropertyValuesHolder xPvh = PropertyValuesHolder.ofFloat(xProperty, (float[])xValues);
        PropertyValuesHolder yPvh = PropertyValuesHolder.ofFloat(yProperty, (float[])yValues);
        return ObjectAnimator.ofPropertyValuesHolder(target, (PropertyValuesHolder[])new PropertyValuesHolder[]{xPvh, yPvh});
    }

    public static ObjectAnimator ofInt(Object target, String xPropertyName, String yPropertyName, Path path) {
        int[] xValues = new int[500];
        int[] yValues = new int[500];
        ObjectAnimatorCompatBase.calculateXYValues(path, xValues, yValues);
        PropertyValuesHolder xPvh = PropertyValuesHolder.ofInt((String)xPropertyName, (int[])xValues);
        PropertyValuesHolder yPvh = PropertyValuesHolder.ofInt((String)yPropertyName, (int[])yValues);
        return ObjectAnimator.ofPropertyValuesHolder((Object)target, (PropertyValuesHolder[])new PropertyValuesHolder[]{xPvh, yPvh});
    }

    public static <T> ObjectAnimator ofInt(T target, Property<T, Integer> xProperty, Property<T, Integer> yProperty, Path path) {
        int[] xValues = new int[500];
        int[] yValues = new int[500];
        ObjectAnimatorCompatBase.calculateXYValues(path, xValues, yValues);
        PropertyValuesHolder xPvh = PropertyValuesHolder.ofInt(xProperty, (int[])xValues);
        PropertyValuesHolder yPvh = PropertyValuesHolder.ofInt(yProperty, (int[])yValues);
        return ObjectAnimator.ofPropertyValuesHolder(target, (PropertyValuesHolder[])new PropertyValuesHolder[]{xPvh, yPvh});
    }

    private static void calculateXYValues(Path path, @Size(value=500L) float[] xValues, @Size(value=500L) float[] yValues) {
        PathMeasure pathMeasure = new PathMeasure(path, false);
        float pathLength = pathMeasure.getLength();
        float[] position = new float[2];
        for (int i = 0; i < 500; ++i) {
            float distance = (float)i * pathLength / 499.0f;
            pathMeasure.getPosTan(distance, position, null);
            xValues[i] = position[0];
            yValues[i] = position[1];
        }
    }

    private static void calculateXYValues(Path path, @Size(value=500L) int[] xValues, @Size(value=500L) int[] yValues) {
        PathMeasure pathMeasure = new PathMeasure(path, false);
        float pathLength = pathMeasure.getLength();
        float[] position = new float[2];
        for (int i = 0; i < 500; ++i) {
            float distance = (float)i * pathLength / 499.0f;
            pathMeasure.getPosTan(distance, position, null);
            xValues[i] = Math.round(position[0]);
            yValues[i] = Math.round(position[1]);
        }
    }
}

