/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.fastscroll;

import android.graphics.Canvas;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import me.zhanghai.android.fastscroll.FastScroller;
import me.zhanghai.android.fastscroll.Predicate;

public abstract class SimpleViewHelper
implements FastScroller.ViewHelper {
    @Nullable
    private Runnable mOnPreDrawListener;
    @Nullable
    private Runnable mOnScrollChangedListener;
    @Nullable
    private Predicate<MotionEvent> mOnTouchEventListener;
    private boolean mListenerInterceptingTouchEvent;

    @Override
    public void addOnPreDrawListener(@Nullable Runnable listener) {
        this.mOnPreDrawListener = listener;
    }

    public void draw(@NonNull Canvas canvas) {
        if (this.mOnPreDrawListener != null) {
            this.mOnPreDrawListener.run();
        }
        this.superDraw(canvas);
    }

    @Override
    public void addOnScrollChangedListener(@Nullable Runnable listener) {
        this.mOnScrollChangedListener = listener;
    }

    public void onScrollChanged(int left, int top, int oldLeft, int oldTop) {
        this.superOnScrollChanged(left, top, oldLeft, oldTop);
        if (this.mOnScrollChangedListener != null) {
            this.mOnScrollChangedListener.run();
        }
    }

    @Override
    public void addOnTouchEventListener(@Nullable Predicate<MotionEvent> listener) {
        this.mOnTouchEventListener = listener;
    }

    public boolean onInterceptTouchEvent(@NonNull MotionEvent event) {
        if (this.mOnTouchEventListener != null && this.mOnTouchEventListener.test(event)) {
            int actionMasked = event.getActionMasked();
            if (actionMasked != 1 && actionMasked != 3) {
                this.mListenerInterceptingTouchEvent = true;
            }
            if (actionMasked != 3) {
                MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)event);
                cancelEvent.setAction(3);
                this.superOnInterceptTouchEvent(cancelEvent);
                cancelEvent.recycle();
            } else {
                this.superOnInterceptTouchEvent(event);
            }
            return true;
        }
        return this.superOnInterceptTouchEvent(event);
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (this.mOnTouchEventListener != null) {
            if (this.mListenerInterceptingTouchEvent) {
                this.mOnTouchEventListener.test(event);
                int actionMasked = event.getActionMasked();
                if (actionMasked == 1 || actionMasked == 3) {
                    this.mListenerInterceptingTouchEvent = false;
                }
                return true;
            }
            int actionMasked = event.getActionMasked();
            if (actionMasked != 0 && this.mOnTouchEventListener.test(event)) {
                if (actionMasked != 1 && actionMasked != 3) {
                    this.mListenerInterceptingTouchEvent = true;
                }
                if (actionMasked != 3) {
                    MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)event);
                    cancelEvent.setAction(3);
                    this.superOnTouchEvent(cancelEvent);
                    cancelEvent.recycle();
                } else {
                    this.superOnTouchEvent(event);
                }
                return true;
            }
        }
        return this.superOnTouchEvent(event);
    }

    @Override
    public int getScrollRange() {
        return this.computeVerticalScrollRange();
    }

    @Override
    public int getScrollOffset() {
        return this.computeVerticalScrollOffset();
    }

    @Override
    public void scrollTo(int offset) {
        this.scrollTo(this.getScrollX(), offset);
    }

    protected abstract void superDraw(@NonNull Canvas var1);

    protected abstract void superOnScrollChanged(int var1, int var2, int var3, int var4);

    protected abstract boolean superOnInterceptTouchEvent(@NonNull MotionEvent var1);

    protected abstract boolean superOnTouchEvent(@NonNull MotionEvent var1);

    protected abstract int computeVerticalScrollRange();

    protected abstract int computeVerticalScrollOffset();

    protected abstract int getScrollX();

    protected abstract void scrollTo(int var1, int var2);
}

