/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.fastscroll;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.core.util.Consumer;
import me.zhanghai.android.fastscroll.AutoMirrorDrawable;
import me.zhanghai.android.fastscroll.Md2PopupBackground;
import me.zhanghai.android.fastscroll.R;
import me.zhanghai.android.fastscroll.Utils;

public class PopupStyles {
    public static Consumer<TextView> DEFAULT = popupView -> {
        Resources resources = popupView.getResources();
        int minimumSize = resources.getDimensionPixelSize(R.dimen.afs_popup_min_size);
        popupView.setMinimumWidth(minimumSize);
        popupView.setMinimumHeight(minimumSize);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)popupView.getLayoutParams();
        layoutParams.gravity = 21;
        layoutParams.setMarginEnd(resources.getDimensionPixelOffset(R.dimen.afs_popup_margin_end));
        popupView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        Context context = popupView.getContext();
        popupView.setBackground((Drawable)new AutoMirrorDrawable(Utils.getGradientDrawableWithTintAttr(R.drawable.afs_popup_background, R.attr.colorControlActivated, context)));
        popupView.setEllipsize(TextUtils.TruncateAt.MIDDLE);
        popupView.setGravity(17);
        popupView.setIncludeFontPadding(false);
        popupView.setSingleLine(true);
        popupView.setTextColor(Utils.getColorFromAttrRes(16842809, context));
        popupView.setTextSize(0, (float)resources.getDimensionPixelSize(R.dimen.afs_popup_text_size));
    };
    public static Consumer<TextView> MD2 = popupView -> {
        Resources resources = popupView.getResources();
        popupView.setMinimumWidth(resources.getDimensionPixelSize(R.dimen.afs_md2_popup_min_width));
        popupView.setMinimumHeight(resources.getDimensionPixelSize(R.dimen.afs_md2_popup_min_height));
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)popupView.getLayoutParams();
        layoutParams.gravity = 49;
        layoutParams.setMarginEnd(resources.getDimensionPixelOffset(R.dimen.afs_md2_popup_margin_end));
        popupView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        Context context = popupView.getContext();
        popupView.setBackground((Drawable)new Md2PopupBackground(context));
        popupView.setElevation((float)resources.getDimensionPixelOffset(R.dimen.afs_md2_popup_elevation));
        popupView.setEllipsize(TextUtils.TruncateAt.MIDDLE);
        popupView.setGravity(17);
        popupView.setIncludeFontPadding(false);
        popupView.setSingleLine(true);
        popupView.setTextColor(Utils.getColorFromAttrRes(16842809, context));
        popupView.setTextSize(0, (float)resources.getDimensionPixelSize(R.dimen.afs_md2_popup_text_size));
    };

    private PopupStyles() {
    }
}

