/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.fastscroll;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class FixOnItemTouchListenerRecyclerView
extends RecyclerView {
    @NonNull
    private final OnItemTouchDispatcher mOnItemTouchDispatcher = new OnItemTouchDispatcher();

    public FixOnItemTouchListenerRecyclerView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public FixOnItemTouchListenerRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public FixOnItemTouchListenerRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        super.addOnItemTouchListener((RecyclerView.OnItemTouchListener)this.mOnItemTouchDispatcher);
    }

    public void addOnItemTouchListener(@NonNull RecyclerView.OnItemTouchListener listener) {
        this.mOnItemTouchDispatcher.addListener(listener);
    }

    public void removeOnItemTouchListener(@NonNull RecyclerView.OnItemTouchListener listener) {
        this.mOnItemTouchDispatcher.removeListener(listener);
    }

    private static class OnItemTouchDispatcher
    implements RecyclerView.OnItemTouchListener {
        @NonNull
        private final List<RecyclerView.OnItemTouchListener> mListeners = new ArrayList<RecyclerView.OnItemTouchListener>();
        @NonNull
        private final Set<RecyclerView.OnItemTouchListener> mTrackingListeners = new LinkedHashSet<RecyclerView.OnItemTouchListener>();
        @Nullable
        private RecyclerView.OnItemTouchListener mInterceptingListener;

        private OnItemTouchDispatcher() {
        }

        public void addListener(@NonNull RecyclerView.OnItemTouchListener listener) {
            this.mListeners.add(listener);
        }

        public void removeListener(@NonNull RecyclerView.OnItemTouchListener listener) {
            this.mListeners.remove(listener);
            this.mTrackingListeners.remove(listener);
            if (this.mInterceptingListener == listener) {
                this.mInterceptingListener = null;
            }
        }

        public boolean onInterceptTouchEvent(@NonNull RecyclerView recyclerView, @NonNull MotionEvent event) {
            int action = event.getAction();
            for (RecyclerView.OnItemTouchListener listener : this.mListeners) {
                boolean intercepted = listener.onInterceptTouchEvent(recyclerView, event);
                if (action == 3) {
                    this.mTrackingListeners.remove(listener);
                    continue;
                }
                if (intercepted) {
                    this.mTrackingListeners.remove(listener);
                    event.setAction(3);
                    for (RecyclerView.OnItemTouchListener trackingListener : this.mTrackingListeners) {
                        trackingListener.onInterceptTouchEvent(recyclerView, event);
                    }
                    event.setAction(action);
                    this.mTrackingListeners.clear();
                    this.mInterceptingListener = listener;
                    return true;
                }
                this.mTrackingListeners.add(listener);
            }
            return false;
        }

        public void onTouchEvent(@NonNull RecyclerView recyclerView, @NonNull MotionEvent event) {
            if (this.mInterceptingListener == null) {
                return;
            }
            this.mInterceptingListener.onTouchEvent(recyclerView, event);
            int action = event.getAction();
            if (action == 3 || action == 1) {
                this.mInterceptingListener = null;
            }
        }

        public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
            for (RecyclerView.OnItemTouchListener listener : this.mListeners) {
                listener.onRequestDisallowInterceptTouchEvent(disallowIntercept);
            }
        }
    }
}

