/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.fastscroll;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

public class FixItemDecorationRecyclerView
extends RecyclerView {
    public FixItemDecorationRecyclerView(@NonNull Context context) {
        super(context);
    }

    public FixItemDecorationRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public FixItemDecorationRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void dispatchDraw(@NonNull Canvas canvas) {
        FixItemDecoration decor;
        int i;
        int count = this.getItemDecorationCount();
        for (i = 0; i < count; ++i) {
            decor = (FixItemDecoration)super.getItemDecorationAt(i);
            decor.getItemDecoration().onDraw(canvas, (RecyclerView)this, decor.getState());
        }
        super.dispatchDraw(canvas);
        count = this.getItemDecorationCount();
        for (i = 0; i < count; ++i) {
            decor = (FixItemDecoration)super.getItemDecorationAt(i);
            decor.getItemDecoration().onDrawOver(canvas, (RecyclerView)this, decor.getState());
        }
    }

    public void addItemDecoration(@NonNull RecyclerView.ItemDecoration decor, int index) {
        super.addItemDecoration((RecyclerView.ItemDecoration)new FixItemDecoration(decor), index);
    }

    @NonNull
    public RecyclerView.ItemDecoration getItemDecorationAt(int index) {
        return ((FixItemDecoration)super.getItemDecorationAt(index)).getItemDecoration();
    }

    public void removeItemDecoration(@NonNull RecyclerView.ItemDecoration decor) {
        if (!(decor instanceof FixItemDecoration)) {
            int count = this.getItemDecorationCount();
            for (int i = 0; i < count; ++i) {
                FixItemDecoration fixDecor = (FixItemDecoration)super.getItemDecorationAt(i);
                if (fixDecor.getItemDecoration() != decor) continue;
                decor = fixDecor;
                break;
            }
        }
        super.removeItemDecoration(decor);
    }

    private static class FixItemDecoration
    extends RecyclerView.ItemDecoration {
        @NonNull
        private final RecyclerView.ItemDecoration mItemDecoration;
        private RecyclerView.State mState;

        private FixItemDecoration(@NonNull RecyclerView.ItemDecoration itemDecoration) {
            this.mItemDecoration = itemDecoration;
        }

        @NonNull
        public RecyclerView.ItemDecoration getItemDecoration() {
            return this.mItemDecoration;
        }

        public RecyclerView.State getState() {
            return this.mState;
        }

        public void onDraw(@NonNull Canvas c, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
            this.mState = state;
        }

        public void onDraw(@NonNull Canvas c, @NonNull RecyclerView parent) {
        }

        public void onDrawOver(@NonNull Canvas c, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        }

        public void onDrawOver(@NonNull Canvas c, @NonNull RecyclerView parent) {
        }

        public void getItemOffsets(@NonNull Rect outRect, int itemPosition, @NonNull RecyclerView parent) {
            this.mItemDecoration.getItemOffsets(outRect, itemPosition, parent);
        }

        public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
            this.mItemDecoration.getItemOffsets(outRect, view, parent, state);
        }
    }
}

