/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.fastscroll;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.MotionEvent;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.widget.NestedScrollView;
import me.zhanghai.android.fastscroll.FastScroller;
import me.zhanghai.android.fastscroll.SimpleViewHelper;
import me.zhanghai.android.fastscroll.ViewHelperProvider;

@SuppressLint(value={"MissingSuperCall"})
public class FastScrollNestedScrollView
extends NestedScrollView
implements ViewHelperProvider {
    @NonNull
    private final ViewHelper mViewHelper = new ViewHelper();

    public FastScrollNestedScrollView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public FastScrollNestedScrollView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public FastScrollNestedScrollView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setScrollContainer(true);
    }

    @Override
    @NonNull
    public FastScroller.ViewHelper getViewHelper() {
        return this.mViewHelper;
    }

    public void draw(@NonNull Canvas canvas) {
        this.mViewHelper.draw(canvas);
    }

    protected void onScrollChanged(int left, int top, int oldLeft, int oldTop) {
        this.mViewHelper.onScrollChanged(left, top, oldLeft, oldTop);
    }

    public boolean onInterceptTouchEvent(@NonNull MotionEvent event) {
        return this.mViewHelper.onInterceptTouchEvent(event);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NonNull MotionEvent event) {
        return this.mViewHelper.onTouchEvent(event);
    }

    private class ViewHelper
    extends SimpleViewHelper {
        private ViewHelper() {
        }

        @Override
        public int getScrollRange() {
            return super.getScrollRange() + FastScrollNestedScrollView.this.getPaddingTop() + FastScrollNestedScrollView.this.getPaddingBottom();
        }

        @Override
        protected void superDraw(@NonNull Canvas canvas) {
            FastScrollNestedScrollView.super.draw(canvas);
        }

        @Override
        protected void superOnScrollChanged(int left, int top, int oldLeft, int oldTop) {
            FastScrollNestedScrollView.super.onScrollChanged(left, top, oldLeft, oldTop);
        }

        @Override
        protected boolean superOnInterceptTouchEvent(@NonNull MotionEvent event) {
            return FastScrollNestedScrollView.super.onInterceptTouchEvent(event);
        }

        @Override
        protected boolean superOnTouchEvent(@NonNull MotionEvent event) {
            return FastScrollNestedScrollView.super.onTouchEvent(event);
        }

        @Override
        @SuppressLint(value={"RestrictedApi"})
        protected int computeVerticalScrollRange() {
            return FastScrollNestedScrollView.this.computeVerticalScrollRange();
        }

        @Override
        @SuppressLint(value={"RestrictedApi"})
        protected int computeVerticalScrollOffset() {
            return FastScrollNestedScrollView.this.computeVerticalScrollOffset();
        }

        @Override
        protected int getScrollX() {
            return FastScrollNestedScrollView.this.getScrollX();
        }

        @Override
        protected void scrollTo(int x, int y) {
            FastScrollNestedScrollView.this.scrollTo(x, y);
        }
    }
}

